
local S = minetest.get_translator("mobs_monster")

-- custom dirt monster type

local dirt_types = {

	{	nodes = {"ethereal:dry_dirt"},
		skins = {"mobs_dirt_monster3.png"},
		drops = {
			{name = "ethereal:dry_dirt", chance = 1, min = 0, max = 2},
			{name = "ethereal:charcoal_lump", chance = 2, min = 0, max = 1}
		}
	}
}

local function gen_drops(pos)
	local res = {}

	table.insert(res, {name = "default:clay_lump", chance = 4, min = 1, max = 1})
	table.insert(res, {name = "default:flint", chance = 4, min = 1, max = 1})

	if minetest.get_modpath("yams_compressed_blocks") or minetest.get_modpath("moreblocks") then
		table.insert(res,
			{name = "moreblocks:dirt_compressed", chance = 1, min = 1, max = 1}
		)
	end

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 8, min = 1, max = 1}
		)
	end

	return res
end

-- Dirt Monster by PilzAdam

mobs:register_mob("mobs_monster:dirt_monster", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	attack_animals = true,
	pathfinding = true,
	reach = 2,
	damage = 2,
	damage_max = 30,
	hp_min = 15,
	hp_max = 120,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "mobs_stone_monster.b3d",
	textures = {
		{"mobs_dirt_monster.png"},
		{"mobs_dirt_monster2.png"},
		{"mobs_dirt_monster3.png"},
	},
	blood_texture = "default_dirt.png",
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_dirtmonster",
		war_cry = "mobs_dirtmonster"
	},
	view_range = 15,
	walk_velocity = 1,
	run_velocity = 3,
	run_velocity_max = 5,
	jump = true,
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 1,
	fear_height = 4,
	animation = {
		speed_normal = 15, speed_run = 15,
		stand_start = 0, stand_end = 14,
		walk_start = 15, walk_end = 38,
		run_start = 40, run_end = 63,
		punch_start = 40, punch_end = 63
	},
	base_exp = 50,
	max_exp = 2500,

	-- check surrounding nodes and spawn a specific monster
	on_spawn = function(self)

		local pos = self.object:get_pos() ; pos.y = pos.y - 1
		local tmp

		for n = 1, #dirt_types do

			tmp = dirt_types[n]

			if minetest.find_node_near(pos, 1, tmp.nodes) then

				self.base_texture = tmp.skins
				self.object:set_properties({textures = tmp.skins})

				if tmp.drops then self.drops = tmp.drops end

				return true
			end
		end

		return true -- run only once, false/nil runs every activation
	end
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:dirt_monster",
		nodes = {"default:dirt_with_grass", "ethereal:gray_dirt", "ethereal:dry_dirt",
		"default:dirt_with_rainforest_litter", "default:dirt_with_coniferous_litter",
		"default:dry_dirt_with_dry_grass",
		"ebiomes:dirt_with_grass_med", "ebiomes:dirt_with_grass_steppe_warm",
		"ebiomes:dirt_with_grass_steppe", "ebiomes:dirt_with_grass_steppe_cold",
		"ebiomes:dirt_with_grass_cold", "ebiomes:dirt_with_grass_swamp",
		"ebiomes:dirt_with_grass_warm", "ebiomes:dry_dirt_with_grass_arid",
		"ebiomes:dry_dirt_with_grass_arid_cool", "ebiomes:peat_with_swamp_moss_yellow",
		"ebiomes:dirt_with_japanese_rainforest_litter", "ebiomes:dirt_with_forest_litter",
		"ebiomes:dirt_with_jungle_savanna_grass"},
		neighbors = {},
		min_light = 0,
		max_light = 4,
		interval = 15,
		chance = 8000,
		min_height = 0,
		max_height = 8190,
		day_toggle = false
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:dirt_monster", S("Dirt Monster"), "default_dirt.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:dirt_monster", "mobs_monster:dirt_monster")
