
local S = minetest.get_translator("mobs_monster")

-- custom particle effects

local function effect(pos, amount, texture, min_size, max_size, radius, gravity, glow)

	radius = radius or 2
	min_size = min_size or 0.5
	max_size = max_size or 1
	gravity = gravity or -10
	glow = glow or 0

	minetest.add_particlespawner({
		amount = amount,
		time = 0.25,
		minpos = pos,
		maxpos = pos,
		minvel = {x = -radius, y = -radius, z = -radius},
		maxvel = {x = radius, y = radius, z = radius},
		minacc = {x = 0, y = gravity, z = 0},
		maxacc = {x = -20, y = gravity, z = 15},
		minexptime = 0.1,
		maxexptime = 1,
		minsize = min_size,
		maxsize = max_size,
		texture = texture,
		glow = glow
	})
end

local function gen_drops(pos)
	local res = {}

	-- YAMS-TODO: change the sandstone based on where it died
	table.insert(res, {name = "default:sandstone", chance = 1, min = 2, max = 4})
	table.insert(res, {name = "default:clay_lump", chance = 4, min = 1, max = 1})
	table.insert(res, {name = "default:flint", chance = 4, min = 1, max = 1})

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 8, min = 1, max = 1}
		)
	end

	return res
end

-- Sand Monster by PilzAdam

mobs:register_mob("mobs_monster:sand_monster", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	attack_animals = true,
	pathfinding = true,
	reach = 2,
	damage = 2,
	damage_max = 30,
	hp_min = 15,
	hp_max = 120,
	armor = 100,
	yams_resists = {
		yams_electric = {damage = 200, knockback = 100},
	},
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "mobs_sand_monster.b3d",
	textures = {
		{"mobs_sand_monster.png"},
		{"mobs_sand_monster2.png"}
	},
	blood_texture = "default_desert_sand.png",
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_sandmonster",
		war_cry = "mobs_sandmonster",
	},
	walk_velocity = 1,
	run_velocity = 3,
	run_velocity_max = 5,
	view_range = 15,
	jump = true,
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 1,
	fear_height = 4,
	animation = {
		speed_normal = 15, speed_run = 15,
		stand_start = 0, stand_end = 39,
		walk_start = 41, walk_end = 72,
		run_start = 74, run_end = 105,
		punch_start = 74, punch_end = 105
	},
	base_exp = 50,
	max_exp = 2500,

--[[
	custom_attack = function(self, p)
		local pos = self.object:get_pos()
		minetest.add_item(pos, "default:sand")
	end,
]]
	on_die = function(self, pos)
		pos.y = pos.y + 0.5
		mobs:effect(pos, 30, "mobs_sand_particles.png", .1, 2, 3, 5)
		pos.y = pos.y + 0.25
		mobs:effect(pos, 30, "mobs_sand_particles.png", .1, 2, 3, 5)
	end,
--[[
	on_rightclick = function(self, clicker)

		local tool = clicker:get_wielded_item()
		local name = clicker:get_player_name()

		if tool:get_name() == "default:sand" then

			self.owner = name
			self.type = "npc"

			mobs:force_capture(self, clicker)
		end
	end,
]]
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:sand_monster",
		nodes = {"default:sand", "default:desert_sand", "default:silver_sand"},
		max_light = 4,
		interval = 15,
		chance = 8000,
		min_height = 0,
		max_height = 8190,
		day_toggle = false,
		biome_allow = {"sandstone_desert", "sandstone_desert_buffer",
		"cold_desert", "cold_desert_buffer", "desert"}
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:sand_monster", S("Sand Monster"),
		"default_desert_sand.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:sand_monster", "mobs_monster:sand_monster")
