
-- translation and custom stone monster types

local S = minetest.get_translator("mobs_monster")

local stone_types = {

	{	nodes = {"default:desert_stone"},
		skins = {"mobs_stone_monster3.png"},
		drops = {
			{name = "default:desert_cobble", chance = 1, min = 0, max = 2},
			{name = "default:iron_lump", chance = 5, min = 0, max = 2},
			{name = "default:gold_lump", chance = 5, min = 0, max = 2}
		}
	},

	{	nodes = {"default:sandstone"},
		skins = {"mobs_stone_monster4.png"},
		drops = {
			{name = "default:sandstone", chance = 1, min = 0, max = 2},
			{name = "default:tin_lump", chance = 5, min = 0, max = 2},
			{name = "default:copper_lump", chance = 5, min = 0, max = 2}
		}
	}
}

local function gen_drops(pos)
	local res = {}

	table.insert(res, {name = "default:flint", chance = 4, min = 1, max = 1})
	table.insert(res, {name = "default:coal_lump", chance = 1, min = 1, max = 1})
	if pos.y <= -128 then
		table.insert(res, {name = "default:tin_lump", chance = 8, min = 1, max = 1})
		table.insert(res, {name = "default:copper_lump", chance = 4, min = 1, max = 1})
	end

	if pos.y <= -256 then
		table.insert(res, {name = "default:iron_lump", chance = 4, min = 1, max = 1})
	end

	if minetest.get_modpath("yams_compressed_blocks") or minetest.get_modpath("moreblocks") then
		-- YAMS-TODO: implement desert cobble somehow
		table.insert(res,
			{name = "moreblocks:cobble_compressed", chance = 1, min = 1, max = 1}
		)
	end

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 4, min = 1, max = 1}
		)
	end

	return res
end

-- Stone Monster by PilzAdam

mobs:register_mob("mobs_monster:stone_monster", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	reach = 2,
	damage = 3,
	damage_max = 45,
	hp_min = 20,
	hp_max = 120,
	armor = 100,
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
	visual = "mesh",
	mesh = "mobs_stone_monster.b3d",
	textures = {
		{"mobs_stone_monster.png"},
		{"mobs_stone_monster2.png"} -- by AMMOnym
	},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_stonemonster",
		war_cry = "mobs_stonemonster",
	},
	walk_velocity = 1,
	run_velocity = 3,
	run_velocity_max = 5,
	stepheight = 1.1,
	floats = 0,
	view_range = 15,
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 1,
	fear_height = 4,
	animation = {
		speed_normal = 15, speed_run = 15,
		stand_start = 0, stand_end = 14,
		walk_start = 15, walk_end = 38,
		run_start = 40, run_end = 63,
		punch_start = 40, punch_end = 63
	},
	base_exp = 70,
	max_exp = 7000,

	-- check surrounding nodes and spawn a specific spider
	on_spawn = function(self)

		local pos = self.object:get_pos() ; pos.y = pos.y - 1
		local tmp

		for n = 1, #stone_types do

			tmp = stone_types[n]

			if minetest.find_node_near(pos, 1, tmp.nodes) then

				self.base_texture = tmp.skins
				self.object:set_properties({textures = tmp.skins})

				return true
			end
		end

		return true -- run only once, false/nil runs every activation
	end
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:stone_monster",
		nodes = {"default:stone", "default:desert_stone", "default:sandstone",
		"default:sand", "default:desert_sand", "default:silver_sand",
		"default:ice", "caverealms:stone_with_moss",
		"caverealms:stone_with_lichen", "caverealms:stone_with_algae",
		"caverealms:stone_with_salt", "caverealms:hot_cobble",
		"caverealms:thin_ice", "caverealms:glow_obsidian",
		"caverealms:glow_obsidian_2", "caverealms:coal_dust"},
		max_light = 4,
		interval = 15,
		chance = 8000,
		min_height = -19990,
		max_height = -16
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:stone_monster", S("Stone Monster"), "default_stone.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:stone_monster", "mobs_monster:stone_monster")
