
-- mineclone check

local mod_mcl = minetest.get_modpath("mcl_core")

-- jellyfish definition

mobs:register_mob("mobs_jellyfish:jellyfish", {
	type = "monster",
	attack_type = "dogfight",
	passive = false,
	damage = 4,
	reach = 1.1,
	stepheight = 0,
	hp_min = 4,
	hp_max = 8,
	armor = 100,
	visual_size = {x = 2, y = 2},
	collisionbox = {-0.2, -0.50, -0.2, 0.2, 0.50, 0.2},
	visual = "mesh",
	mesh = "jellyfish.b3d",
	textures = {
		{"jellyfish.png"}
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 1,
	fly = true,
	fly_in = "default:water_source",
	fall_speed = 0,
	view_range = 10,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 0,
	base_exp = 5,
	yams_scaling_opts = {enable_scaling = false},
})

-- Check for custom spawn.lua

mobs:spawn({
	name = "mobs_jellyfish:jellyfish",
	nodes = {"default:water_source"},
	neighbors = {"default:water_source"},
	interval = 15,
	chance = 160000,
	min_height = -32,
	max_height = -8,
})

local MP = minetest.get_modpath(minetest.get_current_modname()) .. "/"
local input = io.open(MP .. "spawn.lua", "r")

if input then
	input:close() ; input = nil ; dofile(MP .. "spawn.lua")
elseif false then
	mobs:spawn({
		name = "mobs_jellyfish:jellyfish",
		nodes = {(mod_mcl and "mcl_core:water_source" or "default:water_source")},
		neighbors = {"group:water"},
		min_light = 5,
		interval = 30,
		chance = 10000,
		max_height = 0
	})
end

-- spawn egg

mobs:register_egg("mobs_jellyfish:jellyfish", "Jellyfish", "jellyfish_inv.png", 0)

-- compatibility

minetest.register_alias("mobs_jellyfish:jellyfish_set", "mobs_jellyfish:jellyfish")


print("[MOD] Mobs Redo Jellyfish loaded")
