local is_farming_redo = minetest.get_modpath("farming") ~= nil
		and farming ~= nil and farming.mod == "redo"

local S = sickles.i18n

-- Default stat factors for all melee weapons
local melee_sf = {
	primary = "str",
	secondary = nil,
	str = 1.0,
	dex = 0.0,
	int = 0.0
}

-- Element properties for melee weapons
local default_melee_elements = {yams_physical = 100, yams_neutral = 100}

minetest.register_tool("sickles:sickle_bronze", {
	description = S("Bronze Sickle"),
	inventory_image = "sickles_sickle_bronze.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 2.75, [2] = 1.30, [3] = 0.375 }, uses = 25, maxlevel = 2 }
		},
		damage_groups = { fleshy = 4 },
		punch_attack_uses = 75
	},
	groups = { sickle = 1, sickle_uses = 225 },
	sound = { breaks = "default_tool_breaks" },
	_yams_knockback = 2,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_craft({
	output = "sickles:sickle_bronze",
	recipe = {
		{ "default:bronze_ingot", "" },
		{ "", "default:bronze_ingot" },
		{ "group:stick", "" }
	}
})

minetest.register_tool("sickles:sickle_steel", {
	description = S("Steel Sickle"),
	inventory_image = "sickles_sickle_steel.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 2.5, [2] = 1.20, [3] = 0.35 }, uses = 30, maxlevel = 2 }
		},
		damage_groups = { fleshy = 4 },
		punch_attack_uses = 90
	},
	groups = { sickle = 1, sickle_uses = 270 },
	sound = { breaks = "default_tool_breaks" },
	_yams_knockback = 2,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_craft({
	output = "sickles:sickle_steel",
	recipe = {
		{ "default:steel_ingot", "" },
		{ "", "default:steel_ingot" },
		{ "group:stick", "" }
	}
})

minetest.register_tool("sickles:sickle_gold", {
	description = S("Golden Sickle"),
	inventory_image = "sickles_sickle_gold.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level = 1,
		groupcaps = {
			snappy = { times = { [1] = 2.5, [2] = 1.20, [3] = 0.35 }, uses = 15, maxlevel = 2 }
		},
		damage_groups = { fleshy = 3 },
		punch_attack_uses = 50
	},
	groups = { sickle = 1, sickle_uses = 135 },
	sound = { breaks = "default_tool_breaks" },
	_yams_knockback = 2,
	_yams_anvil_difficulty = 1.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_craft({
	output = "sickles:sickle_gold",
	recipe = {
		{ "default:gold_ingot", "" },
		{ "", "default:gold_ingot" },
		{ "group:stick", "" }
	}
})

minetest.register_tool("sickles:scythe_bronze", {
	description = S("Bronze Scythe"),
	inventory_image = "sickles_scythe_bronze.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		damage_groups = { fleshy = 5 },
		punch_attack_uses = 75
	},
	on_place = sickles.use_scythe,
	groups = { scythe = 2, scythe_uses = 225 * 3 },
	sound = { breaks = "default_tool_breaks" },
	_tt_help = "Harvest with the Place button",
	_yams_knockback = 6,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_craft({
	output = "sickles:scythe_bronze",
	recipe = {
		{ "", "default:bronze_ingot", "default:bronze_ingot" },
		{ "default:bronze_ingot", "", "group:stick" },
		{ "", "", "group:stick" }
	}
})

minetest.register_tool("sickles:scythe_steel", {
	description = S("Steel Scythe"),
	inventory_image = "sickles_scythe_steel.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		damage_groups = { fleshy = 5 },
		punch_attack_uses = 90
	},
	on_place = sickles.use_scythe,
	groups = { scythe = 2, scythe_uses = 270 * 3 },
	sound = { breaks = "default_tool_breaks" },
	_tt_help = "Harvest with the Place button",
	_yams_knockback = 6,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_craft({
	output = "sickles:scythe_steel",
	recipe = {
		{ "", "default:steel_ingot", "default:steel_ingot" },
		{ "default:steel_ingot", "", "group:stick" },
		{ "", "", "group:stick" }
	}
})

if is_farming_redo then
	-- softly disable mithril scythe to prevent confusion
	minetest.override_item("farming:scythe_mithril", {
		groups = { not_in_creative_inventory = 1 }
	})
	minetest.clear_craft({
		output = "farming:scythe_mithril"
	})
end
