mobs:register_mob("tmw_slimes:dark_slime", {
	group_attack = true,
	type = "monster",
	passive = false,
	attack_animals = true,
	attack_npcs = true,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 8,
	damage_max = 40,
	hp_min = 40,
	hp_max = 120,
	armor = 100,
	yams_resists = {
		yams_mese = {damage = 150, knockback = 100},
		yams_light = {damage = 200, knockback = 100},
		yams_dark = {damage = -100, knockback = 0},
	},
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_land.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["dark"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["dark"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["dark"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["dark"]},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 4,
	run_velocity_max = 5,
	jump_height = 7,
	jump = true,
	view_range = 15,
	--fly_in = {"default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"},
	drops = {
		{name = "tmw_slimes:dark_goo", chance = 1, min = 1, max = 2},
	},
	water_damage = 0,
	lava_damage = 0,
	fire_damage = 0,
	light_damage = 8,
	fall_damage = 0,
	animation = {
		idle_start = 0,
		idle_end = 20,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 200,
	max_exp = 1500,
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
	end,
	on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end
})

minetest.override_item("tmw_slimes:dark_goo", {on_use = function(item, player, ...)
	if false and tmw_slimes.poisoned_players then
		tmw_slimes.poisoned_players[player:get_player_name()] = 3
		minetest.item_eat(-5)(item, player,...)
	else
		minetest.item_eat(-5)(item, player,...)
	end
end})

if minetest.get_modpath("mythology") then
	minetest.register_craft({
		type = "cooking",
		output = "mythology:evil_matter",
		recipe = "tmw_slimes:dark_goo_block",
		cooktime = 40
	})
	
end

local g = table.copy(minetest.registered_nodes["tmw_slimes:dark_goo_block"].groups)
g.harmful_slime = tmw_slimes.medium_dmg
minetest.override_item("tmw_slimes:dark_goo_block", {groups=table.copy(g)})

mobs:spawn({
	name = "tmw_slimes:dark_slime",
	nodes = {
		"nether:rack", "nether:rack_deep",
	},
	interval = 15,
	chance = 160000,
	min_height = -31000,
	max_height = -20000,
})
