local S = core.get_translator("yams_mapgen")

-- Remove the old and tedious method of getting nether lumps
-- The compressed nether brick will remain in creative mode, though
core.clear_craft({output = "nether:brick_compressed"})
core.clear_craft({output = "nether:nether_lump"})

core.register_node("yams_mapgen:rack_with_nether_ore", {
    description = S("Nether Ore"),
    tiles = {"nether_rack.png^yams_mineral_nether.png"},
    groups = {cracky = 1, level = 2, workable_with_nether_tools = 3},
    drop = "nether:nether_lump",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node("yams_mapgen:rack_deep_with_nether_ore", {
    description = S("Deep Nether Ore"),
    tiles = {"nether_rack_deep.png^yams_mineral_nether.png"},
    groups = {cracky = 1, level = 2, workable_with_nether_tools = 3},
    drop = "nether:nether_lump",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node("yams_mapgen:rack_with_gold", {
    description = S("Gold Ore [Nether]"),
    tiles = {"nether_rack.png^default_mineral_gold.png"},
    groups = {cracky = 1, level = 2, workable_with_nether_tools = 3},
    drop = "default:gold_lump",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node("yams_mapgen:rack_with_diamond", {
    description = S("Diamond Ore [Nether]"),
    tiles = {"nether_rack.png^default_mineral_diamond.png"},
    groups = {cracky = 1, level = 2, workable_with_nether_tools = 3},
    drop = "default:diamond",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node("yams_mapgen:rack_deep_with_mese", {
    description = S("Mese Ore [Nether]"),
    tiles = {"nether_rack_deep.png^default_mineral_mese.png"},
    groups = {cracky = 1, level = 2, workable_with_nether_tools = 3},
    drop = "default:mese_crystal",
    sounds = default.node_sound_stone_defaults(),
})

core.register_node("yams_mapgen:rack_deep_with_mithril", {
    description = S("Mithril Ore [Nether]"),
    tiles = {"nether_rack_deep.png^moreores_mineral_mithril.png"},
    groups = {cracky = 1, level = 2, workable_with_nether_tools = 3},
    drop = "moreores:mithril_lump",
    sounds = default.node_sound_stone_defaults(),
})

local ores = {"yams_mapgen:rack_with_nether_ore",
              "yams_mapgen:rack_deep_with_nether_ore",
              "yams_mapgen:rack_with_gold",
              "yams_mapgen:rack_with_diamond",
              "yams_mapgen:rack_deep_with_mese",
              "yams_mapgen:rack_deep_with_mithril",
             }

for _, ore_name in ipairs(ores) do
    core.override_item(ore_name, {
        on_dig = function(pos, node, digger)
            if core.node_dig(pos, node, digger) then
                local exp = 40  -- A little more than digging ores at -2048

                -- Add more exp only after -22000 since the portal location is
                -- rather random
                if pos.y <= -22000 then
                    exp = exp + math.floor((math.abs(pos.y) - 22000) / 64)
                end

                yams.add_exp(digger, exp, "digging")
            end
        end
    })
end

-- Nether lumps

-- s = clust_scarcity, n = clust_num_ores, c = clust_size
local nether_defs = {{s = 11, n = 1, c = 2, y_max = -20000, y_min = -31000},
                     {s = 15, n = 4, c = 4, y_max = -20000, y_min = -31000},
                     {s = 24, n = 10, c = 5, y_max = -24000, y_min = -31000},
                     {s = 32, n = 18, c = 6, y_max = -28000, y_min = -31000}}

for _, def in ipairs(nether_defs) do
    core.register_ore({
        ore_type       = "scatter",
        ore            = "yams_mapgen:rack_with_nether_ore",
        wherein        = "nether:rack",
        clust_scarcity = def.s ^ 3,
        clust_num_ores = def.n,
        clust_size     = def.c,
        y_max          = def.y_max,
        y_min          = def.y_min,
    })

    core.register_ore({
        ore_type       = "scatter",
        ore            = "yams_mapgen:rack_deep_with_nether_ore",
        wherein        = "nether:rack_deep",
        clust_scarcity = def.s ^ 3,
        clust_num_ores = def.n,
        clust_size     = def.c,
        y_max          = def.y_max,
        y_min          = def.y_min,
    })
end

-- Gold

local gold_defs = {{s = 24, n = 1, c = 2, y_max = -20000, y_min = -31000},
                   {s = 20, n = 3, c = 3, y_max = -20000, y_min = -31000},
                   {s = 28, n = 6, c = 4, y_max = -24000, y_min = -31000},
                   {s = 36, n = 10, c = 5, y_max = -28000, y_min = -31000}}

for _, def in ipairs(gold_defs) do
    core.register_ore({
        ore_type       = "scatter",
        ore            = "yams_mapgen:rack_with_gold",
        wherein        = "nether:rack",
        clust_scarcity = def.s ^ 3,
        clust_num_ores = def.n,
        clust_size     = def.c,
        y_max          = def.y_max,
        y_min          = def.y_min,
    })
end

-- Mese crystal

local mese_defs = {{s = 24, n = 2, c = 2, y_max = -20000, y_min = -31000},
                   {s = 20, n = 5, c = 3, y_max = -20000, y_min = -31000},
                   {s = 28, n = 8, c = 5, y_max = -24000, y_min = -31000},
                   {s = 36, n = 11, c = 6, y_max = -28000, y_min = -31000}}

for _, def in ipairs(mese_defs) do
    core.register_ore({
        ore_type       = "scatter",
        ore            = "yams_mapgen:rack_deep_with_mese",
        wherein        = "nether:rack_deep",
        clust_scarcity = def.s ^ 3,
        clust_num_ores = def.n,
        clust_size     = def.c,
        y_max          = def.y_max,
        y_min          = def.y_min,
    })
end

-- Diamond

local diamond_defs = {{s = 24, n = 1, c = 2, y_max = -24000, y_min = -31000},
                      {s = 24, n = 3, c = 3, y_max = -28000, y_min = -31000}}

for _, def in ipairs(diamond_defs) do
    core.register_ore({
        ore_type       = "scatter",
        ore            = "yams_mapgen:rack_with_diamond",
        wherein        = "nether:rack",
        clust_scarcity = def.s ^ 3,
        clust_num_ores = def.n,
        clust_size     = def.c,
        y_max          = def.y_max,
        y_min          = def.y_min,
    })
end

-- Mithril

local mithril_defs = {{s = 28, n = 1, c = 2, y_max = -24000, y_min = -31000},
                      {s = 28, n = 3, c = 3, y_max = -28000, y_min = -31000}}

for _, def in ipairs(mithril_defs) do
    core.register_ore({
        ore_type       = "scatter",
        ore            = "yams_mapgen:rack_deep_with_mithril",
        wherein        = "nether:rack_deep",
        clust_scarcity = def.s ^ 3,
        clust_num_ores = def.n,
        clust_size     = def.c,
        y_max          = def.y_max,
        y_min          = def.y_min,
    })
end
