-- Translation support
local S = core.get_translator("yams_mobs")

local function gen_drops(pos)
    local res = {}

    table.insert(res,
        {name = "default:obsidian_shard", chance = 1, min = 2, max = 4}
    )
    table.insert(res,
        {name = "default:mese_crystal_fragment", chance = 2, min = 1, max = 4}
    )

    if core.get_modpath("magic_materials") then
        table.insert(res,
            {name = "magic_materials:egerum_crystal", chance = 4, min = 1, max = 1}
        )
    end

    if core.get_modpath("nether") then
        table.insert(res,
            {name = "nether:nether_lump", chance = 16, min = 1, max = 1}
        )
    end

    return res
end

mobs:register_mob("yams_mobs:nether_crawler", {
    type = "monster",
    passive = false,
    attack_type = "dogfight",
    attack_animals = true,
    pathfinding = true,
    reach = 2,
    damage = 12,
    damage_max = 60,
    yams_melee_effects = {
        {name = "yams_effects:plague", duration = 30, chance = 100},
    },
    hp_min = 21,
    hp_max = 70,
    armor = 100,
    yams_resists = {
        yams_fire = {damage = 50, knockback = 50},
        yams_mese = {damage = 150, knockback = 100},
        yams_light = {damage = 200, knockback = 100},
        yams_dark = {damage = -100, knockback = 0},
    },
    collisionbox = {-0.3, -0.1, -0.3, 0.3, 0.6, 0.3},
    visual = "mesh",
    visual_size = {x = 7, y = 7},
    rotate = 270,
    mesh = "nether_crawler.x",
    textures = {
        {"yams_nether_crawler.png"},
    },
    makes_footstep_sound = true,
    sounds = {
        war_cry = "yams_nether_crawler",
        attack = "yams_nether_crawler",
    },
    view_range = 15,
    walk_velocity = 0.5,
    run_velocity = 5,
    run_velocity_max = 7,
    jump = true,
    drops = gen_drops,
    fire_damage = 2,
    water_damage = 0,
    lava_damage = 4,
    light_damage = 2,
    fear_height = 4,
    animation = {
        speed_normal = 15,
        speed_run = 30,
        stand_start = 10,
        stand_end = 40,
        walk_start = 50,
        walk_end = 90,
        run_start = 50,
        run_end = 90,
        punch_start = 100,
        punch_end = 130
    },
    base_exp = 500,
    max_exp = 5000,
    on_spawn = function(self)
        self._particle_timer = 10.0
    end,
    do_custom = function(self, dtime)
        self._particle_timer = self._particle_timer + dtime
        -- 10 seconds is a long enough interval
        if self._particle_timer >= 10.0 then
            -- YAMS-TODO: same ugly solution from spider.lua
            core.add_particlespawner({
                amount = 100,
                time = 10,
                attached = self.object,
                texture = {
                    name = "[fill:1x1:#000000cc",
                    scale = 0.5,
                },
                pos = {
                    min = vector.new(-0.5, 0, -0.5),
                    max = vector.new(0.5, 0, 0.5)
                },
                vel = vector.new(0, 1, 0)
            })
            self._particle_timer = self._particle_timer - 10.0
        end
    end,
})

mobs:spawn({
    name = "yams_mobs:nether_crawler",
    nodes = {"nether:rack", "nether:rack_deep", "nether:geode"},
    interval = 15,
    chance = 12000,
    max_height = -20000
})

mobs:register_egg("yams_mobs:nether_crawler", S("Nether Crawler"),
                  "yams_nether_crawler_egg.png", 0)
