-- Translation support
local S = core.get_translator("yams_mobs")

local function gen_drops(pos)
    local res = {}

    table.insert(res, {name = "default:obsidian", chance = 1, min = 1, max = 1})

    if core.get_modpath("magic_materials") then
        table.insert(res,
            {name = "magic_materials:egerum_crystal", chance = 2, min = 1, max = 2}
        )
        table.insert(res,
            {name = "magic_materials:februm_crystal", chance = 16, min = 1, max = 1}
        )
    end

    if core.get_modpath("nether") then
        table.insert(res,
            {name = "nether:nether_lump", chance = 8, min = 1, max = 1}
        )
    end

    if core.registered_items["yams_farming:obsidian_wart"] then
        table.insert(res,
            {name = "yams_farming:obsidian_wart", chance = 4, min = 1, max = 1}
        )
    end

    return res
end

function nether_mage_counter(self)
    local yaw = self.object:get_yaw()
    local pos = self.object:get_pos()
    pos.y = pos.y + 1

    for i = 1, 8 do
        local obj = core.add_entity(pos, self.arrow)
        obj:set_properties({visual_size = {x = 0.5, y = 0.5}})

        local ent = obj:get_luaentity()

        ent.owner_id = tostring(self.object)
        ent.lastpos = self.object:get_pos()
        ent.damage = math.floor(self.arrow_damage / 2)
        ent.knockback = self.arrow_knockback
        ent.yams_arrow_effects = table.copy(self.yams_arrow_effects)
        -- Make nether mages immune to these projectiles in order to prevent
        -- a chain reaction that could bring servers to a grinding halt
        ent._mage_counter = true

        local dir = core.yaw_to_dir(yaw)
        dir = vector.multiply(dir, 3)  -- Make it dodgable if using a sword
        obj:set_velocity(dir)

        yaw = yaw + (math.pi / 4)
        if yaw >= 2 * math.pi then
            yaw = yaw - (2 * math.pi)
        end
    end

    self._counter_cooldown = 0.25
end

mobs:register_mob("yams_mobs:nether_mage", {
    type = "monster",
    passive = false,
    attack_type = "dogfight",
    attack_animals = true,
    pathfinding = true,
    reach = 2,
    damage = 8,
    damage_max = 40,
    -- Ranged attack is forced in do_custom
    arrow = "mobs_monster:oerkki_orb",  -- YAMS-TODO: define our own version
    arrow_damage = 6,
    arrow_damage_max = 30,
    yams_arrow_effects = {
        {name = "yams_effects:attack_down_medium", duration = 15, chance = 100},
        {name = "yams_effects:defense_down_medium", duration = 15, chance = 100}
    },
    shoot_interval = 0.5,
    shoot_offset = 1,
    hp_min = 42,
    hp_max = 140,
    armor = 100,
    yams_resists = {
        yams_fire = {damage = 50, knockback = 50},
        yams_mese = {damage = 150, knockback = 100},
        yams_light = {damage = 200, knockback = 100},
        yams_dark = {damage = -100, knockback = 0},
    },
    collisionbox = {-0.2, -0.1, -0.2, 0.2, 1.6, 0.2},
    visual = "mesh",
    visual_size = {x = 5, y = 5},
    rotate = 270,
    mesh = "nether_mage.x",
    textures = {
        {"yams_nether_mage.png"},
    },
    makes_footstep_sound = true,
    sounds = {
        war_cry = "yams_nether_mage",
        attack = "yams_nether_mage",
    },
    view_range = 15,
    walk_velocity = 2,
    run_velocity = 4,
    run_velocity_max = 6,
    jump = true,
    drops = gen_drops,
    fire_damage = 2,
    water_damage = 0,
    lava_damage = 4,
    light_damage = 2,
    fear_height = 4,
    animation = {
        speed_normal = 25,
        speed_run = 25,
        stand_start = 10,
        stand_end = 40,
        walk_start = 50,
        walk_end = 90,
        run_start = 120,
        run_end = 140,
        punch_start = 100,
        punch_end = 110,
        shoot_start = 100,
        shoot_end = 110,
    },
    base_exp = 2500,
    max_exp = 12000,
    on_spawn = function(self)
        self._burst_cooldown = 0.0
        self._burst_time = 0.0
        self._counter_cooldown = 0.0
        return true  -- run only once
    end,
    do_punch = function(self, hitter, _)
        local ent = hitter:get_luaentity()
        -- Immune to projectiles that the nether mage expels when hit
        if ent and ent._mage_counter then
            return false
        end

        if self._counter_cooldown <= 0 then
            nether_mage_counter(self)
        end
    end,
    do_custom = function(self, dtime, moveresult)
        if self._counter_cooldown > 0 then
            self._counter_cooldown = self._counter_cooldown - dtime
        end

        self._burst_cooldown = self._burst_cooldown - dtime

        if self.attack and self.attack:get_pos() then
            if self._burst_cooldown <= 0.0 then
                self.attack_type = "shoot"
                self._burst_time = math.random() * 3 + 1.0
                self._burst_cooldown = self._burst_time + math.random() * 5 + 1.0
                self.timer = 0

                core.sound_play("mobs_spell", {object = self.object})
            elseif self.attack_type == "shoot" then
                self._burst_time = self._burst_time - dtime
                if self._burst_time <= 0 then
                    self.attack_type = "dogfight"
                    self._burst_time = 0
                end
            end
        end
    end
})

mobs:spawn({
    name = "yams_mobs:nether_mage",
    nodes = {"nether:rack", "nether:rack_deep", "nether:geode"},
    interval = 15,
    chance = 24000,
    max_height = -20000
})

mobs:register_egg("yams_mobs:nether_mage", S("Nether Mage"),
                  "yams_nether_mage_egg.png", 0)
