-- Translation support
local S = core.get_translator("yams_mobs")

local function gen_drops(pos)
    local res = {}

    table.insert(res, {name = "default:obsidian", chance = 1, min = 1, max = 1})
    table.insert(res, {name = "default:gold_lump", chance = 16, min = 1, max = 1})

    if core.get_modpath("magic_materials") then
        table.insert(res,
            {name = "magic_materials:egerum_crystal", chance = 2, min = 1, max = 2}
        )
        table.insert(res,
            {name = "magic_materials:februm_crystal", chance = 16, min = 1, max = 1}
        )
    end

    if core.get_modpath("nether") then
        table.insert(res,
            {name = "nether:nether_lump", chance = 8, min = 1, max = 1}
        )
    end

    return res
end

-- YAMS-TODO: figure out how to adjust HP bar height
mobs:register_mob("yams_mobs:nether_warrior", {
    type = "monster",
    passive = false,
    attack_type = "dogfight",
    attack_animals = true,
    pathfinding = true,
    reach = 2,
    damage = 12,
    damage_max = 60,
    hp_min = 66,
    hp_max = 220,
    armor = 100,
    yams_resists = {
        yams_fire = {damage = 50, knockback = 50},
        yams_mese = {damage = 150, knockback = 100},
        yams_light = {damage = 200, knockback = 100},
        yams_dark = {damage = -100, knockback = 0},
    },
    collisionbox = {-0.3, -0.1, -0.3, 0.3, 1.8, 0.3},
    visual = "mesh",
    visual_size = {x = 7, y = 7},
    rotate = 270,
    mesh = "nether_warrior.x",
    textures = {
        {"yams_nether_warrior.png"},
    },
    makes_footstep_sound = true,
    sounds = {
        war_cry = "yams_nether_warrior",
        attack = "yams_nether_warrior",
    },
    view_range = 15,
    walk_velocity = 2,
    run_velocity = 4,
    run_velocity_max = 6,
    jump = true,
    drops = gen_drops,
    fire_damage = 2,
    water_damage = 0,
    lava_damage = 4,
    light_damage = 2,
    fear_height = 4,
    animation = {
        speed_normal = 15,
        speed_run = 30,
        stand_start = 10,
        stand_end = 40,
        walk_start = 50,
        walk_end = 90,
        run_start = 100,
        run_end = 120,
        punch_start = 130,
        punch_end = 160
    },
    base_exp = 2500,
    max_exp = 12000,
    on_spawn = function(self)
        self._do_evade = false
        self._evade_timer = 0.0
        self._random_evade_timer = 0.0
        return true  -- run only once
    end,
    on_knockback = function(self, kb)
        self._do_evade = true
        self._evade_timer = 0.0
        self._random_evade_timer = 0.0
    end,
    do_custom = function(self, dtime)
        if not self.attack then
            self.state = "stand"  -- In case it was in "evade" for some reason
            return
        end
    
        self._random_evade_timer = self._random_evade_timer + dtime
        if not self._do_evade and self._random_evade_timer >= 1.0 and
                not self.path.following then
            self._random_evade_timer = 0.0
            self._do_evade = true
        end

        if self._do_evade then
            self._do_evade = false

            if math.random(1, 4) == 1 then  -- 25% chance of not evading
                return
            end

            local yaw = self.object:get_yaw()

            -- Cancel out the default knockback effect of setting the mob's
            -- yaw randomly by having it face the target
            if self.attack then
                local attack_pos = self.attack:get_pos()
                if attack_pos then
                    self:yaw_to_pos(attack_pos)
                end
            end

            -- Not really sure why it's off by 90 degrees
            yaw = self.object:get_yaw()
            local dir = core.yaw_to_dir(yaw)
            local choices = {-math.pi / 4, 3 * -math.pi / 4, -math.pi / 2}
            local r = choices[math.random(1, #choices)]

            dir = vector.rotate_around_axis(dir, vector.new(0, 1, 0), r)
            dir = vector.multiply(dir, 5)
            dir.y = 2.0

            self.object:set_velocity(dir)

            -- Do not do anything until the jump is done
            self.state = "evade"
        end
        
        if self.state == "evade" then
            self._evade_timer = self._evade_timer + dtime

            -- Face the target while evading
            if self.attack then
                local attack_pos = self.attack:get_pos()
                if attack_pos then
                    self:yaw_to_pos(attack_pos)
                end
            end

            if self._evade_timer > 0.5 then
                self._evade_timer = 0.0
                self.state = "attack"
            end
        end
    end
})

mobs:spawn({
    name = "yams_mobs:nether_warrior",
    nodes = {"nether:rack", "nether:rack_deep", "nether:geode"},
    interval = 15,
    chance = 24000,
    max_height = -20000
})

mobs:register_egg("yams_mobs:nether_warrior", S("Nether Warrior"),
                  "yams_nether_warrior_egg.png", 0)
