-- Use the rock item from the 'loose_rocks' mod if it exists
-- YAMS-TODO: support the loose desert rocks item somehow
rock_item = "yams_weapons:rock"
if core.get_modpath("loose_rocks") then
    rock_item = "loose_rocks:loose_rocks_1"
end

bweapons.register_weapon({
    name = "yams_weapons:slingshot",
    description = "Slingshot",
    texture = "yams_slingshot.png",

    has_durability = true,
    uses = 60,

    anvil_repair = false,  -- Too weak to withstand a hammer

    ammo_type = rock_item,
    ammo_per_shot = 1,

    liquids_stop = true,
    stat_factors = {primary = "dex", secondary = nil,
                    str = 0.0, dex = 1.0, int = 0.0},
    elements = {yams_physical = 100, yams_neutral = 100},
    damage = 4,
    knockback = 4.0,
    shot_amount = 1,
    spread = 0.1,
    cooldown = 1.5,
    spawn_distance = 1,

    hit_flare = "tnt_smoke.png",
    hit_flare_size = 2,
    hit_glow = false,
    hit_particle = "tnt_smoke.png",
    hit_particle_glow = false,
    hit_particle_amount = 8,
    hit_particle_size = 2,
    hit_particle_velocity = 3,
    hit_particle_gravity = -10,

    -- Placeholders for now
    fire_sound = "bweapons_bows_pack_longbow_fire",
    fire_sound_gain = 1,
    reload_sound = "bweapons_bows_pack_longbow_reload",
    hit_sound = "bweapons_bows_pack_arrow_hit",
    hit_sound_gain = 0.5,

    projectile_speed = 15,
    projectile_gravity = -10,
    projectile_timeout = 5.0,

    projectile_texture = "yams_rock.png",
    projectile_visual_size = 0.3,

    recipe = {
        {{"farming:string", "default:stick"},
         {"", "default:stick"},
         {"", "default:stick"}},
    },
})

-- Only define our own rock item if the 'loose_rocks' mod is not present
if not core.get_modpath("loose_rocks") then
    bweapons.register_ammo({
        name = "yams_weapons:rock",
        description = "Rock",
        texture = "yams_rock.png",

        recipe = {{{"default:cobble"}}},
        amount = 4,
    })
end

bweapons.register_weapon({
    name = "yams_weapons:magic_wand",
    description = "Magic Wand",
    texture = "yams_wand.png",

    has_durability = true,
    uses = 60,

    anvil_repair = false,

    mana_per_use = 20,

    liquids_stop = false,
    stat_factors = {primary = "int", secondary = nil,
                    str = 0.0, dex = 0.0, int = 1.0},
    elements = {yams_magical = 100, yams_neutral = 100},
    damage = 6,
    knockback = 4.0,
    shot_amount = 1,
    spread = 0.05,
    cooldown = 1.5,
    spawn_distance = 1,
    aoe = false,

    flare = "bweapons_magic_pack_magic_flare.png",
    flare_size = 5,
    flare_glow = true,
    hit_flare = "bweapons_magic_pack_magic_hit_flare.png",
    hit_flare_size = 10,
    hit_flare_glow = true,
    hit_particle = "bweapons_magic_pack_magic_hit_particle.png",
    hit_particle_glow = true,
    hit_particle_amount = 12,
    hit_particle_size = 3,
    hit_particle_velocity = 8,
    hit_particle_gravity = -1,
    trail_particle = "bweapons_magic_pack_magic_trail.png",
    trail_particle_velocity = 2,
    trail_particle_gravity = 0,
    trail_particle_size = 1.5,
    trail_particle_amount = 2,
    trail_particle_displacement = 0.1,
    trail_particle_glow = true,

    fire_sound = "bweapons_magic_pack_magic_fire",
    fire_sound_gain = 0.75,
    reload_sound = "bweapons_magic_pack_magic_reload",
    reload_sound_gain = 0.25,
    hit_sound = "bweapons_magic_pack_magic_hit",
    hit_sound_gain = 1,

    projectile_speed = 15,
    projectile_gravity = 0,
    projectile_timeout = 5.0,

    projectile_texture = "bweapons_magic_pack_magic_projectile.png",
    projectile_glow = true,
    projectile_visual_size = 0.5,

    recipe = {
        {{"", "", "magic_materials:egerum_crystal"},
         {"", "default:stick", ""},
         {"default:stick", "", ""},
        }
    }
})

-- More powerful versions of the bow and crossbow
bweapons.register_weapon({
    name = "yams_weapons:diamond_bow",
    description = "Diamond Bow",
    texture = "yams_diamond_bow.png",
    has_durability = true,
    uses = 960,
    ammo_type = "bweapons_bows_pack:arrow",
    tool_repair = true,
    anvil_repair = true,
    anvil_difficulty = 2.0,
    stat_factors = {primary = "dex", secondary = "str",
                    str = 0.3, dex = 0.7, int = 0.0},
    elements = {yams_physical = 100, yams_neutral = 100},
    damage = 20,
    knockback = 8.0,
    spread = 0.025,
    cooldown = 2,
    hit_flare = "tnt_smoke.png",
    hit_flare_size = 2,
    hit_flare_glow = false,
    hit_particle = "tnt_smoke.png",
    hit_particle_glow = false,
    hit_particle_amount = 32,
    hit_particle_size = 2,
    hit_particle_velocity = 3,
    hit_particle_gravity = -10,
    fire_sound = "bweapons_bows_pack_longbow_fire",
    fire_sound_gain = 1,
    reload_sound = "bweapons_bows_pack_longbow_reload",
    hit_sound = "bweapons_bows_pack_arrow_hit",
    hit_sound_gain = 0.5,
    projectile_speed = 30,
    projectile_gravity = -10,
    projectile_dampening = 0,
    projectile_timeout = 10.0,
    projectile_texture = "bweapons_bows_pack_arrow_entity.png",
    projectile_glow = false,
    projectile_visual_size = 0.4,
    drop = "bweapons_bows_pack:arrow",
    drop_chance = 0.25,
    recipe = {
        {{'', 'default:diamond', 'farming:string'},
         {'default:diamond', '', 'farming:string'},
         {'', 'default:diamond', 'farming:string'}
        }
    },
})

bweapons.register_weapon({
    name = "yams_weapons:mithril_crossbow",
    description = "Mithril Crossbow",
    texture = "yams_mithril_crossbow.png",
    has_durability = true,
    uses = 1440,
    ammo_type = "bweapons_bows_pack:bolt",
    tool_repair = true,
    anvil_repair = true,
    anvil_difficulty = 3.0,
    stat_factors = {primary = "dex", secondary = nil,
                    str = 0.0, dex = 1.0, int = 0.0},
    elements = {yams_physical = 100, yams_neutral = 100},
    damage = 30,
    knockback = 8.0,
    spread = 0.01,
    cooldown = 2.5,
    hit_flare = "tnt_smoke.png",
    hit_flare_size = 2,
    hit_flare_glow = false,
    hit_particle = "tnt_smoke.png",
    hit_particle_glow = false,
    hit_particle_amount = 32,
    hit_particle_size = 2,
    hit_particle_velocity = 3,
    hit_particle_gravity = -10,
    fire_sound = "bweapons_bows_pack_crossbow_fire",
    fire_sound_gain = 1,
    reload_sound = "bweapons_bows_pack_crossbow_reload",
    hit_sound = "bweapons_bows_pack_bolt_hit",
    hit_sound_gain = 0.5,
    projectile_speed = 30,
    projectile_gravity = -10,
    projectile_dampening = 0,
    projectile_timeout = 10.0,
    projectile_texture = "bweapons_bows_pack_bolt_entity.png",
    projectile_glow = false,
    projectile_visual_size = 0.4,
    drop = "bweapons_bows_pack:bolt",
    drop_chance = 0.75,
    recipe={
        {{'moreores:mithril_ingot', 'group:wood', 'farming:string'},
         {'group:wood', 'group:wood', ''},
         {'farming:string', '', 'moreores:mithril_ingot'}
        }
    },
})

print("yams_weapons loaded")
