
local S = minetest.get_translator("mobs_animal")

-- should cows eat grass blocks and mess up the environment?

local eat_gb = minetest.settings:get_bool("mobs_animal.eat_grass_block")
local replace_what = { {"group:grass", "air", 0} }

if eat_gb then
	table.insert(replace_what, {"default:dirt_with_grass", "default:dirt", -1})
end

-- Cow by sirrobzeroone

mobs:register_mob("mobs_animal:cow", {
	type = "animal",
	passive = false,
	attack_type = "dogfight",
	attack_npcs = false,
	reach = 2,
	damage = 2,
	hp_min = 9,
	hp_max = 12,
	armor = 100,
	collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.2, 0.4},
	visual = "mesh",
	mesh = "mobs_cow.b3d",
	textures = {
		{"mobs_cow.png"},
		{"mobs_cow2.png"}
	},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_cow",
		replace = "default_dig_crumbly"
	},
	walk_velocity = 1,
	run_velocity = 2,
	jump = true,
	jump_height = 6,
	pushable = true,
	drops = {
		{name = "mobs:meat_raw", chance = 1, min = 1, max = 1},
		{name = "mobs:leather", chance = 4, min = 1, max = 1}
	},
	water_damage = 0.01,
	lava_damage = 8,
	light_damage = 0,
	animation = {
		stand_start = 0, stand_end = 30, stand_speed = 20,
		stand1_start = 35, stand1_end = 75, stand1_speed = 20,
		walk_start = 85, walk_end = 114, walk_speed = 20,
		run_start = 120, run_end = 140, run_speed = 30,
		punch_start = 145, punch_end = 160, punch_speed = 20,
		die_start = 165, die_end = 185, die_speed = 25, die_loop = false
	},
	base_exp = 10,
	follow = {
		"farming:wheat", "group:grass", "farming:barley",
		"farming:oat", "farming:rye", "default:apple", "farming:carrot"
	},
	view_range = 8,
	replace_rate = 10,
	replace_what = replace_what,
--[[
	pick_up = {"default:grass_1", "default:dry_grass_1"},
	on_pick_up = function(self, entity)

		local istack = ItemStack(entity.itemstring)

		print("-- took", istack:get_name())

		istack:take_item(1)

		return istack
	end,
]]
--	stay_near = {{"farming:straw", "group:grass"}, 10},
	fear_height = 2,

	do_custom = function(self, dtime, moveresult)
		if self._milk_cooldown > 0 then
			self._milk_cooldown = self._milk_cooldown - dtime
			if self._milk_cooldown <= 0 then
				self.gotten = false
			end
		end
	end,
	on_spawn = function(self)
		self._milk_cooldown = 0
		return true  -- Only run once per mob
	end,
	after_activate = function(self, staticdata, def, dtime)
		-- Keep producing milk while the player is away
		self._milk_cooldown = math.max(0, self._milk_cooldown - dtime)
		if self._milk_cooldown <= 0 then
			self.gotten = false
		end
	end,
	on_rightclick = function(self, clicker)

		if mobs:protect(self, clicker) then return end
		if mobs:capture_mob(self, clicker, 0, 0, 100, false, nil) then return end

		local tool = clicker:get_wielded_item()
		local name = clicker:get_player_name()
		local item = tool:get_name()

		if clicker:get_player_control().sneak then
			mobs:examine_mob(self, clicker)
			local msg = "[yams] "

			if self._milk_cooldown <= 0 then
				msg = msg .. S("The cow is ready to produce milk.")
			elseif self._milk_cooldown <= 120 then
				msg = msg .. S("The cow is almost ready to produce milk.")
			else
				msg = msg .. S("The cow does not have enough milk yet.")
			end

			minetest.chat_send_player(name, msg)

		-- milk cow with empty bucket
		elseif item == "bucket:bucket_empty"
		or item == "wooden_bucket:bucket_wood_empty"
		or item == "bucket_wooden:bucket_empty" then

			if not self.tamed then
				local msg = S("[yams] The cow refuses to let you milk it.")
				minetest.chat_send_player(name, msg)
				return
			end

			if self.child == true then
				local msg = S("[yams] The cow is too young to produce enough milk.")
				minetest.chat_send_player(name, msg)
				return
			end

			if self.gotten == true then
				local msg = S("[yams] The cow cannot produce milk yet.")
				minetest.chat_send_player(name, msg)

				return
			end

			local inv = clicker:get_inventory()

			tool:take_item()
			clicker:set_wielded_item(tool)

			-- which bucket are we using
			local ret_item = "mobs:bucket_milk"

			if item == "wooden_bucket:bucket_wood_empty"
			or item == "bucket_wooden:bucket_empty" then
				ret_item = "mobs:wooden_bucket_milk"
			end

			if inv:room_for_item("main", {name = ret_item}) then
				clicker:get_inventory():add_item("main", ret_item)
			else
				local pos = self.object:get_pos()

				pos.y = pos.y + 0.5

				minetest.add_item(pos, {name = ret_item})
			end

			self.gotten = true -- milked
			self._milk_cooldown = 60 * 10

		elseif mobs:feed_tame(self, clicker, 8, true, true) then

			local old_val = self._milk_cooldown
			self._milk_cooldown = self._milk_cooldown - 60
			if self._milk_cooldown <= 0 then
				self.gotten = false

				if old_val > 0 then  -- Prevent message spam
					local msg = S("[yams] The cow can be milked again.")
					minetest.chat_send_player(name, msg)
				end
			end
		end
	end,

	on_replace = function(self, pos, oldnode, newnode)

		-- feed_tame() does this automatically, but replacement does not
		-- YAMS-TODO: having self.food at 8 should trigger breeding mode as
		-- well, but the Mobs Redo API makes this infeasible without code
		-- duplication or a large refactoring, so the player still has to feed
		-- the cow for now
		if not self.food or self.food < 8 then
			self.food = (self.food or 0) + 1
		end

		self._milk_cooldown = self._milk_cooldown - 30
		if self._milk_cooldown <= 0 then
			self.gotten = false
		end
	end
})

-- where to spawn

if not mobs.custom_spawn_animal then

	mobs:spawn({
		name = "mobs_animal:cow",
		nodes = {"default:dirt_with_grass", "default:dry_dirt_with_dry_grass",
		"ethereal:green_dirt", "ebiomes:dirt_with_grass_med",
		"ebiomes:dirt_with_grass_steppe_warm", "ebiomes:dirt_with_grass_steppe",
		"ebiomes:dirt_with_grass_cold", "ebiomes:dirt_with_grass_warm",
		"ebiomes:dry_dirt_with_grass_arid", "ebiomes:dry_dirt_with_grass_arid_cool"},
		neighbors = {},
		min_light = 10,
		interval = 15,
		chance = 32000,
		min_height = 0,
		max_height = 8190,
		day_toggle = true,
		biome_deny = {"deciduous_forest_fruity", "deciduous_forest_woody",
		"deciduous_forest_warm", "deciduous_forest", "deciduous_forest_cold"}
	})
end

-- spawn egg

mobs:register_egg("mobs_animal:cow", S("Cow"), "mobs_cow_inv.png")

-- old mobs mod compatibility

mobs:alias_mob("mobs:cow", "mobs_animal:cow")

-- bucket of milk

minetest.register_craftitem(":mobs:bucket_milk", {
	description = S("Bucket of Milk"),
	inventory_image = "mobs_bucket_milk.png",
	stack_max = 1,
	groups = {food_milk = 1, flammable = 3}
})

mobs.add_eatable("mobs:bucket_milk", 8)

-- glass of milk and recipes
minetest.register_craftitem(":mobs:glass_milk", {
	description = S("Glass of Milk"),
	inventory_image = "mobs_glass_milk.png",
	on_use = minetest.item_eat(2, "vessels:drinking_glass"),
	groups = {food_milk_glass = 1, vessel = 1, drink = 1},
	_yams_food_effects = {
		{name = "yams_effects:attack_up_small", duration = 180},
		{name = "yams_effects:ailment_ward", duration = 60},
	},
	_yams_tt_effect_descs = {
		{
			name = S("Attack Up S"),
			desc = S("Increase damage dealt by 10% for three minutes."),
		},
		{
			name = S("Ailment Ward"),
			-- YAMS-TODO: this is not ideal for translators at all
			desc = S("Remove most negative status effects, and") .. "\n" ..
			       S("protect against status effects from an") .. "\n" ..
			       S("enemy attack once. This effect lasts 60") .. "\n" ..
			       S("seconds or until a status effect is blocked.")
		},
	}
})

mobs.add_eatable("mobs:glass_milk", 2)

minetest.register_craft({
	output = "mobs:glass_milk 4",
	recipe = {
		{"vessels:drinking_glass", "vessels:drinking_glass"},
		{"vessels:drinking_glass", "vessels:drinking_glass"},
		{"mobs:bucket_milk", ""}
	},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})

minetest.register_craft({
	output = "mobs:bucket_milk",
	recipe = {
		{"group:food_milk_glass", "group:food_milk_glass"},
		{"group:food_milk_glass", "group:food_milk_glass"},
		{"bucket:bucket_empty", ""}
	},
	replacements = {
		{"group:food_milk_glass", "vessels:drinking_glass 4"}
	}
})

-- butter and recipe

minetest.register_craftitem(":mobs:butter", {
	description = S("Butter"),
	inventory_image = "mobs_butter.png",
	on_use = minetest.item_eat(1),
	groups = {food_butter = 1}
})

mobs.add_eatable("mobs:butter", 1)

local salt_item = "default:sapling" -- some saplings are high in sodium

if minetest.get_modpath("farming") and farming and farming.mod then
	salt_item = "farming:salt"
end

minetest.register_craft({
	output = "mobs:butter",
	recipe = {{"mobs:bucket_milk", salt_item}},
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})

-- cheese wedge and recipe

minetest.register_craftitem(":mobs:cheese", {
	description = S("Cheese"),
	inventory_image = "mobs_cheese.png",
	on_use = minetest.item_eat(4),
	groups = {food_cheese = 1}
})

mobs.add_eatable("mobs:cheese", 4)

minetest.register_craft({
	type = "cooking",
	output = "mobs:cheese",
	recipe = "mobs:bucket_milk",
	cooktime = 3,
	replacements = {{"mobs:bucket_milk", "bucket:bucket_empty"}}
})

-- cheese block and recipe

minetest.register_node(":mobs:cheeseblock", {
	description = S("Cheese Block"),
	tiles = {"mobs_cheeseblock.png"},
	is_ground_content = false,
	groups = {oddly_breakable_by_hand = 3},
	sounds = mobs.node_sound_dirt_defaults()
})

minetest.register_craft({
	output = "mobs:cheeseblock",
	recipe = {
		{"group:food_cheese", "group:food_cheese", "group:food_cheese"},
		{"group:food_cheese", "group:food_cheese", "group:food_cheese"},
		{"group:food_cheese", "group:food_cheese", "group:food_cheese"}
	}
})

minetest.register_craft({
	output = "mobs:cheese 9",
	recipe = {{"mobs:cheeseblock"}}
})

-- check for either of the wood bucket mods and add compatibility

local wb = minetest.get_modpath("wooden_bucket")
local bw = minetest.get_modpath("bucket_wooden")

if wb or bw then

	local return_item = wb and "wooden_bucket:bucket_wood_empty"
			or "bucket_wooden:bucket_empty"

	minetest.register_craftitem(":mobs:wooden_bucket_milk", {
		description = S("Wooden Bucket of Milk"),
		inventory_image = "mobs_wooden_bucket_milk.png",
		stack_max = 1,
		groups = {food_milk = 1, flammable = 3}
	})

	minetest.register_craft({
		output = "mobs:glass_milk 4",
		recipe = {
			{"vessels:drinking_glass", "vessels:drinking_glass"},
			{"vessels:drinking_glass", "vessels:drinking_glass"},
			{"mobs:wooden_bucket_milk", ""}
		},
		replacements = {{"mobs:wooden_bucket_milk", return_item}}
	})

	minetest.register_craft({
		output = "mobs:wooden_bucket_milk",
		recipe = {
			{"group:food_milk_glass", "group:food_milk_glass"},
			{"group:food_milk_glass", "group:food_milk_glass"},
			{return_item, ""}
		},
		replacements = {
			{"group:food_milk_glass", "vessels:drinking_glass 4"}
		}
	})

	minetest.register_craft({
		output = "mobs:butter",
		recipe = {{"mobs:wooden_bucket_milk", salt_item}},
		replacements = {{"mobs:wooden_bucket_milk", return_item}}
	})
end
