mobs:register_mob("tmw_slimes:alien_slime", {
	group_attack = true,
	type = "monster",
	passive = false,
	attack_animals = true,
	attack_npcs = true,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 20,
	damage_max = 40,
	hp_min = 120,
	hp_max = 180,
	armor = 100,
	yams_resists = {
		yams_magical = {damage = 50, knockback = 50},
	},
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_liquid.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["alien"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["alien"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["alien"].."^[colorize:#FFF:96"},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 5,
	run_velocity_max = 6,
	jump_height = 7,
	jump = true,
	view_range = 15,
	fly = true,
	fly_in = {"air", "asteroid:atmos", "default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"},
	drops = {
		{name = "tmw_slimes:alien_goo", chance = 1, min = 1, max = 2},
	},
	water_damage = 0,
	lava_damage = 0,
	fire_damage = 0,
	light_damage = 0,
	fall_damage = 0,
	animation = {
		idle_start = 0,
		idle_end = 20,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 1250,
	max_exp = 2000,
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
	end,
	on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end
})

minetest.override_item("tmw_slimes:alien_goo", {on_use = function(item, player, ...)
	if false and tmw_slimes.poisoned_players then
		tmw_slimes.poisoned_players[player:get_player_name()] = 3
		minetest.item_eat(-5)(item, player,...)
	else
		minetest.item_eat(-5)(item, player,...)
	end
end})

local g = table.copy(minetest.registered_nodes["tmw_slimes:alien_goo_block"].groups)
g.harmful_slime = tmw_slimes.weak_dmg
minetest.override_item("tmw_slimes:alien_goo_block", {groups=table.copy(g)})

mobs:spawn({
	name = "tmw_slimes:alien_slime",
	nodes = {
		"asteroid:reddust",
		"asteroid:dust",
	},
	interval = 15,
	chance = 64000,
	min_height = 8192,
	max_height = 31000,
})
