local function gen_drops(pos)
	local res = {}

	table.insert(res, {name = "tmw_slimes:mineral_goo", chance = 1, min = 1, max = 1})
	table.insert(res, {name = "default:coal_lump", chance = 1, min = 1, max = 1})

	if pos.y <= -64 then
		table.insert(res, {name = "default:copper_lump", chance = 1, min = 1, max = 1})
		table.insert(res, {name = "default:tin_lump", chance = 1, min = 1, max = 1})
	end

	if pos.y <= -128 then
		table.insert(res, {name = "default:iron_lump", chance = 1, min = 1, max = 1})
	end

	if pos.y <= -256 then
		table.insert(res, {name = "default:gold_lump", chance = 1, min = 1, max = 1})
	end

	if pos.y <= -512 then
		table.insert(res, {name = "default:mese_crystal", chance = 1, min = 1, max = 1})
	end

	if pos.y <= -1024 then
		table.insert(res, {name = "default:diamond", chance = 1, min = 1, max = 1})
	end

	if pos.y <= -4096 and minetest.get_modpath("moreores") then
		table.insert(res, {name = "moreores:mithril_lump", chance = 1, min = 1, max = 1})
	end

	return res
end

mobs:register_mob("tmw_slimes:mineral_slime", {
	group_attack = true,
	type = "monster",
	passive = false,
	attack_animals = false,
	attack_npcs = false,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 2,
	damage_max = 20,
	hp_min = 20,
	hp_max = 100,
	armor = 100,
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_land.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["mineral"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["mineral"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["mineral"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["mineral"]},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 1.25,
	run_velocity_max = 4,
	jump_height = 7,
	jump = true,
	view_range = 15,
	--fly_in = {"default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"},
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 0,
	fall_damage = 0,
	animation = {
		idle_start = 0,
		idle_end = 20,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 25,
	max_exp = 1250,
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
	end,
	on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end
})

local output_item = "default:steel_ingot"
if minetest.registered_items["pigiron:iron_ingot"] then
	output_item = "pigiron:iron_ingot"
end

minetest.register_craft({
	type = "cooking",
	output = output_item,
	recipe = "tmw_slimes:mineral_goo"
})

mobs:spawn({
	name = "tmw_slimes:mineral_slime",
	nodes = {
		"default:stone"
	},
	interval = 15,
	chance = 256000,
	min_height = -19900,
	max_height = -16,
})
