-- Overrides for the coffee plant

-- We only need to add a seed item, override the coffee bean so that it is no
-- longer usable as a seed, and tweak some actual functionality such as
-- requiring the usage of a furnace to heat the coffee

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_coffee", {
    description = S("Coffee Seeds"),
    tiles = {"x_farming_coffee_seed.png"},
    inventory_image = "x_farming_coffee_seed.png",
    wield_image = "x_farming_coffee_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_coffee")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:coffee_1", param2 = 3})
    end
})

-- Override parts of the coffee bean item so that it cannot be used as a seed
core.override_item("farming:coffee_beans", {
    description = S("Coffee Bean"), -- singular
    groups = {compostability = 48, food_coffee = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- Make the final two stages drop seeds and rebalance to account for the new
-- seed item
core.override_item("farming:coffee_4", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:coffee_beans"}},
            {rarity = 1, items = {"farming:seed_coffee"}},
        }
    }
})

core.override_item("farming:coffee_5", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:coffee_beans"}},
            {rarity = 2, items = {"farming:coffee_beans"}},
            {rarity = 1, items = {"farming:seed_coffee"}},
            {rarity = 2, items = {"farming:seed_coffee"}}
        }
    }
})

-- Make sure that the 'sickles' mod knows what seed to take away from the player
farming.registered_plants["farming:coffee"].seed = "farming:seed_coffee"

-- Make the coffee cup a craft item instead of a node
core.unregister_item("farming:coffee_cup")

core.register_craftitem(":farming:coffee_cup", {
    description = S("Cold Cup of Coffee"),
    inventory_image = "farming_coffee_cup.png",
    groups = {vessel = 1},
})

-- Just make it a regular item; too lazy to make it placeable
core.register_craftitem("yams_farming:coffee_cup_hot", {
    description = S("Hot Cup of Coffee"),
    inventory_image = "x_farming_coffee_cup_hot.png",
    groups = {vessel = 1, drink = 1},
    on_use = core.item_eat(4),
    _yams_food_effects = {
        {name = "yams_effects:speed_up_small", duration = 180},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Speed Up S"),
            desc = S("Increase movement speed by 10% for three minutes.")
        }
    }
})

core.register_craft({
    type = "cooking",
    output = "yams_farming:coffee_cup_hot",
    recipe = "farming:coffee_cup",
    cooktime = 3,
})

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:coffee_", 5, "farming:seed_coffee"},
    })
end
