
-- translation and custom tree monster types

local S = core.get_translator("mobs_monster")

local tree_types = {

	{	nodes = {"ethereal:sakura_leaves", "ethereal:sakura_leaves2"},
		skins = {"mobs_tree_monster5.png"},
		drops = {
			{name = "default:stick", chance = 1, min = 1, max = 3},
			{name = "ethereal:sakura_leaves", chance = 1, min = 1, max = 2},
			{name = "ethereal:sakura_trunk", chance = 2, min = 1, max = 2},
			{name = "ethereal:sakura_tree_sapling", chance = 2, min = 0, max = 2}
		}
	},

	{	nodes = {"default:dirt_with_snow", "ethereal:frost_leaves"},
		skins = {"mobs_tree_monster3.png"},
		drops = {
			{name = "default:stick", chance = 1, min = 1, max = 3},
			{name = "ethereal:frost_leaves", chance = 1, min = 1, max = 2},
			{name = "ethereal:frost_tree", chance = 2, min = 1, max = 2},
			{name = "ethereal:crystal_spike", chance = 4, min = 0, max = 2}
		}, glow = 1
	},

	{	nodes = {"ebiomes:dirt_with_grass_swamp",
		         "ebiomes:peat_with_swamp_moss_yellow",
		         "ethereal:yellowleaves"},
		skins = {"mobs_tree_monster4.png"},
		drops = {
			{name = "default:stick", chance = 1, min = 1, max = 3},
			{name = "ethereal:yellowleaves", chance = 1, min = 1, max = 2},
			{name = "ethereal:yellow_tree_sapling", chance = 2, min = 0, max = 2},
			{name = "ethereal:golden_apple", chance = 3, min = 0, max = 2}
		}, glow = 1
	},

	--[[{	nodes = {"default:acacia_bush_leaves"},
		skins = {"mobs_tree_monster6.png"},
		drops = {
			{name = "tnt:gunpowder", chance = 1, min = 0, max = 2},
			{name = "default:iron_lump", chance = 5, min = 0, max = 2},
			{name = "default:coal_lump", chance = 3, min = 0, max = 3}
		},
		explode = true
	}]]--
}

local function gen_drops(pos)
	local res = {}

	-- YAMS-TODO: change tree and sapling drop depending on biome
	table.insert(res, {name = "default:tree", chance = 1, min = 2, max = 4})
	table.insert(res, {name = "default:sapling", chance = 4, min = 1, max = 1})

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 8, min = 1, max = 1}
		)
	end

	return res
end

-- Tree Monster (or Tree Gollum) by PilzAdam

mobs:register_mob("mobs_monster:tree_monster", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	attack_animals = true,
	pathfinding = true,
	reach = 2,
	damage = 2,
	damage_max = 30,
	hp_min = 20,
	hp_max = 120,
	armor = 100,
	yams_resists = {
		yams_fire = {damage = 200, knockback = 100},
	},
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.8, 0.4},
	visual = "mesh",
	mesh = "mobs_tree_monster.b3d",
	textures = {
		{"mobs_tree_monster.png"},
		{"mobs_tree_monster2.png"}
	},
	blood_texture = "default_wood.png",
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_treemonster",
		war_cry = "mobs_treemonster",
	},
	walk_velocity = 1,
	run_velocity = 3,
	run_velocity_max = 5,
	jump = true,
	view_range = 15,
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 1,
	fall_damage = 0,
	-- YAMS-TODO: reimplement vulnerability to axe later
	animation = {
		speed_normal = 15, speed_run = 15,
		stand_start = 0, stand_end = 24,
		walk_start = 25, walk_end = 47,
		run_start = 48, run_end = 62,
		punch_start = 48, punch_end = 62
	},
	base_exp = 60,
	max_exp = 3000,

	-- check surrounding nodes and spawn a specific tree monster
	on_spawn = function(self)

		local pos = self.object:get_pos() ; pos.y = pos.y - 1
		local tmp

		for n = 1, #tree_types do

			tmp = tree_types[n]

			--if tmp.explode and math.random(2) == 1 then return true end

			if core.find_node_near(pos, 1, tmp.nodes) then

				self.base_texture = tmp.skins
				self.object:set_properties({textures = tmp.skins})

				if tmp.glow then self.object:set_properties({glow = tmp.glow}) end

				--[[if tmp.drops then self.drops = tmp.drops end

				if tmp.explode then

					self.attack_type = "explode"
					self.explosion_radius = 3
					self.explosion_timer = 3
					self.damage = 21
					self.reach = 3
					self.fear_height = 4
					self.water_damage = 2
					self.lava_damage = 15
					self.light_damage = 0
					self.makes_footstep_sound = false
					self.runaway_from = {"mobs_animal:kitten"}
					self.sounds = {
						attack = "tnt_ignite",
						explode = "tnt_explode",
						fuse = "tnt_ignite"
					}
				end]]--

				return true
			end
		end

		return true -- run only once, false/nil runs every activation
	end
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:tree_monster",
		nodes = {"default:dirt_with_grass", "default:dirt_with_rainforest_litter",
		"default:dirt_with_coniferous_litter", "default:dry_dirt_with_dry_grass",
		"default:dirt_with_snow",
		"ebiomes:dirt_with_grass_cold", "ebiomes:dirt_with_grass_med",
		"ebiomes:dirt_with_grass_warm", "ebiomes:dirt_with_grass_swamp",
		"ebiomes:peat_with_swamp_moss_yellow", "ebiomes:dirt_with_japanese_rainforest_litter",
		"ebiomes:dry_dirt_with_humid_savanna_grass", "ebiomes:dirt_with_forest_litter",
		"ebiomes:dirt_with_jungle_savanna_grass"},
		neighbors = {},
		max_light = 4,
		interval = 15,
		chance = 8000,
		min_height = 0,
		max_height = 8190,
		day_toggle = false,
		-- Only spawn in biomes that have trees
		biome_deny = {"grassland", "grassland_coldish", "grassland_warm",
		"grassland_arid", "grassland_arid_cool", "snowy_grassland"}
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:tree_monster", S("Tree Monster"), "default_tree_top.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:tree_monster", "mobs_monster:tree_monster")
