
-- Translation support

local S = core.get_translator("pigiron")

-- Pig Iron Ingot

core.register_craftitem("pigiron:iron_ingot", {
	description = S("Iron Ingot"),
	inventory_image = "pigiron_iron_ingot.png"
})

-- Remove Iron Lump -> Steel Ingot Recipe

core.clear_craft({
	type = "cooking",
	recipe = "default:iron_lump"
})

-- Iron Lump -> Iron Ingot

core.register_craft({
	type = "cooking",
	output = "pigiron:iron_ingot",
	recipe = "default:iron_lump"
})

-- Pig Iron Block

core.register_node("pigiron:iron_block", {
	description = S("Iron Block"),
	tiles = {"pigiron_iron_block.png"},
	is_ground_content = false,
	groups = {cracky = 1},
	sounds = default.node_sound_metal_defaults()
})

core.register_craft({
	output = "pigiron:iron_block",
	recipe = {
		{"pigiron:iron_ingot", "pigiron:iron_ingot", "pigiron:iron_ingot"},
		{"pigiron:iron_ingot", "pigiron:iron_ingot", "pigiron:iron_ingot"},
		{"pigiron:iron_ingot", "pigiron:iron_ingot", "pigiron:iron_ingot"}
	}
})

core.register_craft({
	output = "pigiron:iron_ingot 9",
	recipe = {{"pigiron:iron_block"}}
})

-- Rusted Pig Iron Block

core.register_node("pigiron:rusted_iron_block", {
	description = S("Rusted Iron Block"),
	tiles = {"pigiron_rusted_iron_block.png"},
	is_ground_content = false,
	groups = {cracky = 1},
	sounds = default.node_sound_metal_defaults()
})

core.register_craft({
	output = "pigiron:rusted_iron_block 8",
	recipe = {
		{"pigiron:iron_block", "pigiron:iron_block", "pigiron:iron_block"},
		{"pigiron:iron_block", "bucket:bucket_water", "pigiron:iron_block"},
		{"pigiron:iron_block", "pigiron:iron_block", "pigiron:iron_block"}
	},
	replacements = {
		{"bucket:bucket_water", "bucket:bucket_empty"}
	}
})

-- Cook Rusted Block Into Normal Block

core.register_craft({
	output = "pigiron:iron_block",
	type = "cooking",
	recipe = "pigiron:rusted_iron_block",
	cooktime = 5
})

-- Do not register these items and recipes if Ethereal mod active
if not core.get_modpath("ethereal") then

	-- Charcoal

	core.register_craftitem("pigiron:charcoal_lump", {
		description = S("Lump of Charcoal"),
		inventory_image = "pigiron_charcoal_lump.png"
	})

	-- Tree -> Charcoal Recipe

	core.register_craft({
		output = "pigiron:charcoal_lump",
		type = "cooking",
		recipe = "group:tree",
		cooktime = 3,
	})

	-- Charcoal Fuel

	core.register_craft({
		type = "fuel",
		recipe = "pigiron:charcoal_lump",
		burntime = 40
	})

	-- Charcoal Torch Recipe

	core.register_craft({
		output = "default:torch 4",
		recipe = {
			{"pigiron:charcoal_lump"},
			{"group:stick"}
		}
	})

else

	-- Alias charcoal lump to the one used in Ethereal mod
	core.register_alias("pigiron:charcoal_lump", "ethereal:charcoal_lump")

end -- END If Ethereal

-- Iron/Charcoal/Coal Mix

core.register_craftitem("pigiron:iron_charcoal_mix", {
	description = S("Iron and Charcoal Mix"),
	inventory_image = "pigiron_iron_ingot.png^pigiron_charcoal_lump.png"
})

core.register_craft({
	output = "pigiron:iron_charcoal_mix",
	recipe = {
		{"", "pigiron:charcoal_lump", ""},
		{"pigiron:charcoal_lump", "pigiron:iron_ingot", "pigiron:charcoal_lump"},
		{"", "pigiron:charcoal_lump", ""}
	}
})

core.register_craft({
	output = "pigiron:iron_charcoal_mix",
	recipe = {
		{"", "default:coal_lump", ""},
		{"default:coal_lump", "pigiron:iron_ingot", "default:coal_lump"},
		{"", "default:coal_lump", ""}
	}
})

-- Cook Iron/Charcoal Mix into Steel Ingot

core.register_craft({
	output = "default:steel_ingot",
	type = "cooking",
	recipe = "pigiron:iron_charcoal_mix",
	cooktime = 5
})

-- Abm to turn Iron Block into Rusted Iron Block

core.register_abm({
	label = "Rust Iron Block",
	nodenames = {
		"pigiron:iron_block",
		"stairs:slab_iron_block",
		"stairs:stair_iron_block",
		"stairs:stair_inner_iron_block",
		"stairs:stair_outer_iron_block"
	},
	neighbors = {"group:water"},
	interval = 20,
	chance = 300,
	catch_up = false,

	action = function(pos, node)

		if node.name == "pigiron:iron_block" then

			core.swap_node(pos, {name = "pigiron:rusted_iron_block"})

		elseif node.name == "stairs:slab_iron_block" then

			core.swap_node(pos, {name = "stairs:slab_rusted_iron_block",
					param2 = node.param2})

		elseif node.name == "stairs:stair_iron_block" then

			core.swap_node(pos, {name = "stairs:stair_rusted_iron_block",
					param2 = node.param2})

		elseif node.name == "stairs:stair_inner_iron_block" then

			core.swap_node(pos, {name = "stairs:stair_inner_rusted_iron_block",
					param2 = node.param2})

		elseif node.name == "stairs:stair_outer_iron_block" then

			core.swap_node(pos, {name = "stairs:stair_outer_rusted_iron_block",
					param2 = node.param2})
		end
	end
})

-- Add Tools and Lucky Blocks

local path = core.get_modpath("pigiron")

--dofile(path .. "/tools.lua")

if core.get_modpath("lucky_block") then
	dofile(path .. "/lucky_block.lua")
end

-- Change Xpanes Iron Bar Recipe to use Iron Ingots

if core.get_modpath("xpanes")
and core.registered_nodes["xpanes:bar_flat"]
and not core.registered_nodes["default:permafrost"] then

	core.clear_craft({output = "xpanes:bar_flat"})

	core.register_craft({
		output = "xpanes:bar_flat",
		recipe = {
			{"pigiron:iron_ingot", "pigiron:iron_ingot", "pigiron:iron_ingot"},
			{"pigiron:iron_ingot", "pigiron:iron_ingot", "pigiron:iron_ingot"}
		}
	})
end

-- Register Stairs

if core.get_modpath("stairs") then

	stairs.register_stair_and_slab("iron_block", "pigiron:iron_block",
		{cracky = 1},
		{"pigiron_iron_block.png"},
		S("Iron Block Stair"),
		S("Iron Block Slab"),
		default.node_sound_metal_defaults())

	stairs.register_stair_and_slab("rusted_iron_block", "pigiron:rusted_iron_block",
		{cracky = 1},
		{"pigiron_rusted_iron_block.png"},
		S("Rusted Iron Block Stair"),
		S("Rusted Iron Block Slab"),
		default.node_sound_metal_defaults())

	-- Cook Rusted Iron Stairs and Slabs Back Into Normal Iron Stairs
	core.register_craft({
		output = "stairs:stair_iron_block",
		type = "cooking",
		recipe = "stairs:stair_rusted_iron_block",
		cooktime = 5
	})

	core.register_craft({
		output = "stairs:slab_iron_block",
		type = "cooking",
		recipe = "stairs:slab_rusted_iron_block",
		cooktime = 5
	})

	core.register_craft({
		output = "stairs:stair_outer_iron_block",
		type = "cooking",
		recipe = "stairs:stair_outer_rusted_iron_block",
		cooktime = 5
	})

	core.register_craft({
		output = "stairs:stair_inner_iron_block",
		type = "cooking",
		recipe = "stairs:stair_inner_rusted_iron_block",
		cooktime = 5
	})
end

print("[MOD] Pig Iron loaded")
