-- Overrides for the pumpkin

-- Add seed items for the pumpkin, replace all the graphics associated with
-- it and related nodes, prevent the pumpkin slice from being used as a seed,
-- and add the pumpkin pie item

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_pumpkin", {
    description = S("Pumpkin Seeds"),
    tiles = {"x_farming_pumpkin_seed.png"},
    inventory_image = "x_farming_pumpkin_seed.png",
    wield_image = "x_farming_pumpkin_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_pumpkin")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:pumpkin_1", param2 = 3})
    end
})

-- Override parts of the pumpkin slice so that it cannot be used as a seed
core.override_item("farming:pumpkin_slice", {
    groups = {compostability = 50, food_melon_slice = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- We do not go to 8 because that is the pumpkin block itself and it will be
-- handled separately
for i = 1, 7 do
    local x = tostring(i)
    core.override_item("farming:pumpkin_" .. x, {
        tiles = {"x_farming_pumpkin_" .. x .. ".png"},
    })
end

-- Unlike the block in X Farming, do not use the side with the carved face
core.override_item("farming:pumpkin_8", {
    tiles = {
        "x_farming_pumpkin_fruit_top.png",
        "x_farming_pumpkin_fruit_bottom.png",
        "x_farming_pumpkin_fruit_side.png",
    },
    on_dig = function(pos, node, digger)
        -- Prevent an infinite seed exploit by only dropping seeds if this
        -- pumpkin block had just grown
        if core.node_dig(pos, node, digger) and node.param1 == 0 then
            local num = tostring(math.random(1, 2))
            local seeds = ItemStack("farming:seed_pumpkin " .. num)
            local inv = digger:get_inventory()
            local leftover = inv:add_item("main", seeds)
            if not leftover:is_empty() then
                core.item_drop(seeds, digger, pos)
            end
        end
    end,
    on_place = function(itemstack, placer, pointed_thing)
        local res = core.rotate_node(itemstack, placer, pointed_thing)
        local pos = pointed_thing.above
        local n = core.get_node(pos)
        -- Nodes placed by the player will not give seeds when broken
        core.set_node(pos, {name=n.name, param1=1, param2=n.param2})

        return res
    end,
})

-- Override the jack-o-lantern items as well
core.override_item("farming:jackolantern", {  -- off state
    -- Take advantage of the 'tt' mod while we're at it
    description = S("Jack-o'-lantern"),
    _tt_help = "Punch to turn on or off",
    tiles = {
        "x_farming_pumpkin_fruit_top.png",
        "x_farming_pumpkin_fruit_bottom.png",
        "x_farming_pumpkin_fruit_side.png",
        "x_farming_pumpkin_fruit_side.png",
        "x_farming_pumpkin_fruit_side.png",
        "x_farming_pumpkin_fruit_side_off.png",
    },
})

core.override_item("farming:jackolantern_on", {  -- on state
    tiles = {
        "x_farming_pumpkin_fruit_top.png",
        "x_farming_pumpkin_fruit_bottom.png",
        "x_farming_pumpkin_fruit_side.png",
        "x_farming_pumpkin_fruit_side.png",
        "x_farming_pumpkin_fruit_side.png",
        "x_farming_pumpkin_fruit_side_on.png",
    },
})

-- Do not make scythes affect this crop
farming.registered_plants["farming:pumpkin"].seed = "farming:seed_pumpkin"
farming.registered_plants["farming:pumpkin"].disable_scythe = true

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:pumpkin_", 8, "farming:seed_pumpkin"},
    })
end

-- Add the pumpkin pie item and recipe
core.register_craftitem(":farming:pumpkin_pie", {
    description = S("Pumpkin Pie"),
    inventory_image = "x_farming_pumpkin_pie.png",
    on_use = core.item_eat(6),
    _yams_food_effects = {
        {name = "yams_effects:well_fed_medium", duration = 180},
        {name = "yams_effects:defense_up_medium", duration = 60},
        {name = "yams_effects:tough_skin", duration = 60},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Well Fed M"),
            desc = S("Gain +25% EXP from most sources for three minutes.")
        },
        {
            name = S("Defense Up M"),
            desc = S("Reduce combat damage taken by 25% for 60 seconds.")
        },
        {
            name = S("Tough Skin"),
            -- YAMS-TODO: this is not ideal for translators at all
            desc = S("Reduce combat damage taken by 1 for 60") .. "\n" ..
                   S("seconds. This effect is applied after any") .. "\n" ..
                   S("effects that reduce damage taken by a") .. "\n" ..
                   S("percentage. Cannot reduce damage below 1.")
        },
    }
})

core.register_craft({
    type = "shapeless",
    output = "farming:pumpkin_pie 2",
    recipe = {"group:food_flour", "group:food_pumpkin", "group:food_sugar",
              "group:food_milk"},
    replacements = {
        {"mobs:bucket_milk", "bucket:bucket_empty"},
        {"mobs:wooden_bucket_milk", "wooden_bucket:bucket_wood_empty"},
    }
})
