
-- translation and custom mese monster types

local S = core.get_translator("mobs_monster")

local function gen_drops(pos)
	local res = {}

	if pos.y <= -4096 then
		table.insert(res, {name = "default:mese_crystal", chance = 1, min = 2, max = 4})
		table.insert(res, {name = "default:mese", chance = 8, min = 1, max = 1})
	elseif pos.y <= -1024 then
		table.insert(res,
			{name = "default:mese_crystal_fragment", chance = 1, min = 2, max = 4}
		)
		table.insert(res, {name = "default:mese_crystal", chance = 4, min = 1, max = 1})
	else
		table.insert(res,
			{name = "default:mese_crystal_fragment", chance = 1, min = 1, max = 1}
		)
	end

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 4, min = 1, max = 1}
		)
		table.insert(res,
			{name = "magic_materials:februm_crystal", chance = 16, min = 1, max = 1}
		)
	end

	if minetest.get_modpath("yams_materials") then
		table.insert(res,
			{name = "yams_materials:wind_essence", chance = 4, min = 1, max = 1}
		)
	end

	return res
end

-- Mese Monster by SirrobZeroone

mobs:register_mob("mobs_monster:mese_monster", {
	type = "monster",
	visual_size = {x = 10, y = 10},  -- Got scale wrong in blender by factor of 10 - S01
	passive = false,
	attack_type = "dogshoot",
	attack_animals = true,
	damage = 5,
	damage_max = 60,
	arrow_damage = 2,
	arrow_damage_max = 30,
	arrow_knockback = 4.0,
	reach = 2,
	shoot_interval = 0.25,
	arrow = "mobs_monster:mese_arrow",
	shoot_offset = 0.75,
	attack_patience = 3,
	hp_min = 24,
	hp_max = 120,
	armor = 100,
	yams_resists = {
		yams_mese = {damage = 50, knockback = 50},
		yams_electric = {damage = 150, knockback = 100},
	},
	collisionbox = {-0.75, -0.5, -0.75, 0.75, 2.5, 0.75},
	visual = "mesh",
	mesh = "mobs_mese_monster.b3d",
	textures = {
		{"mobs_mese_monster_red.png"},
		{"mobs_mese_monster_green.png"},
		{"mobs_mese_monster_blue.png"},
		{"mobs_mese_monster_purple.png"}
	},
	blood_texture = "default_mese_crystal_fragment.png",
	makes_footstep_sound = false,
	sounds = {
		-- yams uses a different sound for the mese monster
		-- Source: https://opengameart.org/content/monster-sound-pack-volume-1
		-- Licensed under CC0
		random = "mobs_mesemonster",
		war_cry = "mobs_mesemonster",
		-- YAMS-TODO: temporary shoot sound
		shoot_attack = "bweapons_bows_pack_longbow_fire",
	},
	view_range = 15,
	walk_velocity = 2,
	run_velocity = 4,
	run_velocity_max = 6,
	fly = true,
	fly_in = "air",
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 1,
	animation = {
		speed_normal = 18, speed_run = 18,
		walk_start = 10, walk_end = 41, walk_speed = 20,
		run_start = 10, run_end = 41, run_speed = 30,
		stand_start = 60, stand_end = 83,
		shoot_start = 100, shoot_end = 113,
		die_start = 125, die_end = 141, death_speed = 25, die_loop = false,
		jump_start = 150 , jump_end = 168, jump_loop = false,
		punch_start = 175, punch_end = 189
	},
	base_exp = 1000,
	max_exp = 8000,
	yams_scaling_opts = {
		cavern_start = -512,
		cavern_fast_until = -2496,
	},
	do_custom = function(self, dtime, moveresult)
		if self.attack and self.attack:get_pos() then
			local pos = self.object:get_pos()
			local target_pos = self.attack:get_pos()

			-- Move mese monsters that are out of reach closer to the player
			-- to make fighting them less frustrating
			if pos.y - target_pos.y > 5 then
				self.object:set_velocity({x = 0, y = -1, z = 0})
			elseif target_pos.y - pos.y > 5 then
				self.object:set_velocity({x = 0, y = 1, z = 0})
			else
				self.object:set_velocity({x = 0, y = 0, z = 0})
			end
		else
			-- Delay the first attack to give players time to react 
			self.timer = -0.5
		end
	end,
	on_knockback = function(self, kb)
		-- Give a very short breather to allow players that are dodging
		-- projectiles to switch the direction they are strafing if needed
		self.timer = 0.0
	end,
})

-- mese arrow item

core.register_craftitem("mobs_monster:mese_crystal_fragment_arrow", {
	description = S("Mese Monster Arrow"),
	inventory_image = "mobs_mese_arrow.png",
	groups = {not_in_creative_inventory = 1}
})

-- mese arrow

mobs:register_arrow("mobs_monster:mese_arrow", {
	visual = "wielditem",
	visual_size = {x = 0.25, y = 0.25},
	textures = {"mobs_monster:mese_crystal_fragment_arrow"},
	velocity = 16,
	rotate = 180,
	damage = 2,

	on_activate = function(self, staticdata, dtime_s)
		-- make mese arrows indestructable
		self.object:set_armor_groups({immortal = 1, fleshy = 100})
	end,
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:mese_monster",
		nodes = {"default:stone", "default:desert_stone", "default:sandstone",
		"default:sand", "default:desert_sand", "default:silver_sand",
		"default:ice", "caverealms:stone_with_moss",
		"caverealms:stone_with_lichen", "caverealms:stone_with_algae",
		"caverealms:stone_with_salt", "caverealms:hot_cobble",
		"caverealms:thin_ice", "caverealms:glow_obsidian",
		"caverealms:glow_obsidian_2", "caverealms:coal_dust"},
		max_light = 4,
		interval = 15,
		chance = 16000,
		min_height = -19990,
		max_height = -512
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:mese_monster", S("Mese Monster"), "default_mese_block.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:mese_monster", "mobs_monster:mese_monster")

--[[
-- 9x mese crystal fragments = 1x mese crystal recipe

local f = "default:mese_crystal_fragment"

core.register_craft({
	output = "default:mese_crystal",
	recipe = {{f, f, f}, {f, f, f}, {f, f, f}}
})
]]--
