
-- load settings

local croc_walkers = core.settings:get_bool("mobs_crocs.enable_walkers", true)
local croc_floaters = core.settings:get_bool("mobs_crocs.enable_floaters", true)
local croc_swimmers = core.settings:get_bool("mobs_crocs.enable_swimmers", true)
local croc_spawn_chance = 144000

-- tweak croc spawn chance depending on which one's are enabled

croc_spawn_chance = croc_spawn_chance - (croc_walkers and 0 or 48000)
croc_spawn_chance = croc_spawn_chance - (croc_floaters and 0 or 48000)
croc_spawn_chance = croc_spawn_chance - (croc_swimmers and 0 or 48000)

-- Mineclone check

local mod_mcl = core.get_modpath("mcl_core")

-- crocodile definition

local croc_def = {
	type = "monster",
	attack_type = "dogfight",
	damage = 6,
	reach = 2,
	hp_min = 18,
	hp_max = 22,
	armor = 100,
	collisionbox = {-0.85, -0.30, -0.85, 0.85, 1.5, 0.85},
	drawtype = "front",
	visual = "mesh",
	mesh = "crocodile.x",
	textures = {
		{"croco.png"},
		{"croco2.png"}
	},
	visual_size = {x = 4, y = 4},
	sounds = {
		random = "croco",
		war_cry = "croco",
	},
	fly = false,
	floats = 0,
	stepheight = 1,
	view_range = 10,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 0,
	animation = {
		speed_normal = 24, speed_run = 24,
		stand_start = 0, stand_end = 80,
		walk_start = 81, walk_end = 170,
		fly_start = 81, fly_end = 170,
		run_start = 81, run_end = 170,
		punch_start = 205, punch_end = 220
	},
	drops = {
		{name = "mobs:meat_raw", chance = 1, min = 1, max = 1},
		{name = "mobs:leather", chance = 4, min = 1, max = 1}
	},
	base_exp = 30,
	yams_scaling_opts = {enable_scaling = false},
}


if croc_walkers then

	mobs:register_mob("mobs_crocs:crocodile", table.copy(croc_def))

	mobs:register_egg("mobs_crocs:crocodile", "Crocodile (walk)", "default_grass.png", 1)

	mobs:spawn({
		name = "mobs_crocs:crocodile",
		nodes = {
			"default:dirt", "default:sand",
		},
		neighbors = {
			"default:water_flowing", "default:water_source",
		},
		interval = 15,
		chance = croc_spawn_chance,
		min_height = 0,
		max_height = 8
	})
end


if croc_floaters then
	croc_def.hp_min = 14
	croc_def.hp_max = 18
	croc_def.reach = 2
	croc_def.collisionbox = {-0.638, -0.23, -0.638, 0.638, 1.13, 0.638}
	croc_def.visual_size = {x = 3, y = 3}
	croc_def.floats = 1
	croc_def.base_exp = 25,

	mobs:register_mob("mobs_crocs:crocodile_float", table.copy(croc_def))

	mobs:register_egg("mobs_crocs:crocodile_float", "Crocodile (float)", "default_grass.png", 1)

	mobs:spawn({
		name = "mobs_crocs:crocodile_float",
		nodes = {"default:water_source"},
		neighbors = {"default:sand", "default:dirt"},
		interval = 15,
		chance = croc_spawn_chance,
		min_height = -3,
		max_height = 8
	})
end


if croc_swimmers then
	croc_def.hp_min = 10
	croc_def.hp_max = 14
	croc_def.reach = 2
	croc_def.collisionbox = {-0.425, -0.15, -0.425, 0.425, 0.75, 0.425}
	croc_def.visual_size = {x = 2, y = 2}
	croc_def.fly = true
	croc_def.fly_in = "default:water_source"
	croc_def.floats = 0
	croc_def.base_exp = 20,

	mobs:register_mob("mobs_crocs:crocodile_swim", table.copy(croc_def))

	mobs:register_egg("mobs_crocs:crocodile_swim", "Crocodile (swim)", "default_grass.png", 1)

	mobs:spawn({
		name = "mobs_crocs:crocodile_swim",
		nodes = {"default:water_source"},
		neighbors = {"default:sand", "default:dirt"},
		interval = 15,
		chance = croc_spawn_chance,
		min_height = -8,
		max_height = 8
	})
end

-- Check for custom spawn.lua

local MP = core.get_modpath(core.get_current_modname()) .. "/"
local input = io.open(MP .. "spawn.lua", "r")

if input then
	input:close() ; input = nil ; dofile(MP .. "spawn.lua")
elseif false then
	if croc_walkers then

		mobs:spawn({
			name = "mobs_crocs:crocodile",
			nodes = {
				(mod_mcl and "group:shovely" or "group:crumbly")
			},
			neighbors = {
				"group:water", "dryplants:juncus", "dryplants:reedmace",
				(mod_mcl and "mcl_core:reeds" or "default:papyrus")
			},
			interval = 30,
			chance = croc_spawn_chance,
			min_height = 0,
			max_height = 10
		})
	end

	if croc_floaters then

		mobs:spawn({
			name = "mobs_crocs:crocodile_float",
			nodes = {"group:water"},
			neighbors = {
				(mod_mcl and "group:shovely" or "group:crumbly"),
				"group:seaplants", "dryplants:juncus", "dryplants:reedmace",
				(mod_mcl and "mcl_core:reeds" or "default:papyrus")
			},
			interval = 30,
			chance = croc_spawn_chance,
			min_height = -3,
			max_height = 10
		})
	end

	if croc_swimmers then

		mobs:spawn({
			name = "mobs_crocs:crocodile_swim",
			nodes = {"group:water"},
			neighbors = {(mod_mcl and "group:shovely" or "group:crumbly")},
			interval = 30,
			chance = croc_spawn_chance,
			min_height = -8,
			max_height = 10
		})
	end
end

print("[MOD] Mobs Redo Crocs loaded")
