-- Translation support
local S = core.get_translator("yams_mobs")

local function gen_drops(pos)
    local res = {}

    if pos.y > 1000 then
        table.insert(res, {name = "default:diamond", chance = 50, min = 1, max = 1})
        table.insert(res, {name = "default:gold_lump", chance = 10, min = 1, max = 1})
    else
        table.insert(res, {name = "default:gold_lump", chance = 50, min = 1, max = 1})
    end

    if core.get_modpath("bonemeal") then
        table.insert(res, {name = "bonemeal:bone", chance = 4, min = 1, max = 1})
    end

    if core.registered_items["farming:string"] then
        table.insert(res,
            {name = "farming:string", chance = 2, min = 1, max = 1}
        )
    end

    if core.get_modpath("magic_materials") then
        table.insert(res,
            {name = "magic_materials:egerum_crystal", chance = 1, min = 1, max = 1}
        )
        table.insert(res,
            {name = "magic_materials:februm_crystal", chance = 10, min = 1, max = 1}
        )
    end

    return res
end

-- YAMS-TODO: indicate that the mummy is poisonous with particles
mobs:register_mob("yams_mobs:mummy", {
    type = "monster",
    passive = false,
    attack_type = "dogfight",
    attack_animals = false,
    pathfinding = true,
    reach = 2,
    damage = 3,
    damage_max = 45,
    yams_melee_effects = {
        {name = "yams_effects:poison", duration = 16, chance = 50},
    },
    hp_min = 30,
    hp_max = 150,
    armor = 100,
    yams_resists = {
        yams_fire = {damage = 200, knockback = 100},
    },
    collisionbox = {-0.4, -0.01, -0.4, 0.4, 1.9, 0.4},
    visual = "mesh",
    mesh = "tsm_pyramids_mummy.x",
    textures = {"tsm_pyramids_mummy.png"},
    visual_size = {x = 8, y = 8},
    makes_footstep_sound = true,
    sounds = {
        random = "mummy",
        war_cry = "mummy",
        damage = "mummy_hurt",
        death = "mummy_death",
    },
    view_range = 15,
    walk_velocity = 0.5,
    run_velocity = 2,
    run_velocity_max = 3,  -- Pyramids are cramped so don't set this too high
    jump = true,
    drops = gen_drops,
    water_damage = 0,
    lava_damage = 8,
    light_damage = 0,  -- On purpose to prevent luring them out to their death
    fear_height = 4,
    animation = {
        stand_start = 74,
        stand_end = 74,
        walk_start = 74,
        walk_end = 105,
    },
    base_exp = 100,
    max_exp = 3000,

    do_custom = function(self, dtime)
        -- YAMS-TODO: see spider.lua for why we do it this way, although there
        -- is probably a better way
        if not self._particle_timer then
            self._particle_timer = 10.0
        end

        self._particle_timer = self._particle_timer + dtime
        if self._particle_timer >= 10.0 then
            core.add_particlespawner({
                amount = 100,
                time = 10,
                attached = self.object,
                texture = {
                    name = "[fill:1x1:#00ff00cc",
                    scale = 0.5,
                },
                pos = {
                    min = vector.new(-0.5, 0, -0.5),
                    max = vector.new(0.5, 0, 0.5)
                },
                vel = vector.new(0, 2, 0)
            })
            self._particle_timer = self._particle_timer - 10.0
        end
    end,
})

mobs:register_egg("yams_mobs:mummy", S("Mummy"), "tsm_pyramids_mummy_egg.png", 0)
