-- mods/default/tools.lua

-- support for MT game translation.
local S = default.get_translator

-- The hand
-- Override the hand item registered in the engine in builtin/game/register.lua
minetest.override_item("", {
	wield_scale = {x=1,y=1,z=2.5},
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level = 0,
		groupcaps = {
			crumbly = {times={[2]=3.00, [3]=0.70}, uses=0, maxlevel=1},
			snappy = {times={[3]=0.40}, uses=0, maxlevel=1},
			oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
		},
		damage_groups = {fleshy=1},
	}
})

-- Default stat factors for all melee weapons
local melee_sf = {
	primary = "str",
	secondary = nil,
	str = 1.0,
	dex = 0.0,
	int = 0.0
}

-- Element properties for melee weapons
local default_melee_elements = {yams_physical = 100, yams_neutral = 100}
local mese_melee_elements = {yams_physical = 100, yams_mese = 100}

--
-- Picks
--

minetest.register_tool("default:pick_wood", {
	description = S("Wooden Pickaxe"),
	inventory_image = "default_tool_woodpick.png",
	tool_capabilities = {
		full_punch_interval = 1.4,
		max_drop_level=0,
		groupcaps={
			cracky = {times={[3]=1.60}, uses=10, maxlevel=1},
		},
		damage_groups = {fleshy=2},
		punch_attack_uses = 10,  -- formula is same as the default
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1, flammable = 2},
	_yams_knockback = 1,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:pick_stone", {
	description = S("Stone Pickaxe"),
	inventory_image = "default_tool_stonepick.png",
	tool_capabilities = {
		full_punch_interval = 1.6,
		max_drop_level=0,
		groupcaps={
			cracky = {times={[2]=2.0, [3]=1.00}, uses=20, maxlevel=1},
		},
		damage_groups = {fleshy=3},
		punch_attack_uses = 20,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1},
	_yams_knockback = 1.5,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:pick_bronze", {
	description = S("Bronze Pickaxe"),
	inventory_image = "default_tool_bronzepick.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=1,
		groupcaps={
			cracky = {times={[1]=4.50, [2]=1.80, [3]=0.90}, uses=25, maxlevel=2},
		},
		damage_groups = {fleshy=4},
		punch_attack_uses = 75,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1},
	_yams_knockback = 2,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:pick_steel", {
	description = S("Steel Pickaxe"),
	inventory_image = "default_tool_steelpick.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=1,
		groupcaps={
			cracky = {times={[1]=4.00, [2]=1.60, [3]=0.80}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=4},
		punch_attack_uses = 90,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1},
	_yams_knockback = 2,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:pick_mese", {
	description = S("Mese Pickaxe"),
	inventory_image = "default_tool_mesepick.png",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=3,
		groupcaps={
			cracky = {times={[1]=2.4, [2]=1.2, [3]=0.60}, uses=20, maxlevel=3},
		},
		damage_groups = {fleshy=5},
		punch_attack_uses = 180,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1},
	_yams_knockback = 2.5,
	_yams_anvil_difficulty = 1.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = mese_melee_elements
})

minetest.register_tool("default:pick_diamond", {
	description = S("Diamond Pickaxe"),
	inventory_image = "default_tool_diamondpick.png",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=3,
		groupcaps={
			cracky = {times={[1]=2.0, [2]=1.0, [3]=0.50}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=5},
		punch_attack_uses = 270,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1},
	_yams_knockback = 3,
	_yams_anvil_difficulty = 2.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

--
-- Shovels
--

minetest.register_tool("default:shovel_wood", {
	description = S("Wooden Shovel"),
	inventory_image = "default_tool_woodshovel.png",
	wield_image = "default_tool_woodshovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.4,
		max_drop_level=0,
		groupcaps={
			crumbly = {times={[1]=3.00, [2]=1.60, [3]=0.60}, uses=10, maxlevel=1},
		},
		damage_groups = {fleshy=2},
		punch_attack_uses = 10,  -- formula is same as the default
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1, flammable = 2},
	_yams_knockback = 2,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:shovel_stone", {
	description = S("Stone Shovel"),
	inventory_image = "default_tool_stoneshovel.png",
	wield_image = "default_tool_stoneshovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.6,
		max_drop_level=0,
		groupcaps={
			crumbly = {times={[1]=1.80, [2]=1.20, [3]=0.50}, uses=20, maxlevel=1},
		},
		damage_groups = {fleshy=2},
		punch_attack_uses = 20,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1},
	_yams_knockback = 2.5,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:shovel_bronze", {
	description = S("Bronze Shovel"),
	inventory_image = "default_tool_bronzeshovel.png",
	wield_image = "default_tool_bronzeshovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=1.65, [2]=1.05, [3]=0.45}, uses=25, maxlevel=2},
		},
		damage_groups = {fleshy=3},
		punch_attack_uses = 75,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1},
	_yams_knockback = 3,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:shovel_steel", {
	description = S("Steel Shovel"),
	inventory_image = "default_tool_steelshovel.png",
	wield_image = "default_tool_steelshovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=1.50, [2]=0.90, [3]=0.40}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=3},
		punch_attack_uses = 90,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1},
	_yams_knockback = 3,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:shovel_mese", {
	description = S("Mese Shovel"),
	inventory_image = "default_tool_meseshovel.png",
	wield_image = "default_tool_meseshovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=3,
		groupcaps={
			crumbly = {times={[1]=1.20, [2]=0.60, [3]=0.30}, uses=20, maxlevel=3},
		},
		damage_groups = {fleshy=4},
		punch_attack_uses = 180,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1},
	_yams_knockback = 3.5,
	_yams_anvil_difficulty = 1.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = mese_melee_elements
})

minetest.register_tool("default:shovel_diamond", {
	description = S("Diamond Shovel"),
	inventory_image = "default_tool_diamondshovel.png",
	wield_image = "default_tool_diamondshovel.png^[transformR90",
	tool_capabilities = {
		full_punch_interval = 1.1,
		max_drop_level=1,
		groupcaps={
			crumbly = {times={[1]=1.10, [2]=0.50, [3]=0.30}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=4},
		punch_attack_uses = 270,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1},
	_yams_knockback = 4,
	_yams_anvil_difficulty = 2.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

--
-- Axes
--

minetest.register_tool("default:axe_wood", {
	description = S("Wooden Axe"),
	inventory_image = "default_tool_woodaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			choppy = {times={[2]=3.00, [3]=1.60}, uses=10, maxlevel=1},
		},
		damage_groups = {fleshy=2},
		punch_attack_uses = 30,  -- formula: uses * 3^maxlevel
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1, flammable = 2},
	_yams_knockback = 5.5,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:axe_stone", {
	description = S("Stone Axe"),
	inventory_image = "default_tool_stoneaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.4,
		max_drop_level=0,
		groupcaps={
			choppy={times={[1]=3.00, [2]=2.00, [3]=1.30}, uses=20, maxlevel=1},
		},
		damage_groups = {fleshy=3},
		punch_attack_uses = 60,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1},
	_yams_knockback = 6.5,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:axe_bronze", {
	description = S("Bronze Axe"),
	inventory_image = "default_tool_bronzeaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.75, [2]=1.70, [3]=1.15}, uses=25, maxlevel=2},
		},
		damage_groups = {fleshy=5},
		punch_attack_uses = 225,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1},
	_yams_knockback = 7.5,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:axe_steel", {
	description = S("Steel Axe"),
	inventory_image = "default_tool_steelaxe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.50, [2]=1.40, [3]=1.00}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=5},
		punch_attack_uses = 270,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1},
	_yams_knockback = 7.5,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:axe_mese", {
	description = S("Mese Axe"),
	inventory_image = "default_tool_meseaxe.png",
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.20, [2]=1.00, [3]=0.60}, uses=20, maxlevel=3},
		},
		damage_groups = {fleshy=6},
		punch_attack_uses = 540,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1},
	_yams_knockback = 8,
	_yams_anvil_difficulty = 1.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = mese_melee_elements
})

minetest.register_tool("default:axe_diamond", {
	description = S("Diamond Axe"),
	inventory_image = "default_tool_diamondaxe.png",
	tool_capabilities = {
		full_punch_interval = 0.9,
		max_drop_level=1,
		groupcaps={
			choppy={times={[1]=2.10, [2]=0.90, [3]=0.50}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=7},
		punch_attack_uses = 810,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1},
	_yams_knockback = 8.5,
	_yams_anvil_difficulty = 2.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

--
-- Swords
--

minetest.register_tool("default:sword_wood", {
	description = S("Wooden Sword"),
	inventory_image = "default_tool_woodsword.png",
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=0,
		groupcaps={
			snappy={times={[2]=1.6, [3]=0.40}, uses=10, maxlevel=1},
		},
		damage_groups = {fleshy=2},
		punch_attack_uses = 30,  -- formula: uses * 3^maxlevel
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1, flammable = 2},
	_yams_knockback = 4,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:sword_stone", {
	description = S("Stone Sword"),
	inventory_image = "default_tool_stonesword.png",
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			snappy={times={[2]=1.4, [3]=0.40}, uses=20, maxlevel=1},
		},
		damage_groups = {fleshy=4},
		punch_attack_uses = 60,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},
	_yams_knockback = 5,
	_yams_anvil_difficulty = 0.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:sword_bronze", {
	description = S("Bronze Sword"),
	inventory_image = "default_tool_bronzesword.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.75, [2]=1.30, [3]=0.375}, uses=25, maxlevel=2},
		},
		damage_groups = {fleshy=6},
		punch_attack_uses = 225,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},
	_yams_knockback = 6,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:sword_steel", {
	description = S("Steel Sword"),
	inventory_image = "default_tool_steelsword.png",
	tool_capabilities = {
		full_punch_interval = 0.8,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.5, [2]=1.20, [3]=0.35}, uses=30, maxlevel=2},
		},
		damage_groups = {fleshy=6},
		punch_attack_uses = 270,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},
	_yams_knockback = 6,
	_yams_anvil_difficulty = 1.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

minetest.register_tool("default:sword_mese", {
	description = S("Mese Sword"),
	inventory_image = "default_tool_mesesword.png",
	tool_capabilities = {
		full_punch_interval = 0.7,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=2.0, [2]=1.00, [3]=0.35}, uses=30, maxlevel=3},
		},
		damage_groups = {fleshy=7},
		punch_attack_uses = 810,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},
	_yams_knockback = 6.5,
	_yams_anvil_difficulty = 1.5,
	_yams_stat_factors = melee_sf,
	_yams_elements = mese_melee_elements
})

minetest.register_tool("default:sword_diamond", {
	description = S("Diamond Sword"),
	inventory_image = "default_tool_diamondsword.png",
	tool_capabilities = {
		full_punch_interval = 0.7,
		max_drop_level=1,
		groupcaps={
			snappy={times={[1]=1.90, [2]=0.90, [3]=0.30}, uses=40, maxlevel=3},
		},
		damage_groups = {fleshy=8},
		punch_attack_uses = 1080,
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},
	_yams_knockback = 7,
	_yams_anvil_difficulty = 2.0,
	_yams_stat_factors = melee_sf,
	_yams_elements = default_melee_elements
})

--
-- Register Craft Recipies
--

local craft_ingreds = {
	wood = "group:wood",
	stone = "group:stone",
	steel = "default:steel_ingot",
	bronze = "default:bronze_ingot",
	mese = "default:mese_crystal",
	diamond = "default:diamond"
}

for name, mat in pairs(craft_ingreds) do
	minetest.register_craft({
		output = "default:pick_".. name,
		recipe = {
			{mat, mat, mat},
			{"", "group:stick", ""},
			{"", "group:stick", ""}
		}
	})

	minetest.register_craft({
		output = "default:shovel_".. name,
		recipe = {
			{mat},
			{"group:stick"},
			{"group:stick"}
		}
	})

	minetest.register_craft({
		output = "default:axe_".. name,
		recipe = {
			{mat, mat},
			{mat, "group:stick"},
			{"", "group:stick"}
		}
	})

	minetest.register_craft({
		output = "default:sword_".. name,
		recipe = {
			{mat},
			{mat},
			{"group:stick"}
		}
	})
end

minetest.register_craft({
	type = "fuel",
	recipe = "default:pick_wood",
	burntime = 6,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:shovel_wood",
	burntime = 4,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:axe_wood",
	burntime = 6,
})

minetest.register_craft({
	type = "fuel",
	recipe = "default:sword_wood",
	burntime = 5,
})
