-- Default stat factors for arcanite tools
-- Intelligence is a secondary stat because of these tools' magical nature
local arcanite_sf = {
    primary = "str",
    secondary = "int",
    str = 0.7,
    dex = 0.0,
    int = 0.3
}
-- Elemental damage definition for all melee weapons
local arcanite_elements = {yams_physical = 100, yams_neutral = 100}

local S = magic_materials.S

minetest.register_tool("magic_materials:pick_arcanite", {
    description = S("Arcanite Pickaxe"),
    inventory_image = "magic_materials_tool_pick_arcanite.png",
    tool_capabilities = {
    full_punch_interval = 1.2,
        max_drop_level=3,
        groupcaps={
            cracky = {times={[1]=3.20, [2]=1.40, [3]=0.70}, uses=15, maxlevel=3},
        },
        damage_groups = {fleshy=4},
        punch_attack_uses = 135,
    },
    sound = {breaks = "default_tool_breaks"},
    groups = {pickaxe = 1},
    _yams_knockback = 2,
    _yams_anvil_difficulty = 1.5,
    _yams_stat_factors = arcanite_sf,
    _yams_elements = arcanite_elements
})
minetest.register_alias("magic_materials:pickaxe_arcanite", "magic_materials:pick_arcanite")

minetest.register_tool("magic_materials:shovel_arcanite", {
    description = S("Arcanite Shovel"),
    inventory_image = "magic_materials_tool_shovel_arcanite.png",
    wield_image = "magic_materials_tool_shovel_arcanite.png^[transformR90",
    tool_capabilities = {
        full_punch_interval = 1.2,
        max_drop_level=1,
        groupcaps={
            crumbly = {times={[1]=1.35, [2]=0.75, [3]=0.35}, uses=15, maxlevel=3},
        },
        damage_groups = {fleshy=3},
        punch_attack_uses = 135,
    },
    sound = {breaks = "default_tool_breaks"},
    groups = {shovel = 1},
    _yams_knockback = 3,
    _yams_anvil_difficulty = 1.5,
    _yams_stat_factors = arcanite_sf,
    _yams_elements = arcanite_elements
})

minetest.register_tool("magic_materials:axe_arcanite", {
    description = S("Arcanite Axe"),
    inventory_image = "magic_materials_tool_axe_arcanite.png",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level=1,
        groupcaps={
            choppy={times={[1]=2.35, [2]=1.20, [3]=0.80}, uses=15, maxlevel=3},
        },
        damage_groups = {fleshy=5},
        punch_attack_uses = 405,
    },
    sound = {breaks = "default_tool_breaks"},
    groups = {axe = 1},
    _yams_knockback = 7.5,
    _yams_anvil_difficulty = 1.5,
    _yams_stat_factors = arcanite_sf,
    _yams_elements = arcanite_elements
})

minetest.register_tool("magic_materials:sword_arcanite", {
    description = S("Arcanite Sword"),
    inventory_image = "magic_materials_tool_sword_arcanite.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level=1,
        groupcaps={
            snappy={times={[1]=2.25, [2]=1.10, [3]=0.35}, uses=20, maxlevel=3},
        },
        damage_groups = {fleshy=6},
        punch_attack_uses = 540,
    },
    sound = {breaks = "default_tool_breaks"},
    groups = {sword = 1},
    _yams_knockback = 6,
    _yams_anvil_difficulty = 1.5,
    _yams_stat_factors = arcanite_sf,
    _yams_elements = arcanite_elements
})

if minetest.get_modpath("farming") then
    farming.register_hoe("magic_materials:hoe_arcanite", {
        description = S("Arcanite Hoe"),
        inventory_image = "magic_materials_tool_hoe_arcanite.png",
        max_uses = 405,
        material = "magic_materials:arcanite_crystal",
        damage_groups = {fleshy = 4},
        full_punch_interval = 1.0,
        _yams_knockback = 2,
        _yams_anvil_difficulty = 1.5,
        _yams_stat_factors = arcanite_sf,
    })
end

if minetest.get_modpath("toolranks") then
    minetest.override_item("magic_materials:pick_arcanite", {
        description = toolranks.create_description(S("Arcanite Pickaxe"), 0, 0),
        original_description = S("Arcanite Pickaxe"),
        after_use = toolranks.new_afteruse
    })

    minetest.override_item("magic_materials:shovel_arcanite", {
        description = toolranks.create_description(S("Arcanite Shovel"), 0, 0),
        original_description = S("Arcanite Shovel"),
        after_use = toolranks.new_afteruse
    })

    minetest.override_item("magic_materials:axe_arcanite", {
        description = toolranks.create_description(S("Arcanite Axe"), 0, 0),
        original_description = S("Arcanite Axe"),
        after_use = toolranks.new_afteruse
    })

    minetest.override_item("magic_materials:sword_arcanite", {
        description = toolranks.create_description(S("Arcanite Sword"), 0, 0),
        original_description = S("Arcanite Sword"),
        after_use = toolranks.new_afteruse
    })

    minetest.override_item("magic_materials:hoe_arcanite", {
        description = toolranks.create_description(S("Arcanite Hoe"), 0, 0),
        original_description = S("Arcanite Hoe"),
        after_use = toolranks.new_afteruse
    })
end
