
local S = core.get_translator("mobs_monster")

local function gen_drops(pos)
	local res = {}

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 1, min = 1, max = 2}
		)
		table.insert(res,
			{name = "magic_materials:februm_crystal", chance = 4, min = 1, max = 1}
		)
	end

	if pos.y < -128 then
	    table.insert(res, {name = "default:bronze_ingot", chance = 4, min = 1, max = 1})
	end

	-- In case the player does not find lava by then
	if pos.y < -1024 then
		table.insert(res, {name = "default:obsidian", chance = 2, min = 1, max = 1})
	end

	-- In case the player hasn't found a dungeon with the book by then
	if pos.y < -1024 and minetest.get_modpath("nether") then
		table.insert(res, {
			name = "nether:book_of_portals", chance = 10, min = 1, max = 1}
		)
	end

	return res
end

-- Oerkki by PilzAdam

mobs:register_mob("mobs_monster:oerkki", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	-- Ranged attack is forced in do_custom
	shoot_interval = 60,  -- Make sure it shoots only once per shoot state
	shoot_offset = 2,
	attack_animals = true,
	pathfinding = true,
	reach = 2,
	damage = 4,
	damage_max = 45,
	yams_melee_effects = {
		{name = "yams_effects:mana_sap", duration = 15, chance = 50},
	},
	arrow = "mobs_monster:oerkki_orb",
	arrow_damage = 3,
	arrow_damage_max = 30,
	yams_arrow_effects = {
		{name = "yams_effects:attack_down_small", duration = 15, chance = 100},
		{name = "yams_effects:defense_down_small", duration = 15, chance = 100},
	},
	hp_min = 25,
	hp_max = 120,
	armor = 100,
	yams_resists = {
		yams_mese = {damage = 150, knockback = 100},
		yams_light = {damage = 200, knockback = 100},
		yams_dark = {damage = 0, knockback = 0},
	},
	collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
	visual = "mesh",
	mesh = "mobs_oerkki.b3d",
	textures = {
		{"mobs_oerkki.png"},
		{"mobs_oerkki2.png"},
		{"mobs_oerkki3.png"}
	},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_oerkki",
		war_cry = "mobs_oerkki",
		shoot_attack = "bweapons_magic_pack_void_fire",
	},
	walk_velocity = 1,
	run_velocity = 3,
	run_velocity_max = 5,
	view_range = 15,
	jump = true,
	jump_height = 4.0,
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 2,
	fear_height = 4,
	animation = {
		stand_start = 0, stand_end = 23,
		walk_start = 24, walk_end = 36,
		run_start = 37, run_end = 49,
		punch_start = 37, punch_end = 49,
		speed_normal = 15, speed_run = 15
	},
	base_exp = 400,
	max_exp = 7000,
	yams_scaling_opts = {
		cavern_start = -256,
		cavern_fast_until = -2240,
	},
	on_spawn = function(self)
		self._orb_cooldown = 0
		self._shoot_time = 0

		local pos = self.object:get_pos()
		if pos.y <= -1024 or pos.y >= 1000 then
			self.yams_arrow_effects = {
				{name = "yams_effects:attack_down_medium", duration = 15, chance = 100},
				{name = "yams_effects:defense_down_medium", duration = 15, chance = 100},
			}
		end
	end,
	
	do_custom = function(self, dtime, moveresult)
		self._orb_cooldown = self._orb_cooldown - dtime

		if self.attack and self.attack:get_pos() then
			if self._orb_cooldown <= 0 then
				local target_pos = self.attack:get_pos()
				target_pos.y = target_pos.y + 0.5  -- api.lua does this
				local dist = vector.distance(self.object:get_pos(), target_pos)
				local los = self:line_of_sight(self.object:get_pos(), target_pos)

				if dist <= 10 and los then
					self.attack_type = "shoot"
					self._orb_cooldown = 10
					self._shoot_time = 0
					self.timer = self.shoot_interval - 1.0

					-- YAMS-TODO: particle effects
					minetest.sound_play("mobs_spell", {object = self.object})
				else
					-- Only check once per second to decrease CPU usage
					self._orb_cooldown = 1
				end

			-- magical orb attack
			-- YAMS-TODO: make it interruptable by the player
			elseif self.attack_type == "shoot" then
				self._shoot_time = self._shoot_time + dtime
				if self._shoot_time >= 2 then
					self.attack_type = "dogfight"
					self._shoot_time = 0
				end
			end
		end
	end,
})

mobs:register_arrow("mobs_monster:oerkki_orb", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	-- YAMS-TODO: needs fallback and a decent tail effect
	textures = {"bweapons_magic_pack_void_projectile.png"},
	collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
	velocity = 15,
	damage = 4,

	on_activate = function(self, staticdata, dtime_s)
		-- make rock indestructable
		self.object:set_armor_groups({immortal = 1, fleshy = 100})
	end,
})

-- where to spawn

if not mobs.custom_spawn_monster then

	mobs:spawn({
		name = "mobs_monster:oerkki",
		nodes = {"default:stone", "default:desert_stone", "default:sandstone",
		"default:sand", "default:desert_sand", "default:silver_sand",
		"default:ice", "caverealms:stone_with_moss",
		"caverealms:stone_with_lichen", "caverealms:stone_with_algae",
		"caverealms:stone_with_salt", "caverealms:hot_cobble",
		"caverealms:thin_ice", "caverealms:glow_obsidian",
		"caverealms:glow_obsidian_2", "caverealms:coal_dust"},
		max_light = 4,
		interval = 15,
		chance = 8000,
		min_height = -19990,
		max_height = -256
	})
end

-- spawn egg

mobs:register_egg("mobs_monster:oerkki", S("Oerkki"), "default_obsidian.png", 1)

-- compatibility with older mobs mod

mobs:alias_mob("mobs:oerkki", "mobs_monster:oerkki")
