local S = core.get_translator("spears")

function spears_register_spear(spear_type, desc, base_damage, material,
                               punch_uses, fpi, kb, repair_diff)

	core.register_tool("spears:spear_" .. spear_type, {
		description = desc,
		wield_image = "spears_spear_" .. spear_type .. ".png^[transform4",
		inventory_image = "spears_spear_" .. spear_type .. ".png",
		wield_scale= {x = 1.5, y = 1.5, z = 1.5},
		on_secondary_use = function(itemstack, user, pointed_thing)
			spears_throw(itemstack, user, pointed_thing)
			if not core.settings:get_bool("creative_mode") then
				itemstack:take_item()
			end
			return itemstack
		end,
		on_place = function(itemstack, user, pointed_thing)
			if pointed_thing.type == "node" then
				local node = minetest.get_node(pointed_thing.under)
				local def = minetest.registered_nodes[node.name]
				if def.on_rightclick then
					return def.on_rightclick(pointed_thing.under, node, user, itemstack)
				end
			end

			spears_throw(itemstack, user, pointed_thing)
			if not core.settings:get_bool("creative_mode") then
				itemstack:take_item()
			end
			return itemstack
		end,
		tool_capabilities = {
			full_punch_interval = fpi,
			max_drop_level=1,
			groupcaps={},
			damage_groups = {fleshy=base_damage},
			punch_attack_uses = punch_uses,
		},
		sound = {breaks = "default_tool_breaks"},
		groups = {flammable = 1},
		_yams_knockback = kb,
		_yams_anvil_difficulty = repair_diff,
		_yams_stat_factors = {primary = "dex", secondary = "str",
		                      str = 0.3, dex = 0.7, int = 0.0},
		-- Can and should be overridden
		_yams_elements = {yams_physical = 100, yams_neutral = 100}
	})

	-- Make throwing a spear apply six times as much wear
	local SPEAR_ENTITY = spears_set_entity(spear_type, base_damage, punch_uses / 6)
	
	core.register_entity("spears:spear_" .. spear_type .. "_entity", SPEAR_ENTITY)
	
	core.register_craft({
		output = 'spears:spear_' .. spear_type,
		recipe = {
			{"", "", material},
			{"", "group:stick", ""},
			{"group:stick", "", ""}
		}
	})
	
	core.register_craft({
		output = 'spears:spear_' .. spear_type,
		recipe = {
			{material, "", ""},
			{"", "group:stick", ""},
			{"", "", "group:stick"}
		}
	})
end

--[[
yams-specific notes on various stats:
* punch_attack_uses will be the same as the sword counterpart
* full_punch_interval will be 0.2 seconds higher than the sword counterpart
* knockback will be equivalent to the corresponding axe
* repair difficulty will be equivalent to the corresponding sword
* stats for spears that are not used in yams are not as refined
]]--

if core.settings:get_bool('spears_enable_stone_spear', true) then
	spears_register_spear('stone', S('Stone Spear'), 4, 'group:stone', 60, 1.4, 6.5, 0.5)
end

if core.get_modpath("pigiron") then
	if core.settings:get_bool('spears_enable_iron_spear', false) then
		--spears_register_spear('iron', S('Iron Spear'), 5, 'pigiron:iron_ingot', 225, 1.0, 7.0, 1.0)
	end
	if core.settings:get_bool('spears_enable_steel_spear', true) then
		spears_register_spear('steel', S('Steel Spear'), 6, 'default:steel_ingot', 270, 1.0, 7.5, 1.0)
	end
	if core.settings:get_bool('spears_enable_copper_spear', true) then
		spears_register_spear('copper', S('Copper Spear'), 5, 'default:copper_ingot', 175, 1.0, 7.0, 1.0)
	end
	if core.settings:get_bool('spears_enable_bronze_spear', true) then
		spears_register_spear('bronze', S('Bronze Spear'), 6, 'default:bronze_ingot', 225, 1.0, 7.5, 1.0)
	end
else
	if core.settings:get_bool('spears_enable_steel_spear', true) then
		spears_register_spear('steel', S('Steel Spear'), 6, 'default:steel_ingot', 270, 1.0, 7.5, 1.0)
	end
	if core.settings:get_bool('spears_enable_copper_spear', true) then
		spears_register_spear('copper', S('Copper Spear'), 5, 'default:copper_ingot', 175, 1.0, 7.0, 1.0)
	end
	if core.settings:get_bool('spears_enable_bronze_spear', true) then
		spears_register_spear('bronze', S('Bronze Spear'), 6, 'default:bronze_ingot', 225, 1.0, 7.5, 1.0)
	end
end

if core.settings:get_bool('spears_enable_obsidian_spear', true) then
	spears_register_spear('obsidian', S('Obsidian Spear'), 8, 'default:obsidian', 810, 1.1, 8.5, 2.0)
end

if core.settings:get_bool('spears_enable_diamond_spear', true) then
	spears_register_spear('diamond', S('Diamond Spear'), 8, 'default:diamond', 1080, 0.9, 8.5, 2.0)
end

if core.settings:get_bool('spears_enable_gold_spear', true) then
	spears_register_spear('gold', S('Golden Spear'), 5, 'default:gold_ingot', 225, 1.0, 7.0, 1.5)
end
