
-- translation and custom land guard types

local S = core.get_translator("mobs_monster")

local guard_types = {

	{	nodes = {
			"default:snow", "default:snowblock", "default:ice",
			"default:dirt_with_snow", "default:permafrost_with_stones"
		},
		skins = {"mobs_land_guard6.png", "mobs_land_guard7.png", "mobs_land_guard8.png"},
		drops = {
			{name = "default:ice", chance = 1, min = 1, max = 4},
			{name = "mobs:leather", chance = 2, min = 0, max = 2},
			{name = "default:diamond", chance = 4, min = 0, max = 2},
		},
	},

	{	nodes = {
			"ethereal:dry_dirt", "default:sand", "default:desert_sand",
			"default:dry_dirt_with_dry_grass", "default:dry_dirt"
		},
		skins = {"mobs_land_guard4.png", "mobs_land_guard5.png"},
		drops = {
			{name = "default:sandstone", chance = 1, min = 1, max = 4},
			{name = "mobs:leather", chance = 2, min = 0, max = 2},
			{name = "default:mese_crystal", chance = 4, min = 0, max = 2},
		},
	}
}

local function gen_drops(pos)
	local res = {}

	table.insert(res, {name = "default:coalblock", chance = 1, min = 1, max = 1})
	table.insert(res, {name = "default:tin_lump", chance = 8, min = 1, max = 1})
	table.insert(res, {name = "default:copper_lump", chance = 2, min = 2, max = 4})
	table.insert(res, {name = "default:iron_lump", chance = 4, min = 1, max = 1})

	if pos.y > 1024 then
		table.insert(res, {name = "default:diamond", chance = 20, min = 1, max = 1})
	end

	if pos.y > 2048 and minetest.get_modpath("moreores") then
		table.insert(res, {name = "moreores:mithril_lump", chance = 50, min = 1, max = 1})
	end

	if minetest.registered_items["farming:burger"] then
		table.insert(res, {name = "farming:burger", chance = 100, min = 1, max = 1})
	end

	if minetest.get_modpath("magic_materials") then
		table.insert(res,
			{name = "magic_materials:egerum_crystal", chance = 1, min = 2, max = 4}
		)
		table.insert(res,
			{name = "magic_materials:februm_crystal", chance = 4, min = 1, max = 1}
		)
	end

	if minetest.get_modpath("yams_materials") then
		local essence = "yams_materials:earth_essence"
		local bdata = minetest.get_biome_data(pos)
		if bdata then
			local bname = minetest.get_biome_name(bdata.biome)
			if bname == "taiga" or bname == "snowy_grassland" or
			       bname == "tundra" or bname == "icesheet" then
				essence = "yams_materials:ice_essence"
			end
		end

		table.insert(res, {name = essence, chance = 1, min = 1, max = 1})
	end

	return res
end

-- Land Guard

mobs:register_mob("mobs_monster:land_guard", {
	type = "monster",
	passive = false,
	attack_type = "dogfight",
	pathfinding = true,
	docile_by_day = true,
	reach = 2,
	damage = 6,
	damage_max = 90,
	yams_melee_effects = {
		{name = "yams_effects:defense_down_small", duration = 15, chance = 100},
	},
	arrow_damage = 4,
	arrow_damage_max = 60,
	yams_arrow_effects = {
		{name = "yams_effects:defense_down_small", duration = 15, chance = 100},
	},
	melee_knockback = 12.0,
	hp_min = 90,
	hp_max = 450,
	armor = 100,
	collisionbox = {-0.5, -1.01, -0.5, 0.5, 1.6, 0.5},
	visual_size = {x = 1, y = 1},
	visual = "mesh",
	mesh = "mobs_dungeon_master.b3d",
	textures = {
		{"mobs_land_guard.png"},
		{"mobs_land_guard2.png"},
		{"mobs_land_guard3.png"}
	},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_dungeonmaster",
		war_cry = "mobs_dungeonmaster",
	},
	walk_velocity = 1,
	run_velocity = 2,
	jump = true,
	jump_height = 6.0,
	floats = 1,
	view_range = 5,  -- Make it easy to avoid as long as it is not hit
	drops = gen_drops,
	water_damage = 0,
	lava_damage = 8,
	light_damage = 0,
	fear_height = 8,
	animation = {
		stand_start = 0, stand_end = 19,
		walk_start = 20, walk_end = 35,
		punch_start = 36, punch_end = 48,
		speed_normal = 15, speed_run = 20,
		shoot_start = 36, shoot_end = 48,
	},
	base_exp = 500,
	max_exp = 20000,

	-- check surrounding nodes and spawn a specific guard
	on_spawn = function(self)

		local pos = self.object:get_pos() ; pos.y = pos.y - 1
		local tmp

		for n = 1, #guard_types do

			tmp = guard_types[n]

			if core.find_node_near(pos, 1, tmp.nodes) then

				self.base_texture = { tmp.skins[math.random(#tmp.skins)] }
				self.object:set_properties({textures = self.base_texture})
				
				if n == 1 then  -- ice land guard
					self.yams_resists = {yams_ice = {damage = 0, knockback = 0}}
				end

				return true
			end
		end

		return true -- run only once, false/nil runs every activation
	end,

	do_custom = function(self, dtime, moveresult)
		-- Reset aggro if is not attacking anything
		if not self.attack and self._aggro then
			self.object:set_properties({textures = self.base_texture})

			self.run_velocity = self.run_velocity - 2
			self.attack_type = "dogfight"
			self.view_range = 5

			self._aggro = false
			self.dogshoot_count = 0
		end
	end,

	do_punch = function(self, hitter, tflp, tool_capabilities, dir)
		local prop = self.object:get_properties()

		-- Become more aggressive when hit and gain a ranged attack
		if not self._aggro then
			-- Give the land guard a red tint to warn the player that they
			-- made the land guard angry
			local tex = {self.base_texture[1] .. "^[colorize:#FF0000:128"}
			self.object:set_properties({textures = tex})

			self.run_velocity = self.run_velocity + 2
			self.view_range = 32

			self.attack_type = "dogshoot"
			self.arrow = "mobs_monster:land_guard_rock"
			self.dogshoot_switch = math.random(1, 2)
			self.dogshoot_count_max = math.random(3, 6)
			self.dogshoot_count2_max = math.random(3, 6)
			self.shoot_interval = 1
			self.shoot_offset = 2

			self._aggro = true
		-- Randomly change attack upon getting hit
		else
			self.dogshoot_count = self.dogshoot_count + math.random() * 2.0
		end

		return true
	end,
})

-- where to spawn

if not mobs.custom_spawn_monster then
	mobs:spawn({
		name = "mobs_monster:land_guard",
		nodes = {
			"default:dirt_with_snow", "default:ice", "default:snowblock",
			"default:permafrost_with_stones",
			"default:sand", "default:desert_sand", "default:silver_sand",
			"default:dry_dirt_with_dry_grass", "ethereal:dry_dirt",
			"default:dirt_with_grass", "ebiomes:dirt_with_grass_med",
			"ebiomes:dirt_with_grass_steppe", "ebiomes:dirt_with_grass_steppe_cold",
			"ebiomes:dirt_with_grass_steppe_warm",
			"ebiomes:dry_dirt_with_grass_arid_cool",
			"ebiomes:dry_dirt_with_grass_arid", "ebiomes:dirt_with_grass_warm",
		},
		neighbors = {},
		max_light = 4,
		interval = 15,
		chance = 256000,
		min_height = 0,
		max_height = 8190,
		-- Do not spawn in forests
		biome_deny = {"deciduous_forest_fruity", "deciduous_forest_woody",
		"deciduous_forest_warm"},
	})
end

-- YAMS-TODO: change when rocks are added
mobs:register_arrow("mobs_monster:land_guard_rock", {
	visual = "sprite",
	visual_size = {x = 1, y = 1},
	textures = {"default_coal_lump.png^[colorize:#999999:255"},
	collisionbox = {-0.2, -0.2, -0.2, 0.2, 0.2, 0.2},
	velocity = 16,
	damage = 4,

	on_activate = function(self, staticdata, dtime_s)
		-- make rock indestructable
		self.object:set_armor_groups({immortal = 1, fleshy = 100})
	end,
})

-- spawn egg

mobs:register_egg("mobs_monster:land_guard", S("Land Guard"), "default_ice.png", 1)
