mobs:register_mob("tmw_slimes:lava_slime", {
	group_attack = true,
	type = "monster",
	passive = false,
	attack_animals = true,
	attack_npcs = true,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 4,
	damage_max = 40,
	hp_min = 20,
	hp_max = 120,
	armor = 100,
	yams_resists = {
		yams_fire = {damage = -100, knockback = 0},
		yams_ice = {damage = 200, knockback = 100},
	},
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_liquid.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["lava"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["lava"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["lava"].."^[colorize:#FFF:96"},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 1.25,
	run_velocity_max = 4,
	jump_height = 7,
	jump = true,
	view_range = 15,
	--fly = true,
	--fly_in = {"default:water_source", "default:water_flowing", "default:river_water_source", "default:river_water_flowing"},
	drops = {
		{name = "tmw_slimes:lava_goo", chance = 1, min = 1, max = 2}
	},
	water_damage = 8,
	lava_damage = -8,
	fire_damage = -4,
	light_damage = 0,
	fall_damage = false,
	replace_rate = 2,
	replace_what = {
		{"air", "fire:basic_flame", 0},
	},
	animation = {
		idle_start = 0,
		idle_end = 19,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 100,
	max_exp = 1250,
	yams_scaling_opts = {
		cavern_start = -256,
		cavern_fast_until = -2496,
	},
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
		self.stomach = nil
	end,
	-- Nope, sorry. This is a lava slime. Your items are GONE.
	--[[on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end]]
})

minetest.registered_entities["tmw_slimes:lava_slime"].glow = 10

minetest.override_item("tmw_slimes:lava_goo", {on_use = minetest.item_eat(-5)})

local g = table.copy(minetest.registered_nodes["tmw_slimes:lava_goo_block"].groups)
g.harmful_slime = tmw_slimes.strong_dmg
minetest.override_item("tmw_slimes:lava_goo_block", {groups=table.copy(g)})

mobs:spawn({
	name = "tmw_slimes:lava_slime",
	nodes = {
		"default:lava_source",
	},
	interval = 15,
	chance = 128000,
	max_height = -256,
})
