
local S = core.get_translator("mobs_animal")

-- Warthog originally by KrupnoPavel, B3D model by sirrobzeroone

mobs:register_mob("mobs_animal:pumba", {
	stepheight = 0.6,
	type = "animal",
	passive = false,
	attack_type = "dogfight",
	group_attack = true,
	owner_loyal = true,
	attack_npcs = false,
	reach = 2,
	damage = 2,
	hp_min = 9,
	hp_max = 12,
	armor = 100,
	collisionbox = {-0.4, -0.01, -0.4, 0.4, 0.95, 0.4},
	visual = "mesh",
	mesh = "mobs_pumba.b3d",
	textures = {{"mobs_pumba.png"}},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_pig",
		attack = "mobs_pig_angry"
	},
	walk_velocity = 2,
	run_velocity = 3,
	jump = true,
	jump_height = 6,
	pushable = true,
	follow = {
		"group:grass", "default:apple",
		"farming:carrot", "farming:potato", "group:food_berry"
	},
	view_range = 10,
	replace_rate = 10,
	replace_what = {
		{"group:grass", "air", -1},
		{"default:dirt_with_grass", "default:dirt", -2}
	},
	drops = {
		{name = "mobs:pork_raw", chance = 1, min = 1, max = 1}
	},
	water_damage = 0.01,
	lava_damage = 8,
	light_damage = 0,
	fear_height = 2,
	animation = {
		speed_normal = 15,
		stand_start = 25, stand_end = 55,
		walk_start = 70, walk_end = 100,
		punch_start = 70, punch_end = 100,
		-- no specific dying animation, so use 2 frames at 1fps and rotate
		die_start = 1, die_end = 2, die_speed = 1,
		die_loop = false, die_rotate = true
	},
	base_exp = 10,

	on_rightclick = function(self, clicker)

		if mobs:feed_tame(self, clicker, 8, true, true) then return end
		if mobs:protect(self, clicker) then return end
		if mobs:capture_mob(self, clicker, 0, 0, 100, false, nil) then return end
	end
})


local spawn_on = {"default:dirt_with_grass"}
local spawn_by = {}

if minetest.get_mapgen_setting("mg_name") ~= "v6" then
	spawn_on = {"default:dirt_with_dry_grass",
		    "default:dry_dirt_with_dry_grass"}
	spawn_by = {}
end

if minetest.get_modpath("ethereal") then
	table.insert(spawn_on, "ethereal:mushroom_dirt")
	table.insert(spawn_by, "flowers:mushroom_brown")
	table.insert(spawn_by, "flowers:mushroom_red")
end

if minetest.get_modpath("ebiomes") then
	local extras = {"ebiomes:dry_dirt_with_grass_arid",
			"ebiomes:dirt_with_grass_warm",
			"ebiomes:dry_dirt_with_humid_savanna_grass"}

	for i = 1, #extras do
		table.insert(spawn_on, extras[i])
	end
end

-- where to spawn

if not mobs.custom_spawn_animal then

	local spawn_on = {"default:dirt_with_grass", "default:dry_dirt_with_dry_grass"}
	local spawn_by = {"group:grass"}

	if core.get_modpath("ethereal") then
		spawn_on = {"ethereal:mushroom_dirt"}
		spawn_by = {"flowers:mushroom_brown", "flowers:mushroom_red"}
	end

	mobs:spawn({
		name = "mobs_animal:pumba",
		nodes = spawn_on,
		neighbors = spawn_by,
		min_light = 10,
		interval = 15,
		chance = 32000,
		min_height = 0,
		max_height = 8190,
		day_toggle = true,
		biome_deny = {"deciduous_forest_warm"}
	})
end

-- spawn egg

mobs:register_egg("mobs_animal:pumba", S("Warthog"), "mobs_pumba_inv.png")

-- old mobs mod compatibility

mobs:alias_mob("mobs:pumba", "mobs_animal:pumba")

-- raw porkchop

core.register_craftitem(":mobs:pork_raw", {
	description = S("Raw Porkchop"),
	inventory_image = "mobs_pork_raw.png",
	on_use = core.item_eat(4),
	groups = {food_meat_raw = 1, food_pork_raw = 1}
})

mobs.add_eatable("mobs:pork_raw", 4)

-- cooked porkchop and recipe

core.register_craftitem(":mobs:pork_cooked", {
	description = S("Cooked Porkchop"),
	inventory_image = "mobs_pork_cooked.png",
	on_use = core.item_eat(8),
	groups = {food_meat = 1, food_pork = 1},
	_yams_food_effects = {
		{name = "yams_effects:well_fed_small", duration = 180},
	},
	_yams_tt_effect_descs = {
		{
			name = S("Well Fed S"),
			desc = S("Gain +10% EXP from most sources for three minutes.")
		},
	}
})

mobs.add_eatable("mobs:pork_cooked", 8)

core.register_craft({
	type = "cooking",
	output = "mobs:pork_cooked",
	recipe = "mobs:pork_raw",
	cooktime = 3
})
