-- Overrides for the melon

-- We only need to add the seed item, prevent the melon slice from being
-- used as a seed, and change the plant graphics

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_melon", {
    description = S("Melon Seeds"),
    tiles = {"x_farming_melon_seed.png"},
    inventory_image = "x_farming_melon_seed.png",
    wield_image = "x_farming_melon_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_melon")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:melon_1", param2 = 3})
    end
})

-- We do not go to 8 because that is the melon block itself and it will be
-- handled separately; also we keep the melon block's graphics from Farming
-- Redo since they are okay
for i = 1, 7 do
    local x = tostring(i)
    core.override_item("farming:melon_" .. x, {
        tiles = {"x_farming_melon_" .. x .. ".png"},
    })
end

core.override_item("farming:melon_8", {
    on_dig = function(pos, node, digger)
        -- Prevent an infinite seed exploit by only dropping seeds if this
        -- melon block had just grown
        if core.node_dig(pos, node, digger) and node.param1 == 0 then
            local num = tostring(math.random(1, 2))
            local seeds = ItemStack("farming:seed_melon " .. num)
            local inv = digger:get_inventory()
            local leftover = inv:add_item("main", seeds)
            if not leftover:is_empty() then
                core.item_drop(seeds, digger, pos)
            end
        end
    end,
    on_place = function(itemstack, placer, pointed_thing)
        local res = core.rotate_node(itemstack, placer, pointed_thing)
        local pos = pointed_thing.above
        local n = core.get_node(pos)
        -- Nodes placed by the player will not give seeds when broken
        core.set_node(pos, {name=n.name, param1=1, param2=n.param2})

        return res
    end,
})

-- Override parts of the melon item so that it cannot be used as a seed
-- Additionally, make it cure poison
core.override_item("farming:melon_slice", {
    groups = {compostability = 50, food_melon_slice = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
    _yams_food_effects = {
        {name = "yams_effects:poison_ward", duration = 60},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Poison Ward"),
            -- YAMS-TODO: this is not ideal for translators at all
            desc = S("Cure poison, and protect against poison") .. "\n" ..
                   S("from an enemy attack once. This effect is") .. "\n" ..
                   S("removed after poison is blocked or after") .. "\n" ..
                   S("60 seconds.")
        },
    }
})

-- Do not make scythes affect this crop
farming.registered_plants["farming:melon"].seed = "farming:seed_melon"
farming.registered_plants["farming:melon"].disable_scythe = true

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:melon_", 8, "farming:seed_melon"},
    })
end
