-- Use value() to obtain the modifier
yams.damage_taken_monoid = player_monoids.make_monoid({
    combine = function(factor1, factor2)
        return factor1 * factor2
    end,
    fold = function(factors)
        local res = 1

        for _, val in pairs(factors) do
            res = res * val
        end

        return res
    end,
    apply = function(multiplier, player) return end,
    identity = 1,
})

-- Use value() to obtain the modifier
-- Similar to damage taken but it's a flat reduction instead
yams.tough_skin_monoid = player_monoids.make_monoid({
    combine = function(scalar1, scalar2)
        return scalar1 + scalar2
    end,
    fold = function(scalars)
        local res = 0

        for _, val in pairs(scalars) do
            res = res + val
        end

        return res
    end,
    apply = function(sum, player) return end,
    identity = 0,
})

-- Use value() to obtain the modifier
yams.damage_given_monoid = player_monoids.make_monoid({
    combine = function(factor1, factor2)
        return factor1 * factor2
    end,
    fold = function(factors)
        local res = 1

        for _, val in pairs(factors) do
            res = res * val
        end

        return res
    end,
    apply = function(multiplier, player) return end,
    identity = 1,
})

-- YAMS-TODO: account for multiple negative modifiers maybe
yams.mana_regen_monoid = player_monoids.make_monoid({
    combine = function(factor1, factor2)
        return factor1 * factor2
    end,
    fold = function(factors)
        local res = 1

        for _, val in pairs(factors) do
            res = res * val
        end

        return res
    end,
    apply = function(multiplier, player)
        local name = player:get_player_name()
        local max = mana.getmax(name)
        local new_regen = (max / 200) * multiplier

        mana.setregen(name, new_regen)
    end,
    identity = 1
})

yams.stamina_regen_monoid = player_monoids.make_monoid({
    combine = function(factor1, factor2)
        return factor1 * factor2
    end,
    fold = function(factors)
        local res = 1

        for _, val in pairs(factors) do
            res = res * val
        end

        return res
    end,
    -- value() is called in the 'sprint_lite' mod
    apply = function(multiplier, player) return end,
    identity = 1
})

-- Use value() to obtain the modifier
-- This is an additive monoid
yams.exp_gain_monoid = player_monoids.make_monoid({
    combine = function(factor1, factor2)
        return factor1 + factor2
    end,
    fold = function(factors)
        local res = 1

        for _, val in pairs(factors) do
            res = res + val
        end

        return res
    end,
    apply = function(multiplier, player) return end,
    identity = 1,
})

yams.morale_monoid = player_monoids.make_monoid({
    combine = function(p, q)
        return p or q
    end,
    fold = function(elems)
        for _, v in pairs(elems) do
            if v then
                return true
            end
        end
    end,
    apply = function(morale_active, player)
        local meta = player:get_meta()
        if morale_active then
            meta:set_int("yams_rpg:morale", 1)
        else
            meta:set_int("yams_rpg:morale", 0)
        end
    end,
    identity = false,
})
