-- Overrides for the chili pepper

-- We only need to add the seed item and prevent the actual chili pepper from
-- being used as a seed

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_chili_pepper", {
    description = S("Chili Pepper Seeds"),
    tiles = {"farming_oat_seed.png^[colorize:red"},  -- lol
    inventory_image = "farming_oat_seed.png^[colorize:red",
    wield_image = "farming_oat_seed.png^[colorize:red",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 4, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_chili_pepper")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:chili_1", param2 = 3})
    end
})

-- Override parts of the chili pepper item so that it cannot be used as a seed
-- Farming Redo's inventory image is kept since it is fine
core.override_item("farming:chili_pepper", {
    groups = {compostability = 65, food_chili_pepper = 1, flammable = 4}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- Make the final three stages drop seeds and rebalance to account for the new
-- seed item
core.override_item("farming:chili_6", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_chili_pepper"}},
        }
    }
})

core.override_item("farming:chili_7", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_chili_pepper"}},
            {rarity = 1, items = {"farming:chili_pepper"}},
        }
    }
})

core.override_item("farming:chili_8", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_chili_pepper"}},
            {rarity = 2, items = {"farming:seed_chili_pepper"}},
            {rarity = 1, items = {"farming:chili_pepper"}},
            {rarity = 2, items = {"farming:chili_pepper"}},
        }
    }
})

-- This is a workaround that makes scythes work with the chili pepper crop
-- The problem is that the 'sickles' tries to look for a registered plant
-- named 'farming:chili' instead of 'farming:chili_pepper'
-- YAMS-TODO: fix it in the 'sickles' mod
farming.registered_plants["farming:chili_pepper"] = nil
farming.registered_plants["farming:chili"] = {
    crop = "farming:chili_pepper",
    seed = "farming:seed_chili_pepper",
    minlight = farming.min_light,
    maxlight = farming.max_light,
    steps = 8
}

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:chili_", 8, "farming:seed_chili_pepper"},
    })
end
