-- Translation support
local S = core.get_translator("yams_mobs")

local function gen_drops(pos)
    local res = {}

    if core.registered_items["flowers:mushroom_brown"] then
        table.insert(res,
            {name = "flowers:mushroom_brown", chance = 1, min = 1, max = 1}
        )
    end

    if core.get_modpath("magic_materials") then
        table.insert(res,
            {name = "magic_materials:egerum_crystal", chance = 4, min = 1, max = 1}
        )
    end

    return res
end

mobs:register_mob("yams_mobs:nether_leech", {
    type = "monster",
    passive = false,
    attack_type = "dogfight",
    attack_animals = true,
    stepheight = 0.1,
    pathfinding = false,
    reach = 1.5,
    damage = 3,
    damage_max = 15,
    melee_knockback = 4.0,
    melee_interval = 0.4,
    yams_melee_effects = {
        {name = "yams_effects:mana_sap", duration = 15, chance = 25},
    },
    hp_min = 10,
    hp_max = 32,
    armor = 100,
    yams_resists = {
        yams_fire = {damage = 50, knockback = 50},
        yams_mese = {damage = 150, knockback = 100},
        yams_light = {damage = 200, knockback = 100},
        yams_dark = {damage = -100, knockback = 0},
    },
    collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
    visual = "cube",
    visual_size = {x = 1, y = 1, z = 1},
    textures = {
        "yams_nether_leech_top.png",
        "yams_nether_leech_bottom.png",
        "yams_nether_leech_side.png",
        "yams_nether_leech_side.png",
        "yams_nether_leech_side.png^yams_nether_leech_mouth.png",
        "yams_nether_leech_side.png",
    },
    glow = 5,
    makes_footstep_sound = false,
    -- YAMS-TODO: find a death sound
    sounds = {
        war_cry = "yams_nether_leech_attack",
        attack = "yams_nether_leech_attack",
    },
    view_range = 15,
    walk_velocity = 4,
    run_velocity = 6,
    run_velocity_max = 8,
    fly = true,
    fly_in = "air",
    drops = gen_drops,
    fire_damage = 2,
    water_damage = 0,
    lava_damage = 4,
    light_damage = 2,
    base_exp = 100,
    max_exp = 1500,
})

mobs:spawn({
    name = "yams_mobs:nether_leech",
    nodes = {"nether:rack", "nether:rack_deep", "nether:geode"},
    interval = 15,
    chance = 12000,
    max_height = -20000
})

mobs:register_egg("yams_mobs:nether_leech", S("Nether Leech"),
                  "yams_nether_leech_mouth.png", 0)
