
local S = core.get_translator("farming")

-- item/seed

core.register_craftitem("farming:lettuce", {
	description = S("Lettuce"),
	inventory_image = "farming_lettuce.png",
	groups = {compostability = 48, seed = 2, food_lettuce = 1},
	on_use = core.item_eat(2),

	on_place = function(itemstack, placer, pointed_thing)
		return farming.place_seed(itemstack, placer, pointed_thing, "farming:lettuce_1")
	end
})

farming.add_eatable("farming:lettuce", 2)

-- crop definition

local def = {
	description = S("Lettuce") .. S(" Crop"),
	drawtype = "plantlike",
	tiles = {"farming_lettuce_1.png"},
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	drop =  "",
	selection_box = farming.select,
	groups = {
		handy = 1, snappy = 3, flammable = 2, plant = 1, attached_node = 1,
		not_in_creative_inventory = 1, growing = 1
	},
	_mcl_hardness = farming.mcl_hardness,
	is_ground_content = false,
	sounds = farming.node_sound_leaves_defaults()
}

-- stage 1

core.register_node("farming:lettuce_1", table.copy(def))

-- stage 2

def.tiles = {"farming_lettuce_2.png"}
core.register_node("farming:lettuce_2", table.copy(def))

-- stage 3

def.tiles = {"farming_lettuce_3.png"}
core.register_node("farming:lettuce_3", table.copy(def))

-- stage 4

def.tiles = {"farming_lettuce_4.png"}
core.register_node("farming:lettuce_4", table.copy(def))

-- stage 5

def.tiles = {"farming_lettuce_5.png"}
def.groups.growing = nil
def.selection_box = farming.select_final
def.drop = {
	items = {
		{items = {"farming:lettuce 2"}, rarity = 1},
		{items = {"farming:lettuce"}, rarity = 3}
	}
}
core.register_node("farming:lettuce_5", table.copy(def))

-- add to registered_plants

farming.registered_plants["farming:lettuce"] = {
	crop = "farming:lettuce",
	seed = "farming:lettuce",
	minlight = farming.min_light,
	maxlight = farming.max_light,
	steps = 5
}

-- mapgen

core.register_decoration({
	deco_type = "simple",
	place_on = {
		"default:dirt_with_grass", "mcl_core:dirt_with_grass",
		"ebiomes:dirt_with_grass_warm", "ebiomes:dirt_with_grass_cold",
		"ebiomes:dirt_with_grass_steppe", "ebiomes:dirt_with_grass_steppe_warm",
		"ethereal:prairie_dirt"
	},
	sidelen = 16,
	noise_params = {
		offset = 0,
		scale = farming.lettuce,
		spread = {x = 100, y = 100, z = 100},
		seed = 689,
		octaves = 3,
		persist = 0.7
	},
	-- Notes on the reasoning:
	-- * In yams, both temperate and winter varieties of lettuce are taken into
	-- account
	-- * Lettuce in real-life prefer colder weather, so unlike carrots, do not
	-- spawn them in the mediterranean biome within yams
	-- * We also spawn lettuce in colder biomes to give players a better chance
	-- of survival when spawning in those biomes, but this is done at a lower
	-- rate (see below)
	-- * Many plants in real-life do not grow well in full shade, but we
	-- disregard that detail in yams since the average player will not notice,
	-- and this simplification benefits the gameplay; thus, we have lettuce
	-- spawn in forest biomes that have the same grasses as the grassland biomes
	biomes = {
		"grassland", "grassland_coldish", "grassland_warm", "deciduous_forest",
		"deciduous_forest_woody", "deciduous_forest_fruity",
		"deciduous_forest_cold", "deciduous_forest_warm", "steppe",
		"warm_steppe"
	},
	y_min = 1,
	y_max = 64,
	decoration = "farming:lettuce_4"
})

-- This is for colder biomes; lettuce will spawn much less frequently in them
minetest.register_decoration({
	deco_type = "simple",
	place_on = {
		"default:dirt_with_snow", "ebiomes:dirt_with_grass_steppe_cold"
	},
	sidelen = 16,
	noise_params = {
		offset = 0,
		scale = 0.001,
		spread = {x = 100, y = 100, z = 100},
		seed = 4447,
		octaves = 3,
		persist = 0.7
	},
	biomes = {
		"snowy_grassland", "taiga", "cold_steppe"
	},
	y_min = 1,
	y_max = 64,
	-- It is intentional that this is the same as the above definition since
	-- this crop does not have that many stages anyway, and the texture for its
	-- third stage does not look like something that would yield anything
	-- useful when harvested
	decoration = "farming:lettuce_4"
})
