mobs:register_mob("tmw_slimes:algae_slime", {
	group_attack = true,
	type = "animal",
	passive = false,
	attack_animals = false,
	attack_npcs = false,
	attack_monsters = false,
	attack_type = "dogfight",
	reach = 1,
	damage = 2,
	hp_min = 18,
	hp_max = 22,
	armor = 100,
	yams_resists = {
		yams_fire = {damage = 50, knockback = 50},
		yams_ice = {damage = 50, knockback = 50},
		yams_electric = {damage = 150, knockback = 100},
	},
	collisionbox = {-0.2, -0.01, -0.2, 0.2, 0.4, 0.2},
	visual_size = {x = 2, y = 2},
	visual = "mesh",
	mesh = "slime_liquid.b3d",
	blood_texture = "tmw_slime_goo.png^[colorize:"..tmw_slimes.colors["algae"],
	textures = {
		{"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["algae"],"tmw_slime_goo_block.png^[colorize:"..tmw_slimes.colors["algae"].."^[colorize:#FFF:96"},
	},
	makes_footstep_sound = false,
	walk_velocity = 0.5,
	run_velocity = 1.25,
	jump_height = 7,
	jump = true,
	view_range = 15,
	drops = {
		{name = "tmw_slimes:algae_goo", chance = 1, min = 1, max = 2},
	},
	water_damage = 0,
	lava_damage = 8,
	light_damage = 0,
	fall_damage = false,
	animation = {
		idle_start = 0,
		idle_end = 19,
		move_start = 21,
		move_end = 41,
		fall_start = 42,
		fall_end = 62,
		jump_start = 63,
		jump_end = 83
	},
	base_exp = 5,
	do_custom = function(self)
		tmw_slimes.animate(self)
		tmw_slimes.absorb_nearby_items(self)
	end,
	on_die = function(self, pos)
		tmw_slimes.drop_items(self, pos)
	end
})

minetest.override_item("tmw_slimes:algae_goo", {
	on_use = minetest.item_eat(2),
	_yams_food_effects = {
		{name = "yams_effects:clear_all", duration = 1},
	},
	_yams_tt_effect_descs = {
		{
			-- YAMS-TODO: translate
			name = "Dispel",
			desc = "Removes most positive and negative status effects."
		},
	}
})

mobs:spawn({
	name = "tmw_slimes:algae_slime",
	nodes = {
		"default:water_source",
	},
	neighbors = {
		"default:water_source",
	},
	interval = 15,
	chance = 128000,
	min_height = -32,
	max_height = 0,
})
