-- Overrides for the carrot

-- We only need to add the seed item and prevent the actual carrot from being
-- used as a seed, then we just need to override the graphics

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_carrot", {
    description = S("Carrot Seeds"),
    tiles = {"x_farming_carrot_seed.png"},
    inventory_image = "x_farming_carrot_seed.png",
    wield_image = "x_farming_carrot_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_carrot")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:carrot_1", param2 = 3})
    end
})

-- Override parts of the carrot item so that it cannot be used as a seed
-- Farming Redo's inventory image is kept since it is fine
core.override_item("farming:carrot", {
    groups = {compostability = 65, food_carrot = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- Override the carrot crop graphics
for i = 1, 8 do
    local x = tostring(i)
    core.override_item("farming:carrot_" .. x, {
        tiles = {"x_farming_carrot_" .. x .. ".png"},
    })
end

-- Make the final three stages drop seeds and rebalance to account for the new
-- seed item
-- YAMS-TODO: stage 6 does not look different from stage 7, so there is no
-- visual indication that it will drop less items; at some point there needs
-- to be a distinct texture for each stage to fix this
core.override_item("farming:carrot_6", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_carrot"}},
        }
    }
})

core.override_item("farming:carrot_7", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_carrot"}},
            {rarity = 1, items = {"farming:carrot"}},
        }
    }
})

core.override_item("farming:carrot_8", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_carrot"}},
            {rarity = 2, items = {"farming:seed_carrot"}},
            {rarity = 1, items = {"farming:carrot"}},
            {rarity = 2, items = {"farming:carrot"}},
        }
    }
})

-- Make sure that the 'sickles' mod knows what seed to take away from the player
farming.registered_plants["farming:carrot"].seed = "farming:seed_carrot"

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:carrot_", 8, "farming:seed_carrot"},
    })
end
