-- Overrides for the lettuce

-- We only need to add the seed item and prevent the actual lettuce from being
-- used as a seed

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_lettuce", {
    description = S("Lettuce Seeds"),
    tiles = {"x_farming_stevia_seed.png"},
    inventory_image = "x_farming_stevia_seed.png",
    wield_image = "x_farming_stevia_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_lettuce")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:lettuce_1", param2 = 3})
    end
})

-- Override parts of the lettuce item so that it cannot be used as a seed
-- Farming Redo's inventory image is kept since it is fine
core.override_item("farming:lettuce", {
    groups = {compostability = 65, food_lettuce = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- Make the final two stages drop seeds and rebalance to account for the new
-- seed item
core.override_item("farming:lettuce_4", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_lettuce"}},
            {rarity = 1, items = {"farming:lettuce"}},
        }
    }
})

core.override_item("farming:lettuce_5", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_lettuce"}},
            {rarity = 2, items = {"farming:seed_lettuce"}},
            {rarity = 1, items = {"farming:lettuce"}},
            {rarity = 2, items = {"farming:lettuce"}},
        }
    }
})

-- Make sure that the 'sickles' mod knows what seed to take away from the player
farming.registered_plants["farming:lettuce"].seed = "farming:seed_lettuce"

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:lettuce_", 5, "farming:seed_lettuce"},
    })
end
