-- Overrides for the strawberry

-- Add the seed item and replace the textures with those from X Farming
-- In X Farming, the strawberry only has four stages while Farming Redo's
-- strawberry has eight, but we can stretch it out over eight stages

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Ethereal, which is the
-- actual mod that the strawberry comes from
core.register_node(":ethereal:seed_strawberry", {
    description = S("Strawberry Seeds"),
    tiles = {"x_farming_strawberry_seed.png"},
    inventory_image = "x_farming_strawberry_seed.png",
    wield_image = "x_farming_strawberry_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "ethereal:seed_strawberry")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "ethereal:strawberry_1", param2 = 3})
    end
})

-- Override parts of the strawberry item so that it cannot be used as a seed
core.override_item("ethereal:strawberry", {
    inventory_image = "x_farming_strawberry.png",
    groups = {compostability = 30, food_strawberry = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- Maps a growth stage to the texture it should use (indices start at 1 in Lua)
local texture_mapping = {1, 1, 1, 2, 2, 3, 3, 4}

-- Override the strawberry crop graphics
for i = 1, 8 do
    local x = tostring(i)
    local tex = tostring(texture_mapping[i])
    core.override_item("ethereal:strawberry_" .. x, {
        tiles = {"x_farming_strawberry_" .. tex .. ".png"},
    })
end

-- Make the final three stages drop seeds and rebalance to account for the new
-- seed items
core.override_item("ethereal:strawberry_6", {
    drop = {
        items = {
            {rarity = 1, items = {"ethereal:seed_strawberry"}},
        }
    }
})

core.override_item("ethereal:strawberry_7", {
    drop = {
        items = {
            {rarity = 1, items = {"ethereal:seed_strawberry"}},
            {rarity = 1, items = {"ethereal:strawberry"}},
        }
    }
})

core.override_item("ethereal:strawberry_8", {
    drop = {
        items = {
            {rarity = 1, items = {"ethereal:seed_strawberry"}},
            {rarity = 2, items = {"ethereal:seed_strawberry"}},
            {rarity = 1, items = {"ethereal:strawberry"}},
            {rarity = 2, items = {"ethereal:strawberry"}},
        }
    }
})

-- Make sure that the 'sickles' mod knows what seed to take away from the player
farming.registered_plants["ethereal:strawberry"].seed = "ethereal:seed_strawberry"

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"ethereal:strawberry_", 8, "ethereal:seed_strawberry"},
    })
end
