-- Overrides for the tomato

-- We only need to add the seed item and prevent the actual tomato from being
-- used as a seed

local S = core.get_translator(core.get_current_modname())

-- Make life easier by registering as if it is part of Farming Redo
core.register_node(":farming:seed_tomato", {
    description = S("Tomato Seeds"),
    tiles = {"farming_rye_seed.png^[transformFX"},
    inventory_image = "farming_rye_seed.png^[transformFX",
    wield_image = "farming_rye_seed.png^[transformFX",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "farming:seed_tomato")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "farming:tomato_1", param2 = 3})
    end
})

-- Override parts of the tomato item so that it cannot be used as a seed
-- Farming Redo's inventory image is kept since it is fine
core.override_item("farming:tomato", {
    groups = {compostability = 65, food_tomato = 1, flammable = 2}, -- rm seed
    on_place = function(itemstack, placer, pointed_thing)
        return nil
    end,
})

-- Make the final three stages drop seeds and rebalance to account for the new
-- seed item
core.override_item("farming:tomato_6", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_tomato"}},
        }
    }
})

core.override_item("farming:tomato_7", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_tomato"}},
            {rarity = 1, items = {"farming:tomato"}},
        }
    }
})

core.override_item("farming:tomato_8", {
    drop = {
        items = {
            {rarity = 1, items = {"farming:seed_tomato"}},
            {rarity = 2, items = {"farming:seed_tomato"}},
            {rarity = 1, items = {"farming:tomato"}},
            {rarity = 2, items = {"farming:tomato"}},
        }
    }
})
-- Make sure that the 'sickles' mod knows what seed to take away from the player
farming.registered_plants["farming:tomato"].seed = "farming:seed_tomato"

-- YAMS-TODO: modify this in the bonemeal mod directly instead of relying on
-- implementation details that makes this work regardless, or add an API that
-- allows overriding a crop entry
if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"farming:tomato_", 8, "farming:seed_tomato"},
    })
end
