-- Holds all loot tables and information
yams.loot = {}

yams.loot["dungeon"] = {}

-- Holds probability for each inventory slot within a chest to have something
-- YAMS-TODO: scale based on depth maybe
yams.loot["dungeon"].slot_chance = 0.25

-- Holds number of slots that each type of chest has
yams.loot["dungeon"].slots = 32

-- Every entry is a table with the following fields:
-- * name = name of the item (required)
-- * weight = the higher the number relative to the other entries, the more
-- likely the item gets picked (required)
-- * count = table with two integers, min and max, that specify the number of
-- items within the stack; if not specified, defaults to 1 for both values
-- * y = table with two integers, miny and maxy, that specify the minimum and
-- maximum depth required for this item to be picked; if not provided, there
-- is no restriction
yams.loot["dungeon"].items = {
    {name = "default:apple", weight = 50, count = {1, 4}},
    {name = "ebiomes:pear", weight = 50, count = {1, 4}},
    {name = "default:stick", weight = 50, count = {10, 30}},
    {name = "default:torch", weight = 50, count = {1, 8}},
    {name = "default:clay_lump", weight = 50, count = {1, 8}},
    {name = "default:flint", weight = 10, count = {1, 4}},
    {name = "tnt:gunpowder", weight = 10, count = {1, 4}},
    {name = "default:sapling", weight = 10, count = {1, 4}},
    {name = "flowers:mushroom_brown", weight = 10, count = {1, 4}},
    {name = "flowers:mushroom_red", weight = 10, count = {1, 4}},
    {name = "farming:wheat", weight = 50, count = {1, 8}},
    {name = "farming:cotton", weight = 50, count = {1, 16}},
    {name = "bonemeal:bone", weight = 20, count = {1, 4}},
    {name = "bweapons_bows_pack:arrow", weight = 30, count = {1, 16}},
    {name = "bweapons_bows_pack:bolt", weight = 10, count = {1, 16}},
    {name = "default:coal_lump", weight = 60, count = {1, 16}},
    {name = "default:copper_lump", weight = 40, count = {1, 8}},
    {name = "default:tin_lump", weight = 10, count = {1, 2}},
    {name = "default:iron_lump", weight = 20, count = {1, 8}},
    {name = "default:gold_lump", weight = 10, count = {1, 4}, y = {-31000, -128}},
    {name = "default:mese_crystal_fragment", weight = 10, count = {2, 16}, y = {-31000, -256}},
    {name = "default:mese_crystal", weight = 5, count = {1, 4}, y = {-31000, -256}},
    {name = "default:diamond", weight = 5, count = {1, 2}, y = {-31000, -512}},
    {name = "default:diamond", weight = 5, count = {1, 2}, y = {1024, 31000}},
    {name = "default:obsidian_shard", weight = 20, count = {1, 8}, y = {-31000, -256}},
    {name = "magic_materials:egerum_crystal", weight = 40, count = {1, 4}},
    {name = "magic_materials:februm_crystal", weight = 10, count = {1, 2}, y = {-31000, -64}},
    {name = "magic_materials:enchanted_page", weight = 20, count = {1, 4}},
    {name = "yams_materials:exp_orb_1", weight = 60, count = {1, 1}, y = {-128, 64}},
    {name = "yams_materials:exp_orb_2", weight = 60, count = {1, 1}, y = {-1024, -128}},
    {name = "yams_materials:exp_orb_3", weight = 60, count = {1, 1}, y = {-2048, -512}},
    {name = "yams_materials:fire_essence", weight = 20, count = {1, 1}},
    {name = "yams_materials:ice_essence", weight = 20, count = {1, 1}},
    {name = "yams_materials:wind_essence", weight = 20, count = {1, 1}},
    {name = "yams_materials:water_essence", weight = 20, count = {1, 1}},
    {name = "yams_materials:earth_essence", weight = 20, count = {1, 1}},
    {name = "nether:book_of_portals", weight = 150, count = {1, 1}, y = {-31000, -256}},
    {name = "nyancat:nyancat", weight = 1, count = {1, 1}},
}

yams.loot["lootchests_default:ocean_chest"] = {}
yams.loot["lootchests_default:ocean_chest"].slot_chance = 0.125
yams.loot["lootchests_default:ocean_chest"].slots = 32

yams.loot["lootchests_default:ocean_chest"].items = {
    {name = "default:stone", weight = 100, count = {5, 20}},
    {name = "default:stonebrick", weight = 100, count = {5, 20}},
    {name = "default:brick", weight = 100, count = {5, 20}},
    {name = "default:cobble", weight = 100, count = {5, 20}},
    {name = "default:wood", weight = 100, count = {5, 50}},
    {name = "default:fence_wood", weight = 50, count = {1, 8}},
    {name = "default:ladder", weight = 50, count = {1, 16}},
    {name = "default:tree", weight = 100, count = {5, 20}},
    {name = "default:jungletree", weight = 100, count = {5, 20}},
    {name = "default:glass", weight = 100, count = {5, 20}},
    {name = "default:clay", weight = 100, count = {5, 20}},
    {name = "default:sand", weight = 100, count = {5, 20}},
    {name = "default:sandstone", weight = 100, count = {5, 20}},
    {name = "default:cactus", weight = 20, count = {3, 6}},
    {name = "default:coal_lump", weight = 50, count = {1, 8}},
    {name = "pigiron:charcoal_lump", weight = 50, count = {1, 8}},
    {name = "default:coalblock", weight = 20, count = {1, 2}},
    {name = "default:bronze_ingot", weight = 10, count = {1, 4}},
    {name = "default:steel_ingot", weight = 5, count = {1, 4}},
    {name = "default:gold_ingot", weight = 1, count = {1, 1}},
    {name = "wool:white", weight = 50, count = {1, 8}},
    {name = "wool:red", weight = 20, count = {1, 8}},
    {name = "wool:pink", weight = 20, count = {1, 8}},
    {name = "wool:green", weight = 20, count = {1, 8}},
    {name = "wool:blue", weight = 20, count = {1, 8}},
    {name = "wool:yellow", weight = 20, count = {1, 8}},
    {name = "wool:brown", weight = 20, count = {1, 8}},
    {name = "default:paper", weight = 50, count = {4, 16}},
    {name = "yams_materials:exp_orb_1", weight = 20, count = {1, 1}},
    {name = "yams_materials:water_essence", weight = 100, count = {1, 1}},
}

yams.loot["lootchests_default:barrel"] = {}
yams.loot["lootchests_default:barrel"].slot_chance = 0.25
yams.loot["lootchests_default:barrel"].slots = 24

yams.loot["lootchests_default:barrel"].items = {
    {name = "default:apple", weight = 100, count = {1, 4}},
    {name = "ebiomes:olives", weight = 100, count = {1, 4}},
    {name = "ebiomes:pear", weight = 100, count = {1, 4}},
    {name = "ebiomes:quince", weight = 100, count = {1, 4}},
    {name = "default:blueberries", weight = 100, count = {1, 4}},
    {name = "ebiomes:gooseberries", weight = 100, count = {1, 4}},
    {name = "ebiomes:cranberries", weight = 100, count = {1, 4}},
    {name = "ebiomes:cowberries", weight = 100, count = {1, 4}},
    {name = "farming:carrot", weight = 100, count = {1, 4}},
    {name = "farming:lettuce", weight = 100, count = {1, 4}},
    {name = "farming:tomato", weight = 100, count = {1, 4}},
    {name = "farming:chili_pepper", weight = 100, count = {1, 4}},
    {name = "farming:coffee_beans", weight = 100, count = {1, 4}},
    {name = "farming:cocoa_beans", weight = 100, count = {1, 4}},
    {name = "farming:wheat", weight = 100, count = {1, 4}},
    {name = "farming:rice", weight = 100, count = {1, 4}},
    {name = "ethereal:strawberry", weight = 100, count = {1, 4}},
    {name = "yams_farming:potato", weight = 100, count = {1, 4}},
}

yams.loot["tsm_pyramids"] = {}
-- While there are often many chests per pyramid, they can be rather difficult
-- to loot due to the hazards inside, so 15% chance per slot works well
yams.loot["tsm_pyramids"].slot_chance = 0.15
yams.loot["tsm_pyramids"].slots = 32

yams.loot["tsm_pyramids"].items = {
    {name = "wool:white", weight = 20, count = {1, 8}},
    {name = "wool:red", weight = 10, count = {1, 8}},
    {name = "wool:yellow", weight = 10, count = {1, 8}},
    {name = "flowers:rose", weight = 20, count = {1, 1}},
    {name = "default:blueberries", weight = 40, count = {1, 4}},
    {name = "ethereal:strawberry", weight = 40, count = {1, 4}},
    {name = "farming:wheat", weight = 40, count = {1, 4}},
    {name = "farming:cotton", weight = 50, count = {1, 8}},
    {name = "farming:mint_leaf", weight = 20, count = {1, 4}},
    {name = "farming:coffee_beans", weight = 20, count = {1, 4}},
    {name = "farming:melon_slice", weight = 20, count = {1, 4}},
    {name = "farming:rice", weight = 20, count = {1, 4}},
    {name = "farming:sugar", weight = 20, count = {1, 4}},
    {name = "mobs:meat_raw", weight = 50, count = {1, 4}},
    {name = "bonemeal:bone", weight = 75, count = {1, 4}},
    {name = "bweapons_bows_pack:arrow", weight = 50, count = {1, 16}},
    {name = "default:torch", weight = 50, count = {1, 12}},
    {name = "default:papyrus", weight = 50, count = {4, 16}},
    {name = "default:coal_lump", weight = 75, count = {2, 8}},
    {name = "default:coalblock", weight = 20, count = {1, 1}},
    {name = "default:bronze_ingot", weight = 20, count = {1, 4}},
    {name = "default:steel_ingot", weight = 15, count = {1, 4}},
    {name = "default:gold_ingot", weight = 10, count = {1, 2}},
    {name = "default:mese_crystal_fragment", weight = 10, count = {2, 8}},
    {name = "default:mese_crystal", weight = 5, count = {1, 4}},
    {name = "default:diamond", weight = 2, count = {1, 2}},
    {name = "default:obsidian_shard", weight = 5, count = {1, 4}},
    {name = "moreores:mithril_ingot", weight = 1, count = {1, 2}},
    {name = "magic_materials:egerum_crystal", weight = 75, count = {1, 4}},
    {name = "magic_materials:februm_crystal", weight = 10, count = {1, 4}},
    {name = "magic_materials:enchanted_page", weight = 20, count = {1, 4}},
    {name = "yams_materials:fire_essence", weight = 5, count = {1, 1}},
    {name = "yams_materials:earth_essence", weight = 5, count = {1, 1}},
    {name = "yams_materials:exp_orb_1", weight = 50, count = {1, 1}},
    {name = "yams_materials:exp_orb_2", weight = 10, count = {1, 1}},
    {name = "nyancat:nyancat", weight = 1, count = {1, 1}},
}

yams.loot["tsm_railcorridors"] = {}
yams.loot["tsm_railcorridors"].slot_chance = 0.25
yams.loot["tsm_railcorridors"].slots = 32

yams.loot["tsm_railcorridors"].items = {
    {name = "default:stick", weight = 20, count = {10, 40}},
    {name = "default:torch", weight = 20, count = {1, 16}},
    {name = "default:wood", weight = 20, count = {2, 8}},
    {name = "default:fence_wood", weight = 20, count = {1, 4}},
    {name = "default:ladder", weight = 20, count = {1, 4}},
    {name = "carts:rail", weight = 20, count = {1, 32}},
    {name = "farming:bread", weight = 20, count = {1, 4}},
    {name = "mobs:meat", weight = 20, count = {1, 4}},
    {name = "default:coal_lump", weight = 40, count = {1, 16}},
    {name = "default:coalblock", weight = 20, count = {1, 2}},
    {name = "default:copper_lump", weight = 40, count = {1, 8}},
    {name = "default:tin_lump", weight = 10, count = {1, 4}},
    {name = "default:iron_lump", weight = 30, count = {1, 4}},
    {name = "default:gold_lump", weight = 5, count = {1, 2}, y = {-31000, -128}},
    {name = "default:mese_crystal_fragment", weight = 10, count = {2, 8}, y = {-31000, -256}},
    {name = "default:mese_crystal", weight = 5, count = {1, 4}, y = {-31000, -256}},
    {name = "default:diamond", weight = 2, count = {1, 2}, y = {-31000, -512}},
    {name = "magic_materials:egerum_crystal", weight = 40, count = {1, 4}},
    {name = "magic_materials:februm_crystal", weight = 10, count = {1, 2}, y = {-31000, -64}},
    {name = "moreores:mithril_lump", weight = 1, count = {1, 2}, y = {-31000, -1024}},
}
