local S = core.get_translator("yams_materials")

core.register_craftitem("yams_materials:fire_essence", {
    description = S("Fire Essence"),
    inventory_image = "alchemy_fire_essence.png",
})

core.register_craftitem("yams_materials:ice_essence", {
    description = S("Ice Essence"),
    inventory_image = "yams_ice_essence.png",
})

core.register_craftitem("yams_materials:water_essence", {
    description = S("Water Essence"),
    inventory_image = "alchemy_water_essence.png",
})

core.register_craftitem("yams_materials:wind_essence", {
    description = S("Wind Essence"),
    inventory_image = "alchemy_air_essence.png",
})

core.register_craftitem("yams_materials:earth_essence", {
    description = S("Earth Essence"),
    inventory_image = "alchemy_earth_essence.png",
})

-- EXP orbs
exp_amounts = {200, 1000, 2500, 5000, 10000, 20000}

for i = 1, #exp_amounts do
    local name = "yams_materials:exp_orb_" .. tostring(i)
    local desc = S("Orb of Insight [Grade @1]", i)
    local tt = S("Gives @1 EXP when used", exp_amounts[i]) .. "\n" ..
               S("Not affected by EXP gain modifiers")
    core.register_craftitem(name, {
        description = desc,
        -- YAMS-TODO: Temporary 32px image; also there should be a different
        -- image for each orb grade
        inventory_image = "yams_exp_orb.png",
        _tt_help = tt,
        on_use = function(itemstack, user, pointed_thing)
            yams.add_exp(user, exp_amounts[i], "exp orb")
            itemstack:take_item()
            return itemstack
        end,
    })
end
