local S = core.get_translator(core.get_current_modname())

-- Alternate cookie image and recipe; the latter is inspired by X Farming
-- Let it restore player's mana and give a brief burst of speed as well
core.override_item("farming:cookie", {
    inventory_image = "x_farming_cookie.png",
    _yams_mana_restore = 0.25,
    _yams_food_effects = {
        {name = "yams_effects:speed_up_medium", duration = 5},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Speed Up M"),
            desc = S("Increase movement speed by 25% for five seconds.")
        }
    }
})

core.clear_craft({output = "farming:cookie"})

core.register_craft({
    type = "shapeless",
    output = "farming:cookie 8",
    recipe = {"group:food_flour", "group:food_cocoa", "group:food_sugar",
              "group:food_milk"},
    replacements = {
        {"mobs:bucket_milk", "bucket:bucket_empty"},
        {"mobs:wooden_bucket_milk", "wooden_bucket:bucket_wood_empty"},
    }
})

-- Alternate donut recipes
-- Remove the regular donut; the strawberry and chocolate donuts will be made
-- directly so this isn't needed anymore
core.unregister_item("farming:donut")
core.clear_craft({output = "farming:donut"})

-- Remove the apple donut; the strawberry donut will take its place
core.unregister_item("farming:donut_apple")
core.clear_craft({output = "farming:donut_apple"})

-- Rework the chocolate donut
core.clear_craft({output = "farming:donut_chocolate"})

core.override_item("farming:donut_chocolate", {
    inventory_image = "x_farming_donut_chocolate.png",
    _yams_mana_restore = 0.75,
    _yams_food_effects = {
        {name = "yams_effects:morale", duration = 60},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Morale"),
            -- YAMS-TODO: this is not ideal for translators at all
            desc = S("For 60 seconds, combat damage taken is capped") .. "\n" ..
                   S("at 25% of your maximum health, rounded up.") .. "\n" ..
                   S("(Plague does not affect this damage cap.)")
        }
    }
})

core.register_craft({
    type = "shaped",
    output = "farming:donut_chocolate 2",
    recipe = {{"", "group:food_cocoa", ""},
              {"group:food_flour", "group:food_sugar", "group:food_flour"},
              {"", "group:food_milk", ""}},
    replacements = {
        {"mobs:bucket_milk", "bucket:bucket_empty"},
        {"mobs:wooden_bucket_milk", "wooden_bucket:bucket_wood_empty"},
    }
})

-- Add the strawberry donut
core.register_craftitem("yams_farming:donut_strawberry", {
    description = S("Strawberry Donut"),
    inventory_image = "x_farming_donut.png",
    on_use = core.item_eat(6),
    _yams_mana_restore = 0.75,
    _yams_food_effects = {
        {name = "yams_effects:attack_up_large", duration = 15},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Attack Up L"),
            desc = S("Increase damage dealt by 50% for 15 seconds.")
        }
    }
})

core.register_craft({
    type = "shaped",
    output = "yams_farming:donut_strawberry 2",
    recipe = {{"", "group:food_strawberry", ""},
              {"group:food_flour", "group:food_sugar", "group:food_flour"},
              {"", "group:food_milk", ""}},
    replacements = {
        {"mobs:bucket_milk", "bucket:bucket_empty"},
        {"mobs:wooden_bucket_milk", "wooden_bucket:bucket_wood_empty"},
    }
})

-- Fries
core.register_craftitem("yams_farming:fries", {
    description = S("French Fries"),
    inventory_image = "x_farming_fries.png",
    on_use = core.item_eat(6),
    _yams_food_effects = {
        {name = "yams_effects:well_fed_medium", duration = 180},
        {name = "yams_effects:attack_up_medium", duration = 60},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Well Fed M"),
            desc = S("Gain +25% EXP from most sources for three minutes.")
        },
        {
            name = S("Attack Up M"),
            desc = S("Increase damage dealt by 25% for 60 seconds.")
        }
    }
})

-- Straight from X Farming
core.register_craft({
    type = "shaped",
    output = "yams_farming:fries",
    recipe = {{"", "", "farming:salt"},
              {"", "yams_farming:baked_potato", ""},
              {"default:paper", "", ""}},
})

-- Olive oil
core.register_craftitem("yams_farming:olive_oil", {
    description = S("Olive Oil"),
    inventory_image = "ethereal_olive_oil.png",
    groups = {food_oil = 1, food_olive_oil = 1, vessel = 1},
})

core.register_craft({
    type = "shaped",
    output = "yams_farming:olive_oil",
    recipe = {{"group:food_olives", "vessels:glass_bottle"}}
})

-- Override the salad recipe
core.clear_craft({output = "farming:salad"})

core.register_craft({
    type = "shaped",
    output = "farming:salad",
    recipe = {{"", "yams_farming:olive_oil", ""},
              {"group:food_lettuce", "group:food_tomato", "group:food_carrot"},
              {"", "group:food_bowl", ""}}
})

-- Add the chocolate bar
core.register_craftitem("yams_farming:chocolate", {
    description = S("Chocolate Bar"),
    inventory_image = "x_farming_chocolate.png",
    on_use = core.item_eat(4),
    _yams_mana_restore = 0.5,
    _yams_food_effects = {
        {name = "yams_effects:high_jump_small", duration = 60},
    },
    _yams_tt_effect_descs = {
        {
            name = S("High Jump S"),
            desc = S("Increase jump strength by 40% for 60 seconds.") .. "\n" ..
                   S("This allows for jumps that are two blocks high.")
        }
    }
})

core.register_craft({
    type = "shaped",
    output = "yams_farming:chocolate",
    recipe = {{"", "", "group:food_cocoa"},
              {"", "group:food_cocoa", ""},
              {"default:paper", "", ""}}
})

-- This allows string to be used for making rope segments
core.override_item("farming:string", {
    groups = {flammable = 2, thread = 1}
})

-- Add a recipe for wool that use string
core.register_craft({
    type = "shaped",
    output = "wool:white",
    recipe = {{"farming:string", "farming:string"},
              {"farming:string", "farming:string"}}
})
