-- Overrides for the potato

-- Since Farming Redo's potato has four stages while X Farming's potato has
-- eight stages, it is probably easier to just delete all the related items
-- and re-register them; I also find X Farming's potato implementation much
-- better in general so let's just copy it

local S = core.get_translator(core.get_current_modname())

local items_to_remove = {
    "farming:potato",
    "farming:potato_1",
    "farming:potato_2",
    "farming:potato_3",
    "farming:potato_4",
    "farming:baked_potato"
}

for _, itemname in ipairs(items_to_remove) do
    if core.registered_items[itemname] then
        core.unregister_item(itemname)
    end
end

core.clear_craft({output = "farming:baked_potato"})

farming.registered_plants["farming:potato"] = nil

core.register_node("yams_farming:seed_potato", {
    description = S("Potato Seeds"),
    tiles = {"x_farming_potato_seed.png"},
    inventory_image = "x_farming_potato_seed.png",
    wield_image = "x_farming_potato_seed.png",
    drawtype = "signlike",
    groups = {compostability = 30, seed = 1, snappy = 3, attached_node = 1,
              flammable = 2, growing = 1},
    paramtype = "light",
    paramtype2 = "wallmounted",
    walkable = false,
    sunlight_propagates = true,
    selection_box = farming.select,
    on_place = function(itemstack, placer, pointed_thing)
        return farming.place_seed(itemstack, placer, pointed_thing,
                                  "yams_farming:seed_potato")
    end,
    on_timer = function(pos, elapsed)
        core.set_node(pos, {name = "yams_farming:potato_1", param2 = 3})
    end
})

core.register_craftitem("yams_farming:potato", {
    description = S("Potato"),
    inventory_image = "x_farming_potato.png",
    groups = {compostability = 65, food_potato = 1, flammable = 2},
    on_use = core.item_eat(2)
})

core.register_craftitem("yams_farming:baked_potato", {
    description = S("Baked Potato"),
    inventory_image = "x_farming_potato_baked.png",
    on_use = core.item_eat(6),
    _yams_food_effects = {
        {name = "yams_effects:well_fed_small", duration = 180},
    },
    _yams_tt_effect_descs = {
        {
            name = S("Well Fed S"),
            desc = S("Gain +10% EXP from most sources for three minutes.")
        },
    }
})

core.register_craft({
    type = "cooking",
    cooktime = 3,
    output = "yams_farming:baked_potato",
    recipe = "group:food_potato"
})

core.register_craftitem("yams_farming:poisonous_potato", {
    description = S("Poisonous Potato"),
    inventory_image = "x_farming_potato_poisonous.png",
    on_use = core.item_eat(-6)
})

-- Growth stages
local def = {
    description = S("Potato Crop"),
    drawtype = "plantlike",
    tiles = {"x_farming_potato_1.png"},
    paramtype = "light",
    paramtype2 = "meshoptions",
    place_param2 = 3,
    sunlight_propagates = true,
    waving = 1,
    walkable = false,
    buildable_to = true,
    drop = "",
    selection_box = farming.select,
    groups = {snappy = 3, flammable = 2, plant = 1, attached_node = 1,
              not_in_creative_inventory = 1, growing = 1},
    is_ground_content = false,
    sounds = farming.node_sound_leaves_defaults()
}

core.register_node("yams_farming:potato_1", table.copy(def))

for i=2, 5 do
    local i = tostring(i)
    def.tiles = {"x_farming_potato_" .. i  .. ".png"}
    core.register_node("yams_farming:potato_" .. i, table.copy(def))
end

-- YAMS-TODO: stage 6 does not look different from stages 4 and 5, so there is
-- no visual indication that it will drop a seed when compared to the earlier
-- stages; at some point there needs to be a distinct texture for each stage
-- to fix this
def.tiles = {"x_farming_potato_6.png"}
def.drop = {
    items = {
        {rarity = 1, items = {"yams_farming:seed_potato"}},
    }
}
core.register_node("yams_farming:potato_6", table.copy(def))

def.tiles = {"x_farming_potato_7.png"}
def.drop = {
    items = {
        {rarity = 1, items = {"yams_farming:seed_potato"}},
        {rarity = 1, items = {"yams_farming:potato"}},
        {rarity = 20, items = {"yams_farming:poisonous_potato"}},
    }
}
core.register_node("yams_farming:potato_7", table.copy(def))

def.tiles = {"x_farming_potato_8.png"}
def.groups.growing = nil
def.selection_box = farming.select_final
def.drop = {
    items = {
        {rarity = 1, items = {"yams_farming:seed_potato"}},
        {rarity = 2, items = {"yams_farming:seed_potato"}},
        {rarity = 1, items = {"yams_farming:potato"}},
        {rarity = 2, items = {"yams_farming:potato"}},
        {rarity = 20, items = {"yams_farming:poisonous_potato"}},
    }
}
core.register_node("yams_farming:potato_8", table.copy(def))

-- This actually doesn't really do anything in Farming Redo; it's a
-- core.after() call in Farming Redo that assigns all the timer callbacks
-- However, the 'sickles' mod does read this data so it is best to set it
-- properly
farming.registered_plants["yams_farming:potato"] = {
    crop = "yams_farming:potato",
    seed = "yams_farming:seed_potato",
    minlight = farming.min_light,
    maxlight = farming.max_light,
    steps = 8
}

core.register_decoration({
    deco_type = "simple",
    place_on = {
        "default:dirt_with_grass", "mcl_core:dirt_with_grass",
        "ebiomes:dirt_with_grass_warm", "ebiomes:dirt_with_grass_cold",
        "ebiomes:dirt_with_grass_med", "ebiomes:dirt_with_grass_steppe",
        "ebiomes:dirt_with_grass_steppe_warm"
    },
    sidelen = 16,
    noise_params = {
        offset = 0,
        scale = farming.potato,
        spread = {x = 100, y = 100, z = 100},
        seed = 465,
        octaves = 3,
        persist = 0.6
    },
    -- Notes on the reasoning:
    -- * In yams, the potato can grow in both temperate and winter environments
    -- * In real-life, Andean potatoes can grow in elevations up to 4200 meters,
    -- so incorporate that into yams
    -- * We also spawn potatoes in colder biomes to give players a better chance
    -- of survival if they spawn there, but at a lower rate (see below)
    -- * Sweet potatoes are excluded, so potatoes will not spawn in tropical
    -- environments
    -- * Many plants in real-life do not grow well in full shade, but we
    -- disregard that detail in yams since the average player will not notice,
    -- and this simplification benefits the gameplay; thus, potatoes will also
    -- spawn in many types of forests
    biomes = {
        "grassland", "grassland_coldish", "grassland_warm", "deciduous_forest",
        "deciduous_forest_woody", "deciduous_forest_fruity",
        "deciduous_forest_cold", "deciduous_forest_warm", "mediterranean",
        "steppe", "warm_steppe"
    },
    y_min = 1,
    y_max = 64,
    decoration = "yams_farming:potato_7"
})

-- This is for colder biomes; potatoes will spawn much less frequently in them
-- and they'll be at an earlier stage
core.register_decoration({
    deco_type = "simple",
    place_on = {
        "default:dirt_with_snow", "ebiomes:dirt_with_grass_steppe_cold"
    },
    sidelen = 16,
    noise_params = {
        offset = 0,
        scale = 0.001,
        spread = {x = 100, y = 100, z = 100},
        seed = 9936,
        octaves = 3,
        persist = 0.6
    },
    biomes = {
        "snowy_grassland", "taiga", "cold_steppe"
    },
    y_min = 1,
    y_max = 64,
    decoration = "yams_farming:potato_6"
})

if core.get_modpath("bonemeal") then
    bonemeal:add_crop({
        {"yams_farming:potato_", 8, "yams_farming:seed_potato"},
    })
end
