-- Default stat factors for all stellar tools
-- Stardust has magical properties, so intelligence is a secondary stat
local stellar_sf = {
    primary = "str",
    secondary = "int",
    str = 0.7,
    dex = 0.0,
    int = 0.3
}
-- Elemental damage definition for all melee weapons
local stellar_elements = {yams_physical = 100, yams_light = 100}

minetest.register_tool(":stardust:pick_stellar", {
    description = "Stellar Pickaxe",
    inventory_image = "stardust_pick_stellar.png",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 3,
        groupcaps={
			cracky = {times={[1]=1.60, [2]=0.80, [3]=0.40}, uses=20, maxlevel=3},
		},
        damage_groups = {fleshy=5},
        punch_attack_uses = 180,
    },
    sound = {breaks = "default_tool_breaks"},
	groups = {pickaxe = 1},
    _yams_knockback = 3,
    _yams_anvil_difficulty = 2.0,
    _yams_stat_factors = stellar_sf,
    _yams_elements = stellar_elements
})

minetest.register_tool(":stardust:axe_stellar", {
    description = "Stellar Axe",
    inventory_image = "stardust_axe_stellar.png",
    tool_capabilities = {
        full_punch_interval = 0.8,
        max_drop_level = 1,
        groupcaps={
			choppy = {times={[1]=2.00, [2]=0.80, [3]=0.40}, uses=20, maxlevel=3},
		},
        damage_groups = {fleshy=7},
        punch_attack_uses = 540,
    },
    sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1},
    _yams_knockback = 8.5,
    _yams_anvil_difficulty = 2.0,
    _yams_stat_factors = stellar_sf,
    _yams_elements = stellar_elements
})

minetest.register_tool(":stardust:shovel_stellar", {
    description = "Stellar Shovel",
    inventory_image = "stardust_shovel_stellar.png",
    tool_capabilities = {
        full_punch_interval = 1.0,
        max_drop_level = 1,
        groupcaps={
			crumbly = {times={[1]=1.00, [2]=0.45, [3]=0.25}, uses=20, maxlevel=3},
		},
        damage_groups = {fleshy=4},
        punch_attack_uses = 180,
    },
    sound = {breaks = "default_tool_breaks"},
	groups = {shovel = 1},
    _yams_knockback = 4,
    _yams_anvil_difficulty = 2.0,
    _yams_stat_factors = stellar_sf,
    _yams_elements = stellar_elements
})

minetest.register_tool(":stardust:sword_stellar", {
    description = "Stellar Sword",
    inventory_image = "stardust_sword_stellar.png",
    tool_capabilities = {
        full_punch_interval = 0.6,
        max_drop_level = 1,
        groupcaps={
			snappy = {times={[1]=1.80, [2]=0.80, [3]=0.25}, uses=30, maxlevel=3},
		},
        damage_groups = {fleshy=8},
        punch_attack_uses = 810,
    },
    sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},
    _yams_knockback = 7,
    _yams_anvil_difficulty = 2.0,
    _yams_stat_factors = stellar_sf,
    _yams_elements = stellar_elements
})

local handle_material = "default:mese_crystal_fragment"
local blade_material = "stardust:stellar_ingot"

minetest.register_craft({
    output = "stardust:pick_stellar",
    recipe = {
        {blade_material, blade_material, blade_material},
        {"" ,handle_material, ""},
        {"" ,handle_material, ""},
    }
})

minetest.register_craft({
    output = "stardust:axe_stellar",
    recipe = {
        {blade_material, blade_material, ""},
        {blade_material ,handle_material, ""},
        {"" ,handle_material, ""},
    }
})

minetest.register_craft({
    output = "stardust:shovel_stellar",
    recipe = {
        {blade_material},
        {handle_material},
        {handle_material},
    }
})

minetest.register_craft({
    output = "stardust:sword_stellar",
    recipe = {
        {blade_material},
        {blade_material},
        {handle_material},
    }
})

if minetest.get_modpath("terumet") then
    terumet.register_repairable_item("stardust:pick_stellar", 225*3)
    terumet.register_repairable_item("stardust:axe_stellar", 225*3)
    terumet.register_repairable_item("stardust:shovel_stellar", 225)
    terumet.register_repairable_item("stardust:sword_stellar", 225*2)
end

if minetest.get_modpath("lucky_block") then
    lucky_block:add_blocks(
        {
            {"dro", "stardust:pick_stellar", 1},
            {"dro", "stardust:axe_stellar", 1},
            {"dro", "stardust:shovel_stellar", 1},
            {"dro", "stardust:sword_stellar", 1},
        }
    )
end
