local possible_mobs = {"yams_mobs:mummy", "mobs_skeletons:skeleton_archer"}

function spawn_pyramid_mob(pos)
    local r = math.random(1, #possible_mobs)
    local m = mobs:add_mob(pos, {name = possible_mobs[r]})
    if m then
        m.lifetimer = 99999  -- So that it never despawns
    end
end

core.override_item("tsm_pyramids:yams_mob_spot", {
    on_timer = function(pos, elapsed)
        -- Spawn the mob and remove the node once a player gets close enough
        local players = core.get_connected_players()
        for _, player in pairs(players) do
            local player_pos = player:get_pos()
            local dist = vector.distance(pos, player_pos)

            if dist < 24 then
                core.remove_node(pos)

                -- Some mob spots have a param2 of 10, which means that they
                -- were generated in a pyramid with a stacked layout, but that
                -- fact will remain unused for now; it was meant to signal that
                -- no traps are possible so mob spawn rates should be adjusted
                -- accordingly
                if math.random(1, 100) <= 5 then
                    pos.y = pos.y + 2  -- So that mobs do not get stuck
                    spawn_pyramid_mob(pos)
                end

                return false
            end
        end

        return true  -- Repeats the timer
    end
})
