-- block_chat_messages.lua

local blocked_players = {}

minetest.register_chatcommand("block", {
    params = "<joueur>",
    description = "Bloquer les messages du joueur spécifié",
    func = function(name, param)
        if not param or param == "" then
            return false, "Veuillez spécifier un joueur à bloquer."
        end

        if not blocked_players[name] then
            blocked_players[name] = {}
        end

        blocked_players[name][param] = true
        return true, "Le joueur " .. param .. " a été bloqué."
    end,
})

minetest.register_chatcommand("unblock", {
    params = "<joueur>",
    description = "Débloquer les messages du joueur spécifié",
    func = function(name, param)
        if not param or param == "" then
            return false, "Veuillez spécifier un joueur à débloquer."
        end

        if not blocked_players[name] then
            return false, "Aucun joueur n'est bloqué."
        end

        if not blocked_players[name][param] then
            return false, "Le joueur " .. param .. " n'est pas bloqué."
        end

        blocked_players[name][param] = nil
        return true, "Le joueur " .. param .. " a été débloqué."
    end,
})

local function filter_blocked_messages(name, message)
    local sender = message:match("^<(.-)>")
    if not sender then
        return false
    end

    if blocked_players[name] and blocked_players[name][sender] then
        return true
    end

    return false
end

minetest.register_on_chat_message(function(name, message)
    local blocked_message = false
    for _, player in ipairs(minetest.get_connected_players()) do
        local player_name = player:get_player_name()
        if filter_blocked_messages(player_name, message) then
            blocked_message = true
            -- minetest.chat_send_player(player_name, "*** Message bloqué de " .. name)
        else
            minetest.chat_send_player(player_name, message)
        end
    end

    if blocked_message then
        return true
    end
end)