# Block / Unblock Mod pour minetest

Le mod Block / Unblock permet aux joueurs de bloquer et débloquer les messages des autres joueurs dans le chat de minetest. Les joueurs peuvent utiliser les commandes `/block` et `/unblock` pour gérer les messages qu'ils voient dans le chat.

## Fonctionnalités

- Bloquer les messages d'un joueur spécifique avec la commande `/block <joueur>`.
- Débloquer les messages d'un joueur spécifique avec la commande `/unblock <joueur>`.

## Installation

1. Téléchargez le mod en cliquant sur "Download ZIP" ou en clonant le dépôt.
2. Extrayez le contenu de l'archive ZIP (si nécessaire) et renommez le dossier extrait en `block_unblock_chat`.
3. Copiez le dossier `block_unblock_chat` dans le répertoire `mods` de votre installation Minetest :
   - Windows: `C:\Users\<votre_nom_d'utilisateur>\AppData\Roaming\Minetest\mods`
   - macOS: `~/Library/Application Support/minetest/mods`
   - Linux: `~/.minetest/mods`
4. Lancez Minetest et activez le mod dans le menu "Configurer" pour le monde de jeu dans lequel vous souhaitez utiliser le mod.

## Utilisation

### Bloquer un joueur

Pour bloquer les messages d'un joueur, utilisez la commande `/block <joueur>` dans le chat, où `<joueur>` est le nom du joueur dont vous souhaitez bloquer les messages. Par exemple, pour bloquer les messages du joueur "exemple", saisissez :

`/block exemple`


### Débloquer un joueur

Pour débloquer les messages d'un joueur, utilisez la commande `/unblock <joueur>` dans le chat, où `<joueur>` est le nom du joueur dont vous souhaitez débloquer les messages. Par exemple, pour débloquer les messages du joueur "exemple", saisissez :

`/unblock exemple`


## Licence

Ce mod est distribué sous les termes de la licence MIT. Voir le fichier `LICENSE` pour plus d'informations.