-- block_chat_messages.lua

local S = minetest.get_translator("block_chat_messages")
local blocked_players = {}

minetest.register_chatcommand("block", {
    params = S("<player>"),
    description = S("Block messages from the specified player"),
    func = function(name, param)
        if not param or param == "" then
            return false, S("Please specify a player to block.")
        end

        if not blocked_players[name] then
            blocked_players[name] = {}
        end

        blocked_players[name][param] = true
        return true, S("Player @1 has been blocked.", param)
    end,
})

minetest.register_chatcommand("unblock", {
    params = S("<player>"),
    description = S("Unblock messages from the specified player"),
    func = function(name, param)
        if not param or param == "" then
            return false, S("Please specify a player to unblock.")
        end

        if not blocked_players[name] then
            return false, S("No players are blocked.")
        end

        if not blocked_players[name][param] then
            return false, S("Player @1 is not blocked.", param)
        end

        blocked_players[name][param] = nil
        return true, S("Player @1 has been unblocked.", param)
    end,
})

local function filter_blocked_messages(name, message)
    local sender = message:match("^<(.-)>")
    if not sender then
        return false
    end

    if blocked_players[name] and blocked_players[name][sender] then
        return true
    end

    return false
end

minetest.unregister_chatcommand("chat")

minetest.register_on_chat_message(function(name, message)
    if not minetest.check_player_privs(name, {shout = true}) then
        -- minetest.chat_send_player(name, S("You don't have the shout privilege to send messages."))
        return true
    end

    local blocked_message = false
    for _, player in ipairs(minetest.get_connected_players()) do
        local player_name = player:get_player_name()
        if filter_blocked_messages(player_name, message) then
            blocked_message = true
            -- minetest.chat_send_player(player_name, S("*** Blocked message from @1", name))
        else
            minetest.chat_send_player(player_name, message)
        end
    end

    if blocked_message then
        return true
    end
end)
