# Modpack Tech Age [techage]

This modpack covers all necessary and useful mods to be able to use techage.
All mods have the own README.txt. For further information please consult these files.

This modpack includes:
- techage: The main mod
- ta4_jetpack: A Jetpack for techage with hydrogen as fuel and TA4 recipe
- ta4_paraglider: A Paraglider for techage with TA4 recipe
- ta4_addons: A Touchscreen like the TA4 display, but with additional commands and features
- autobahn: Street blocks and slopes with stripes for faster traveling (the only need of bitumen from techage)
- compost: The garden soil is needed for the TA4 LED Grow Light based flower bed
- signs_bot: For many automation tasks in TA3/TA4 like farming, mining, and item transportation
- hyperloop: Used as passenger transportation system in TA4
- techpack_stairway: Ladders, stairways, and bridges for your machines
- minecart: Techage transportation system for oil and other items
- towercrane: Simplifies the building of large techage plants
- basic_materials: Needed items for many recipes
- stamina: The "hunger" mod from "minetest-mods"
- doc: Ingame documentation mod, used for minecart and signs_bot
- unified_inventory: Player's inventory with crafting guide, bags, and more.
- tubelib2: Necessary library
- networks: Necessary library
- safer_lua: Necessary library
- lcdlib: Necessary library
- datastorage: Necessary library


### Techage Manual

All techage manuals (EN/DE) are available ingame (craft the 'TA Construction Board')
or use the manual on [GitHub](https://github.com/joe7575/techage/wiki).


### Licenses

All mods have their own licenses. See the license files in the subfoldes.


### Further Dependencies  

Required: Minetest Game

ta4_jetpack requires the modpack 3d_armor. 3d_armor is itself a modpack and can't be integrated into the techage modpack.


### History


#### 2022-01-04

Updated Mods:
- techage (bugfixes)


#### 2022-01-03

Updated Mods:
- techage (see readme)
- hyperloop (see readme)
- minecart (bugfix)
- unified_inventory (see readme)
- ta4_addons (see readme)


#### 2021-10-30

Updated Mods:
- techage (see readme)
- signs_bot (see readme)
- minecart (bugfix)
- lcdlib (improvement)


#### 2021-09-18

Updated Mods:
- techage (see readme)
- signs_bot (see readme)
- networks (see readme)
- ta4_addons (add matrix screen)


#### 2021-09-04

Updated Mods:
- minecart (bugfix)


#### 2021-09-03

Updated Mods:
- techage (bugfixes)
- minecart (see readme)
- signs_bot (see readme)


#### 2021-08-19

Changed Mods:
- techage (see readme and constuction board)

Updated Mods:
- minecart


#### 2021-08-01

Newly added mods (must be activated!):
- networks
- ta4_addons (Touchscreen)

Changed Mods:
- techage (see readme and constuction board)
- minecart (see readme "Migration to v2")

Updated Mods:
- autobahn
- signs_bot
- hyperloop
- ta4_jetpack


#### 2021-05-14

Updated Mods:
- compost
- minecart
- signs_bot
- techage
- towercrane
- unified_inventory


#### 2021-02-07

Updated Mods:
- basic_materials
- compost
- hyperloop
- minecart
- signs_bot
- ta4_paraglider
- techage
- towercrane
- tubelib2
- unified_inventory


#### 2020-12-11

Updated Mods:
- autobahn
- basic_materials
- minecart
- techage v0.25
- ta4_jetpack
- tubelib2


#### 2020-10-25

Updated Mods:
- techage v0.24
- signs_bot
- minecart
- techpack_stairway
- stamina

ta4_paraglider newly added


#### 2020-09-13

Updated Mods:

- techage v0.23
- signs_bot
- minecart


#### 2020-08-08

Updated Mods:
- autobahn
- compost
- hyperloop
- lcdlib
- minecart
- safer_lua
- signs_bot
- techage v0.21


#### 2020-07-21

Updated Mods:
- signs_bot
- techage v0.18
- towercrane
- unified_inventory
- basic_materials

#### 2020-07-02
Updates (see local readme files):
- mod 3d_armor removed again (please install separately) 
- techage v0.15 improvements and bugfixes
- autobahn v0.04 improvements

#### 2020-06-29

Updates (see local readme files):
- autobahn, towercrane, ta4_jetpack, 3d_armor, and stamina now use a common player physics lockout mechanism
- the new mod ta4_jetpack added
- mod stamina added (adapted to the player physics lockout mechanism)
- mod 3d_armor added (needed for ta4_jetpack, adapted to the player physics lockout mechanism) 
- minecart v1.07 with many improvements
- techage v0.14 with many improvements
- hyperloop v2.06 update
- autobahn update


#### 2020-06-21

Updates (see local readme files):
- signs_bot v1.03
- techage v0.13
- hyperloop v2.06


#### 2020-06-18

- techage v0.12 
  - cart commands added for both controllers
  - support for moreores added
  - Ethereal support added, manual correction
  - tin ingot recipe bugfix
  
- minecart v1.06 
  
  - API changed and chat command added
  
- signs_bot v1.02
  - some bugfixes
  
  

#### 2020-06-04

- techage v0.10
  - minor changes and bugfixes
  - stone hammer added
  - quarry 'depth' command added
  - manuals adapted
  - QSG added

#### 2020-05-31

- first commit

