# TA3: Нефтяной век

В TA3 важно заменить машины с паровым двигателем на более мощные машины с электрическим двигателем.

Для этого вам придется построить электростанции и генераторы, работающие на угле. Вскоре вы увидите, что ваши потребности в электричестве можно удовлетворить только с помощью электростанций, работающих на нефти. Поэтому вам надо отправлятся на поиски нефти. Буровые вышки и нефтяные насосы помогают добывать нефть. Для транспортировки нефти к электростанции(ям) используются железные дороги.

Индустриальная эпоха достигла своего пика.

[techage_ta3|image].


## Угольная электростанция / Нефтяная электростанция

Угольная электростанция состоит из нескольких блоков и должна быть собрана, как показано на плане справа. Для этого необходимы блоки: TA3 "Топка электростанции", TA3 "Верх котла", TA3 "Основание котла", TA3 "Турбина", TA3 "Генератор" и TA3 "Охладитель".

Котел должен быть заполнен водой. Залить в котел можно до 10 ведер воды.
Топочный ящик должен быть заполнен углем или древесным углем.
Когда вода нагреется, запускается генератор.

В качестве альтернативы электростанция может быть оснащена нефтяной горелкой и работать на нефтепродуктах.
Нефть и нефтепродукты можно доливать с помощью насоса и труб.

Мощность электростанции составляет 80 ku.

[coalpowerstation|plan].


### TA3 Угольная топка электростанции

Часть электростанции.
В топку необходимо засыпать уголь или древесный уголь. Время горения зависит от мощности, которую запрашивает электростанция. Уголь горит 20 с, а древесный уголь - 60 с при полной нагрузке. Соответственно дольше при частичной нагрузке (50% нагрузки = увеличение длительности горения вдвое).

[ta3_firebox|image]


### TA3 Нефтяная топка электростанции

Часть электростанции.

В нефтяную топку можно заливать сырую нефть, мазут, нафту или бензин. Время горения зависит от мощности, которую запрашивает электростанция. При полной нагрузке сырая нефть горит 15 с, мазут - 20 с, лигроин - 22 с, а бензин - 25 с.


Соответственно дольше при частичной нагрузке (50% нагрузки = увеличение длительности горения вдвое).

Нефтяная горелка вмещает только 50 единиц топлива. Поэтому целесообразно установить дополнительный бак для масла и насос.


[ta3_oilbox|image]


### TA3 Котел

Часть электростанции. Должен быть заполнен водой. Если воды больше нет или температура падает слишком низко, электростанция отключается.

Расход воды в котле TA3 значительно ниже, чем в паровом двигателе, благодаря замкнутому паровому контуру.
В паровом двигателе часть воды теряется в виде пара при каждом ходе поршня.

[ta3_boiler|image]


### TA3 Турбина

Турбина является частью электростанции. Она должна быть расположена рядом с генератором и соединена с котлом и охладителем через паровые трубы, как показано на плане.

[ta3_turbine|image]


### TA3 Генератор

Генератор используется для выработки электроэнергии. Он должен быть подключен к машинам с помощью силовых кабелей и распределительных коробок.

[ta3_generator|image]


### TA3 Охладитель

Используется для охлаждения горячего пара из турбины. Должен быть подключен к котлу и турбине через паровые трубы, как показано на плане.

[ta3_cooler|image].


## Электрический ток

В TA3 (и TA4) машины питаются от электричества. Для этого машины, системы накопления энергии и генераторы должны быть соединены силовыми кабелями.
TA3 имеет 2 типа силовых кабелей:

- Изолированные кабели (силовые кабели TA) для локальной проводки в полу или в зданиях. Эти кабели могут быть скрыты в стене или в полу (могут быть "заштукатурены" с помощью мастерка).
- Сухопутные линии (линия электропередач TA) для прокладки кабелей вне помещений на большие расстояния. Эти кабели защищены и не могут быть сломанны другими игроками.


Несколько потребителей, систем накопления энергии и генераторов могут работать вместе в электрической сети. Сети можно создавать с помощью распределительных коробок.
Если электричества будет слишком мало, потребители остановятся.
В этом контексте также важно понимать функциональность блоков загрузки карты, поскольку, например, генераторы подают электричество только тогда, когда загружен соответствующий блок карты. Это можно обеспечить с помощью блока загрузки карты (Forceload).

В TA4 также есть низковольтный кабель для солнечной системы.


[ta3_powerswitch|image].


### Важность систем накопления энергии

Системы накопления энергии в энергосистеме выполняют две задачи:

- Чтобы справляться с пиками спроса: Все генераторы всегда выдают ровно столько энергии, сколько необходимо. Однако при включении/выключении потребителей или при колебаниях спроса по другим причинам потребители могут на короткое время выйти из строя. Чтобы предотвратить это, в каждой сети всегда должен быть хотя бы один батарейный блок. Он служит буфером и компенсирует эти колебания в диапазоне секунд.
- Для накопления возобновляемой энергии: Солнечная и ветровая энергия не доступна 24 часа в сутки. Чтобы не допустить перебоев в подаче электроэнергии, когда она не производится, в сети необходимо установить одну или несколько систем накопления энергии. В качестве альтернативы пробелы можно восполнить за счет электроэнергии, получаемой от нефти или угля.

Система накопления энергии указывает свою емкость в kud, то есть в ku в день. Например, система хранения с емкостью 100 kud обеспечивает 100 ku в течение одного игрового дня или 10 ku в течение 10 игровых дней.

Все источники энергии TA3/TA4 имеют регулируемые характеристики зарядки. По умолчанию она установлена на "80 % - 100 %". Это означает, что когда система хранения заполнена на 80 %, мощность снижается все больше и больше, пока не выключится полностью на 100 %. Если в сети требуется электроэнергия, 100% никогда не будет достигнуто, так как мощность генератора в какой-то момент снизится до уровня потребности в электроэнергии в сети, и система хранения больше не будет заряжаться, а будут обслуживаться только потребители.

Это имеет ряд преимуществ:

- Характеристики зарядки можно регулировать. Это означает, что, например, расход нефти/угля может быть снижен на 60 %, а регенеративных источников энергии - только на 80 %. Это означает, что нефть/уголь сжигается только в том случае, если не хватает возобновляемых источников энергии.
- Несколько источников энергии могут работать параллельно и загружены практически равномерно, поскольку все источники энергии работают, например, до 80% зарядной емкости системы хранения на полную мощность, а затем одновременно снижают свою мощность.
- Все системы хранения в сети образуют большой буфер. Зарядная емкость и уровень заполнения всей системы хранения всегда можно считать в процентах на каждой системе хранения, а также на терминале электроэнергии.

[power_reduction|image]



### TA Электрический кабель

Для локальной электропроводки в полу или в стенах зданий.
Разветвления могут быть реализованы с помощью распределительных коробок. Максимальная длина кабеля между машинами или распределительными коробками составляет 1000 м. В силовую сеть можно подключить не более 1000 узлов. Все блоки с силовым подключением, включая распределительные коробки, считаются узлами.

Поскольку силовые кабели не имеют автоматической защиты, для больших расстояний рекомендуется использовать наземные линии (линия электропередачи TA).

Силовые кабели можно заштукатурить с помощью мастерка, чтобы спрятать их в стене или в полу. В качестве штукатурного материала можно использовать любые каменные, глиняные и другие блоки, не обладающие "интеллектом". Земля не подходит, потому что земля может превратиться в траву и тому подобное, что разрушит линию.

Для нанесения штукатурки необходимо кликнуть на кабель мастерком. Материал, которым будет заштукатурен кабель, должен находиться слева в быстрых слотах игрока.
Кабели можно снова сделать видимыми, нажав на блок с лопаткой.

Помимо кабелей, можно также заштукатурить TA Электросоединитель и TA коробку выключателя электропитания.

[ta3_powercable|image].


### TA Электросоединитель

С помощью соединителя можно распределить электричество в 6 направлениях. Соединители также можно заштукатурить (спрятать) с помощью мастерка и снова сделать видимыми.

[ta3_powerjunction|image].


### TA Линия электропередачи

С помощью TA линии электропередачи и электрических столбов можно реализовать достаточно реалистичные воздушные линии. Опоры столбов также служат для защиты линии электропередачи (защита). Столбы должны быть установлены через каждые 16 м или менее. Защита распространяется только на линию электропередачи и столбы, однако все остальные блоки в этой области не защищены.

[ta3_powerline|image]


### TA Столб
Используется для строительства столбов электропередач. Защищен от разрушения верхушкой столба и может быть убран только владельцем.

[ta3_powerpole|image].


### TA Верхушка столба
Имеет до четырех креплений провода, что позволяет распределять электричество в 6 направлениях.
верхушка для столбов защищает линии электропередач и столбы в радиусе 8 м.

[ta3_powerpole4|image].


### TA Верхушка столба 2

Эта верхушка электрического столба имеет два фиксированных крепления провода и используется для воздушных линий. Однако она также может передавать ток вниз и вверх.
верхушка для столбов защищает линии электропередач и столбы в радиусе 8 м.

[ta3_powerpole2|image].


### ТА Выключатель

Выключатель можно использовать для включения и выключения питания. Для этого выключатель должен быть установлен на коробке выключателя питания. Коробка силового выключателя должна быть подключена к силовому кабелю с обеих сторон.

[ta3_powerswitch|image].


### TA Выключатель мини

Переключатель можно использовать для включения и выключения питания. Для этого переключатель должен быть установлен на коробке переключателя питания. Коробка силового переключателя должна быть подключена к силовому кабелю с обеих сторон.

[ta3_powerswitchsmall|image]


### TA Коробка выключателя

см. переключатель питания TA.

[ta3_powerswitchbox|image].


### TA3 Портативный генератор

Портативный генератор работает на бензине и может использоваться для небольших потребителей мощностью до 12 ku. При полной нагрузке бензин сгорает в течение 150 с. Соответственно дольше при частичной нагрузке (50% нагрузки = увеличение длительности горения в два раза).

Портативный генератор вмещает только 50 единиц бензина. Желательно установить дополнительный бак и насос.


[ta3_tinygenerator|image]


### TA3 Аккумулятор

Аккумулятор используется для накопления избыточной энергии и автоматически подает энергию в случае отключения питания при ее наличии.
Несколько аккумуляторов вместе образуют систему хранения энергии TA3. На каждом блоке есть индикатор состояния зарядки и накопленной нагрузки.
Здесь всегда отображаются значения для всей сети. Накопленная энергия отображается в kud или "ku-днях" (аналогично кВт-ч). 5 kud соответствует, например, 5 ku за игровой день (20 минут) или 1 ku за 5 игровых дней.

Аккумулятор имеет емкость 3,33 kud

[ta3_akkublock|image].


### TA3 Терминал электросети

Терминал электросети должен быть подключен к электросети. На нем отображаются данные из электросети.

Наиболее важные показатели отображаются в верхней половине:

- ток/максимальная мощность генератора
- текущее энергопотребление всех потребителей
- текущий зарядный ток в/из системы хранения
- Текущее состояние заряда системы хранения в процентах

В нижней половине выводится количество устройств в сети.

Дополнительные данные о генераторах и системах хранения можно запросить на вкладке "Консоль".

[ta3_powerterminal|image].


### TA3 Электродвигатель

Электродвигатель TA3 необходим для того, чтобы машины TA2 могли работать от электросети. Электродвигатель TA3 преобразует электричество в мощность оси.
Если на электродвигатель не подается достаточная мощность, он переходит в состояние неисправности и должен быть снова активирован щелчком правой кнопки мыши.

Электродвигатель потребляет макс. 40 ku электроэнергии и обеспечивает макс. 39 ku в качестве мощности оси. Таким образом, он расходует один ku на преобразование.

[ta3_motor|image]




## TA3 Промышленная печь

Промышленная печь TA3 служит дополнением к обычным печам. Это означает, что все товары можно производить по рецептам "варки" даже в промышленной печи. Но есть и особые рецепты, которые можно получить только от промышленной печи.
Промышленная печь имеет собственное меню для выбора рецепта. В зависимости от того, какие ресурсы находятся в инвентаре промышленной печи слева, справа можно выбрать выходной продукт.

Промышленная печь требует электричества (для нагнетателя) и мазута/бензина для горелки. Промышленная печь должна быть собрана, как показано на плане справа.

См. также нагреватель TA4.

[ta3_furnace|plan]


### TA3 Нефтяная горелка

Является частью промышленной печи TA3.

Нефтяная горелка может работать на сырой нефти, мазуте, нафте или бензине. Время горения составляет 64 с для сырой нефти, 80 с для мазута, 90 с для нафты и 100 с для бензина.

Нефтяная горелка вмещает только 50 единиц топлива. Желательно установить дополнительный бак и насос.

[ta3_furnacefirebox|image]


### TA3 Верхняя часть печи

Является частью TA3 промышленной печи. См. промышленную печь TA3.

[ta3_furnace|image]


### TA3 Нагнетатель

Является частью промышленной печи TA3. См. промышленную печь TA3.
Служит для нагнетания воздуха в топку.

[ta3_booster|image]


## Жидкости

Жидкости, такие как вода или нефть, можно перекачивать только по специальным трубам и хранить в резервуарах. Как и в случае с водой, существуют емкости (канистры, бочки), в которых жидкость можно хранить и перевозить.

С помощью желтых труб и соединителей можно также соединить несколько резервуаров. Однако резервуары должны иметь одинаковое содержимое, а между резервуаром, насосом и распределительной трубой всегда должна быть хотя бы одна желтая труба.

Например, невозможно подключить два резервуара непосредственно к распределительной трубе.

Наливное устройство используется для переливания жидкостей из контейнеров в резервуары. На плане показано, как канистры или бочки с жидкостями с помощью толкателей заталкиваются в наливное устройство. Контейнер опорожняется в наливном устройстве, и жидкость спускается в резервуар.

Наливное устройство также можно поместить под резервуар, чтобы опорожнить его.

[ta3_tank|plan]


### TA3 Резервуар

Жидкости можно хранить в резервуаре. Резервуар можно наполнить или опорожнить с помощью насоса. Для этого насос должен быть подключен к резервуару через трубу (желтые трубы).

Резервуар также можно заполнить или опустошить вручную, щелкнув по нему с полным или пустым контейнером для жидкости (бочкой, канистрой). Следует отметить, что бочки могут быть заполнены или опустошены только полностью. Если, например, в резервуаре осталось менее 10 единиц, этот остаток необходимо удалить с помощью канистр или выкачать до пустоты.

Цистерна TA3 вмещает 1000 единиц или 100 бочек жидкости.

[ta3_tank|image]


### TA3 Насос

Насос можно использовать для перекачивания жидкостей из резервуаров или контейнеров в другие резервуары или контейнеры. При работе насоса необходимо соблюдать направление (стрелка). Желтые линии и соединители также позволяют устанавливать несколько резервуаров с каждой стороны насоса. Однако резервуары должны иметь одинаковое содержимое.

Насос TA3 перекачивает 4 единицы жидкости каждые две секунды.

Примечание 1: Насос не должен располагаться непосредственно рядом с резервуаром. Между ними всегда должен быть как минимум кусок желтой трубы.

[ta3_pump|image]


### TA Наливное устройство

Наливное устройство используется для перекачки жидкостей между емкостями и резервуарами.

- Если наливное устройство находится под резервуаром, а пустые бочки помещаются в наливное устройство с помощью толкателя или вручную, содержимое резервуара переливается в бочки, и бочки можно извлечь из выпускного отверстия.
- Если наливное устройство установлено на резервуаре, а полные контейнеры помещаются в наливное устройство с помощью толкателя или вручную, содержимое переливается в резервуар, а пустые контейнеры могут быть удалены со стороны выхода

Следует отметить, что бочки могут быть заполнены или опустошены только полностью. Если, например, в резервуаре осталось менее 10 единиц, этот остаток необходимо удалить с помощью канистр или откачать пустым насосом.

[ta3_filler|image]

### TA3 Труба

Желтые трубы используются для передачи газа и жидкостей.
Максимальная длина трубы - 100 м.

[ta3_pipe|image]

### TA3 Труба в стене

Блоки служат для скрытого проведения в стенах труб.

[ta3_pipe_wall_entry|image]

### TA Вентиль

Для желтых труб предусмотрен вентиль, который можно открывать и закрывать одним щелчком мыши.
Управление вентилем также может осуществляться с помощью команд включения/выключения (см. TA3 Терминал).

[ta3_valve|image]


## Добыча нефти

Для того чтобы генераторы и печи работали на нефти, вам нужно сначала найти нефть. А после этого надо построить вышку, а затем добыть ее.
Для этого используются TA3 Нефтяной сонар, TA3 буровая установка и TA3 Нефтяной насос.

[techage_ta3|image].


### TA3 Нефтяной сонар

Вы можете искать нефть с помощью нефтяного сонара. Для этого поставьте блок на пол/грунт/землю и щелкните правой кнопкой мыши, чтобы начать поиск. Нефтяной сонар использовать как над землей, так и под землей на любой глубине.
В чате отображается информация о глубине поиска нефти и количестве найденной нефти (петролеума).
Вы можете нажимать на блок несколько раз, чтобы искать нефть в более глубоких областях. Размер нефтяных месторождений варьируется от 4 000 до 20 000 единиц.

Если поиски не увенчались успехом, необходимо передвинуть блок на 16 м дальше.
Нефтяной сонар всегда ищет нефть во всем блоке карты и ниже, в котором он был установлен. Поэтому новый поиск в том же блоке карты (поле 16x16) не имеет смысла.

Если нефть найдена, на экране появится место для установки буровой вышки. Вы должны возвести буровую вышку в пределах указанной области, лучше всего отметить место знаком и защитить всю территорию от посторонних игроков.

Не отказывайтесь от поисков нефти слишком быстро. Если вам не повезет, поиск нефти может занять много времени.
Также не имеет смысла искать нефть в зоне, которую уже обыскал другой игрок. Шанс найти нефть в любом месте одинаков для всех игроков.

[ta3_oilexplorer|image]


### TA3 Буровая установка

Буровая установка должна быть установлена в месте, указанном нефтеразведчиком. Бурить нефть в другом месте бессмысленно.
Если нажать кнопку на коробке с нефтяным буром, над ней будет возведена вышка. Это занимает несколько секунд.
Буровая установка имеет 4 стороны, в IN подается бурильная труба через толкатель, а в OUT вылетает буровой материал. Через одну из двух свободных сторон на буровую установку должно подаваться питание.

Буровая установка бурит до нефтяного месторождения (1 метр за 16 с) и требует 16 ku электроэнергии.
После достижения нефтяного месторождения установка может быть разобрана, а блок убран.

[ta3_drillbox|image]


### TA3 Нефтекачка

Теперь на место буровой установки необходимо установить нефтекачку (pump-jack). нефтекачка также требует электричество (16 ku) и подает одну единицу нефти каждые 8 с. Нефть должна собираться в резервуар. Для этого нужно соединить нефтекачку с резервуаром с помощью желтых труб.
После того как все нефть будет выкачана, можно снять и саму нефтекачку.

[ta3_pumpjack|image]


### TA3 Бурильная труба

Для бурения требуется столько труб, на какую глубину рассчитано нефтяное месторождение. После бурения труба становится бесполезной, но ее также нельзя демонтировать, и она остается в земле. Однако существует инструмент для извлечения бурильных труб (-> Инструменты -> TA3 ключ для бурильных труб).

[ta3_drillbit|image]


### Нефтяной резервуар

Нефтяной резервуар - это большая версия TA3 Резервуара (см. Жидкости -> TA3 Резервуар).

Большой резервуар вмещает 4000 единиц нефти, а также любые другие виды жидкостей.

[oiltank|image].



## Транспортировка нефти

### Транспортировка нефти вагонетками

Вагонетки-цистерны могут использоваться для транспортировки нефти от нефтяной скважины до нефтеперерабатывающего завода. Вагонетку-цистерну можно наполнять или опорожнять непосредственно с помощью насосов. В обоих случаях желтые трубы должны быть подсоединены к вагонетке-цистерне сверху.

Необходимо выполнить следующие действия:

- Установите вагонетку-цистерну перед рельсовым бамперным блоком. Блок бампера еще не должен быть запрограммирован на время, чтобы вагонетка-цистерна не запустилась автоматически
- Подключите вагонетку с цистерной к насосу с помощью желтых труб
- Включите насос
- Запрограммируйте бампер на время (10 - 20 с)

Эта последовательность должна соблюдаться с обеих сторон (накачивание / выкачивание).

[tank_cart | image]

### Транспортировка нефти с помощью бочек по сравнению с Minecarts

В Minecart (Далее вагонетки) можно загружать канистры и бочки. Для этого нефть нужно сначала перелить в бочки. Бочки с нефтью можно заталкивать прямо в вагонетку с помощью толкателя и труб (см. карту). Пустые бочки, которые возвращаются со станции разгрузки на вагонетке, можно выгрузить с помощью бункера, который устанавливается под рельсами на остановке.

С помощью бункера невозможно одновременно **разгрузить пустые бочки и загрузить полные бочки во время остановки**. Бункер сразу же выгружает полные бочки. Поэтому рекомендуется установить 2 станции на стороне загрузки и разгрузки, а затем запрограммировать вагонетку соответствующим образом с помощью прогона записи.

На плане показано, как нефть можно закачать в резервуар, наполнить бочки через заливное устройство и погрузить в вагонетку.

Чтобы вагонетки запускались снова автоматически, на бамперных блоках необходимо указать название станции и время ожидания. Для разгрузки достаточно 5 с. Однако, поскольку толкатели всегда переходят в режим ожидания на несколько секунд при отсутствии вагонетки, для загрузки необходимо ввести время 15 или более секунд.

[ta3_loading|plan]

### Вагонетка-цистерна

Вагонетка-цистерна используется для перевозки жидкостей. Как и цистерны, ее можно наполнять с помощью насосов или опорожнять. В обоих случаях желтая труба должна быть подсоединена к автоцистерне сверху.

В вагонетку-цистерну помещается 200 единиц.

[tank_cart | image]

### Вагонетка-сундук

Вагонетка-сундук используется для перевозки предметов. Как и сундуки, ее можно наполнить или опустошить с помощью толкателя.

4 стопки помещаются в вагонетку-сундук.

[chest_cart | image]


## Переработка нефти

Нефть - это смесь веществ, состоящая из множества компонентов. С помощью перегонной колонны нефть можно разделить на основные компоненты, такие как битум, мазут, нафта, бензин и газ пропан.
Дальнейшая переработка до конечных продуктов происходит в химическом реакторе.

[techage_ta31|image].


### Дистилляционная колонна

Дистилляционная колонна должна быть установлена так, как показано на плане в правом верхнем углу.
Битум сливается через базовый блок. Выход находится на задней стороне базового блока (обратите внимание на направление стрелки).
Блоки "перегонной башни" с номерами: 1, 2, 3, 2, 3, 2, 3, 4 расположены на этом основном блоке
Мазут, нафта и бензин вытекают из отверстий снизу вверх. Газ пропан попадает в верхнее отверстие.
Все отверстия на башне должны быть соединены с резервуарами.
Нефтяной нагреватель должен быть подключен к блоку "Дистилляционная колонна 1".

Нефтяной нагреватель требует электричество (не показано на плане)!


[ta3_distiller|plan]

#### Нефтяной нагреватель

В нефтяном нагревателе нефть нагревается примерно до 400 °С. Оно в значительной степени испаряется и поступает в дистилляционную колонну для охлаждения.

Нефтяной нагреватель требует 14 единиц электроэнергии и производит одну единицу битума, мазута, нафты, бензина и пропана каждые 16 с.
Для этого в нефтяной нагреватель необходимо подавать нефть через насос.

[reboiler|image]


## Логические/коммутационные блоки

Помимо труб для транспортировки грузов, а также газо- и электропроводов, существует также беспроводной уровень связи, с помощью которого блоки могут обмениваться данными друг с другом. Для этого не нужно прокладывать линии, связь между передатчиком и приемником осуществляется только через номер блока.

**Информация:** Номер блока - это уникальный номер, который генерируется модом Techage при размещении большого количества блоков Techage. Номер блока используется для адресации при обмене данными между контроллерами Techage и машинами. Все блоки, которые могут участвовать в этом общении, показывают номер блока в виде информационного текста, если вы фиксируете блок курсором мыши.

Какие команды поддерживает тот или иной блок, можно узнать и отобразить с помощью TechAge Info Tool (гаечный ключ).
Простейшие команды, поддерживаемые почти всеми блоками:

- `on` - включать блок / машину / лампу
- `off` - выключить блок / машину / лампу

С помощью терминала TA3 эти команды можно легко опробовать. Предположим, сигнальная лампа имеет номер 123.
Затем с:

    cmd 123 on

лампу можно включать и выключать:

    cmd 123 off

лампа может быть снова выключена. Эти команды должны быть введены в поле ввода терминала TA3.

Такие команды, как "on" и "off", отправляются получателю без ответной реакции. Таким образом, эти команды могут быть отправлены нескольким получателям одновременно, например, с помощью кнопки/выключателя, если в поле ввода введено несколько цифр.

Команда типа `state` запрашивает статус блока. Затем блок отправляет свой статус обратно. Этот тип подтвержденной команды может быть отправлен только одному получателю одновременно.
Эту команду можно также проверить, например, с помощью клеммы TA3 на толкателе:

    cmd 123 state

Возможные ответы толкателя::
- `running` -> работает
- `stopped` -> выключен
- `standby` -> ничего не делает, потому что исходный инвентарь пуст
- `blocked` -> не может ничего сделать, потому что инвентарь цели переполнен

Этот статус и другая информация также выводятся при нажатии гаечного ключа на блок.

[ta3_logic|image]


### TA3 Кнопка / переключатель
Кнопка/переключатель посылает команды `on` / `off` на блоки, которые были сконфигурированы с помощью цифр.
Кнопка/переключатель может быть настроена как кнопка или переключатель. Если она сконфигурирована как кнопка, можно установить время между командами `on` и `off`. В режиме работы "button" (кнопка) передается только команда `on` и не передается команда `off`.

С помощью флажка "public" можно установить, может ли кнопка использоваться всеми (установлено) или только самим владельцем (не установлено).

Примечание: С помощью программатора можно легко собирать и настраивать номера блоков.

[ta3_button|image]

### TA3 Преобразователь команд

С помощью конвертера команд TA3 команды `on` / `off` могут быть преобразованы в другие команды, а переадресация может быть предотвращена или отложена.
Необходимо ввести номер целевого блока или номера целевых блоков, команды для отправки и время задержки в секундах. Если команда не введена, ничего не будет отправлено.

Номера также можно запрограммировать с помощью программатора Techage.

[ta3_command_converter|image].

### TA3 Триггер

TA3 Триггер меняет свое состояние при каждой полученной команде `on`. Полученные команды `off` игнорируются. В зависимости от изменения состояния, команды `on` / `off` посылаются поочередно. Необходимо ввести номер целевого блока или номера целевых блоков. Номера также могут быть запрограммированы с помощью Techage программатора.

Например, лампы можно включать и выключать с помощью кнопок.

[ta3_flipflop|image]

### TA3 Логический блок

TA3 Логический блок может быть запрограммирован таким образом, что одна или несколько входных команд будут связаны с одной выходной командой и отправлены. Таким образом, этот блок может заменить различные логические элементы, такие как AND (И), OR (ИЛИ), NOT (НЕ), XOR (исключающее ИЛИ) и т. д.
Входными командами для логического блока являются команды `on` / `off`.
Входные команды обозначаются номером, например, `1234` для команды от отправителя с номером 1234.
То же самое относится и к командам вывода.

Правило имеет следующую структуру:


```
<output> = on/off if <input-expression> is true
```


`<output>` - это номер блока, в который должна быть отправлена команда.
`<input-expression>` - это булево выражение, в котором оцениваются входные числа.



**Примеры для входного выражения**

Логическое НЕ:

    1234 == off.

Логическое И:

    1234 == on. and 2345 == on.

Логическое ИЛИ:

    1234 == on. or 2345 == on.

Допустимы следующие операторы:  `and`   `or`   `on`   `off`   `me`   `==`   `~=`   `(`   `)`

Если выражение истинно, то в блок с номером `<output>` отправляется команда.
Можно задать до четырех правил, при этом все правила всегда проверяются при получении команды.
Внутреннее время обработки всех команд составляет 100 мс.

Ваш собственный номер узла может быть указан с помощью ключевого слова `me`. Это позволяет блоку посылать самому себе команду (функция флип-флопа).

Время блокировки определяет паузу после команды, в течение которой логический блок не принимает никаких дальнейших внешних команд. Команды, полученные в период блокировки, отбрасываются. Время блокировки может быть задано в секундах.

[ta3_logic|image]


### TA3 Повторитель

Повторитель отправляет полученный сигнал на все настроенные номера.
Это может иметь смысл, например, если вы хотите управлять несколькими блоками одновременно. Повторитель можно настроить с помощью программатора, что возможно не для всех блоков.

[ta3_repeater|image]


### TA3 Секвенсор

Секвенсор может посылать серию команд `вкл` / `выкл`, при этом интервал между командами должен быть указан в секундах. С его помощью можно, например, заставить мигать лампу.
Можно настроить до 8 команд, каждая из которых будет содержать номер целевого блока и ожидание следующей команды.
Секвенсор повторяет команды бесконечно, если установлен параметр "Run endless".
Если ничего не выбрано, то будет ожидаться только указанное в секундах время.

[ta3_sequencer|image].


### TA3 Таймер

Таймер может отправлять команды в разное время. Для каждой командной строки можно указать время, номер (номера) цели и саму команду. Это означает, что лампы можно включать вечером и выключать утром.

[ta3_timer|image]


### TA3 Терминал

Терминал используется в основном для тестирования командного интерфейса других блоков (см. "Логические/коммутационные блоки"), а также для автоматизации систем с использованием языка программирования BASIC.
Вы также можете назначить команды клавишам и использовать терминал продуктивно.

    set <button-num> <button-text> <command>

С помощью команды `set 1 ON cmd 123 on`, например, пользовательская клавиша 1 может быть запрограммирована на команду `cmd 123 on`. При нажатии клавиши команда будет отправлена, а ответ выведен на экран.

Терминал имеет следующие локальные команды:
- `clear` очистить экран
- `help` выводит страницу помощи
- `pub` переключиться на публичные кнопки
- `priv` переключиться на приватные кнопки

В частном режиме терминал могут использовать только те игроки, которые могут строить в этом месте, то есть имеют права на защиту.

В публичном режиме все игроки могут использовать предварительно настроенные ключи.

Переключиться в режим BASIC можно с помощью открытого гаечного меню. Более подробную информацию о режиме BASIC вы можете найти [здесь](https://github.com/joe7575/techage/tree/master/manuals/ta3_terminal.md)

[ta3_terminal|image]


### TechAge Цветная лампа

Цветная лампа может быть включена или выключена с помощью команды `on` / `off`. Эта лампа не нуждается в электричестве и может быть окрашена с помощью инструмента аэрографа из мода Unified Dyes и/или с помощью команд Lua/Beduino.

С помощью команды чата `/ta_color` отображается цветовая палитра со значениями для команд Lua/Beduino, а с помощью `/ta_send color <num>` цвет можно изменить.

[ta3_colorlamp|image]


### Блоки дверей и ворот

С помощью этих блоков можно реализовать двери и ворота, которые можно открывать с помощью команд (блоки исчезают) и снова закрывать. Для каждых ворот или двери требуется один контроллер.

Внешний вид блоков можно настроить с помощью меню блоков.
Это позволяет реализовать секретные двери, которые открываются только для определенных игроков (с помощью детектора игроков).

[ta3_doorblock|image]

### TA3 Контроллер дверей

Дверной контроллер используется для управления блоками дверей/ворот TA3. С помощью дверного контроллера необходимо ввести номера блоков дверей/ворот. Если на контроллер двери подается команда `on` / `off`, это открывает/закрывает дверь или ворота.

[ta3_doorcontroller|image].

### TA3 Контроллер дверей II

Контроллер дверей II (дальше КД2) может снимать и устанавливать все типы блоков. Для настройки КД2 необходимо нажать кнопку "Запись". Затем необходимо нажать на все блоки, которые должны быть частью двери/ворота. Затем необходимо нажать кнопку "Готово". Можно выбрать до 16 блоков. Удаленные блоки сохраняются в инвентаре контроллера. Функционирование контроллера можно проверить вручную с помощью кнопки "Обмен". Если на контроллер Door Controller II подается команда `on` / `off`, он также удаляет или устанавливает блоки.

С помощью `$send_cmnd(node_number, "exchange", 2)` отдельные блоки могут быть установлены, удалены или заменены другими блоками из инвентаря.

С помощью `$send_cmnd(node_number, "set", 2)` блок из инвентаря может быть установлен явно, если слот инвентаря не пуст.

Блок может быть снова удален с помощью `$send_cmnd(node_number, "dig", 2)`, если слот инвентаря пуст.

Имя блока набора возвращается с помощью `$send_cmnd(node_number, "get", 2)`.

Номер слота инвентаря (1 ... 16) должен быть передан в качестве полезной нагрузки во всех трех случаях.

С помощью `$send_cmnd(node_number, "reset")` происходит сброс контроллера двери.

Это также можно использовать для имитации выдвижных лестниц и т.п.

[ta3_doorcontroller|image].

### TA3 Звуковой блок

С помощью звукового блока можно воспроизводить различные звуки. Доступны все звуки модов Techage, Signs Bot, Hyperloop, Unified Inventory, TA4 Jetpack и Minetest Game.

Звуки можно выбирать и воспроизводить через меню и с помощью команд.

- Команда `on` для воспроизведения звука
- Команда `sound <idx>` для выбора звука по индексу
- Команда `gain <volume>` позволяет регулировать громкость с помощью значения `<volume>` (от 1 до 5).

[ta3_soundblock|image]

### TA3 Преобразователь Mesecons

Конвертер Mesecons используется для преобразования команд включения/выключения Techage в сигналы Mesecons и наоборот.
Для этого необходимо ввести один или несколько номеров узлов и использовать конвертер с блоками Mesecons.
должны быть подключены через кабели Mesecons. Конвертер Mesecons также может быть сконфигурирован с помощью программатора.
Конвертер Mesecons принимает до 5 команд в секунду; при более высокой нагрузке он отключается.

**Этот узел существует только в том случае, если активен мод mesecons!**.

[ta3_mesecons_converter|image]



## Детекторы

Детекторы сканируют окружающее пространство и подают команду `включить`, когда поиск распознан.

[ta3_nodedetector|image]


### TA3 Детектор предметов

Детектор - это специальный блок трубок, который обнаруживает, когда через трубку проходят предметы. Для этого он должен быть подключен к трубкам с обеих сторон. Если предметы проталкиваются в детектор с помощью толкателя, они автоматически передаются дальше.
Он посылает сигнал "включено", когда предмет распознан, и сигнал "выключено" секундой позже.
Затем дальнейшие команды блокируются на 8 секунд.
Время ожидания и элементы, которые должны вызывать команду, можно настроить с помощью открытого гаечного меню.


[ta3_detector|image]


### TA3 Детектор вагонетки

Детектор тележек посылает команду `on`, если он распознал тележку (Minecart) прямо перед собой. Кроме того, детектор может перезапустить тележку при получении команды `on`.

Детектор также можно запрограммировать на свой собственный номер. В этом случае он толкает все вагоны, которые останавливаются рядом с ним (один квартал во всех направлениях).

[ta3_cartdetector|image]


### TA3 Детектор блоков

Детектор блоков посылает команду `on`, если обнаруживает, что перед ним появляются или исчезают блоки, но должен быть настроен соответствующим образом. После возвращения детектора в стандартное состояние (серый блок) посылается команда `off`. Допустимыми блоками являются все типы блоков и растений, но не животные или игроки. Радиус действия датчика составляет 3 блока/метра в направлении стрелки.

[ta3_nodedetector|image]


### TA3 Детектор игроков

Детектор игроков посылает команду `on`, если обнаруживает игрока в пределах 4 м от блока. Если игрок снова покидает зону, отправляется команда `off`.
Если поиск должен быть ограничен конкретными игроками, можно также ввести имена этих игроков.

[ta3_playerdetector|image]

### TA3 Детектор света

Детектор света посылает команду `on`, если уровень освещенности блока выше превышает определенный уровень, который можно задать через меню правой кнопки мыши.
Если у вас есть TA4 Lua контроллер, вы можете получить точное значение уровня освещенности с помощью $get_cmd(num, 'light_level').

[ta3_lightdetector|image].

## TA3 Машины

В TA3 есть те же машины, что и в TA2, только они мощнее и требуют электричества вместо механического привода.
Поэтому ниже приведены только различные технические характеристики.

[ta3_grinder|image].


### TA3 Толкатель

Функциональность такая же, как TA2.
Производительность составляет 6 элементов каждые 2 с.

[ta3_pusher|image]


### TA3 Распределитель

Функциональность такая же, как TA2.
Производительность составляет 12 элементов каждые 4 с.

[ta3_distributor|image]


### TA3 Автокрафтер

Функциональность такая же, как TA2.
Производительность составляет 2 предмета каждые 4 с. Автокрафтер требует 6 ku электроэнергии.

[ta3_autocrafter|image]


### TA3 Фабрика электроники

Функциональность такая же, как TA2, только здесь производятся микросхемы TA4 WLAN.
Производительность составляет один чип каждые 6 с. Для этого блоку требуется 12 ku электроэнергии.

[ta3_electronicfab|image]


### TA3 Карьер

Функциональность такая же, как TA2.
Максимальная глубина - 40 метров. Для работы карьера требуется 12 ku электроэнергии.

[ta3_quarry|image]


### TA3 Просеиватель

Функциональность такая же, как TA2.
Производительность составляет 2 элемента каждые 4 с. Блок требует 4 ku электроэнергии.

[ta3_gravelsieve|image]


### TA3 Промыватель

Функциональность такая же, как TA2.
Вероятность также такая же, как и для TA2. Блок также требует 3 ku электроэнергии.
Но в отличие от TA2, статус блока TA3 можно считать (контроллер)

[ta3_gravelrinser|image]


### TA3 Измельчитель

Функциональность такая же, как TA2.
Производительность составляет 2 элемента каждые 4 с. Блок требует 6 ku электроэнергии.

[ta3_grinder|image].

### TA3 Инжектор

Инжектор представляет собой толкатель TA3 с особыми свойствами. Он имеет меню для настройки. Здесь можно настроить до 8 предметов. Он берет эти предметы только из сундука, чтобы передать их машинам с рецептами (автокрафтер, промышленная печь и электронная фабрика).

При передаче в целевой машине используется только одна позиция в инвентаре. Если, например, в инжекторе настроены только первые три позиции, то в инвентаре машины используются только первые три места хранения. Таким образом, предотвращается переполнение инвентаря машины.

Инъектор также можно переключить в "режим вытягивания". Тогда он достает предметы из сундука только из тех позиций, которые заданы в конфигурации инжектора. При этом тип и позиция предмета должны совпадать. Это позволяет опустошать определенные позиции инвентаря в сундуке.

Производительность составляет до 8 раз по одному элементу каждые 4 секунды.

[ta3_injector|image].



## Инструменты

### TechAge Гаечный ключ

Techage Гаечный ключ имеет несколько функций. Он показывает время, положение, температуру и биом при нажатии на неизвестный блок.
Если нажать на блок TechAge с командным интерфейсом, будут показаны все доступные данные (см. также "Логические / коммутационные блоки").

С помощью Shift + правый клик можно открыть расширенное меню для некоторых блоков. В зависимости от блока здесь можно вызвать дополнительные данные или выполнить специальные настройки. Например, в случае генератора можно запрограммировать кривую зарядки/выключения.

[ta3_end_wrench|image]

### TechAge Программатор

С помощью программатора номера блоков можно собирать из нескольких блоков правым щелчком мыши и записывать в блок, как кнопку/переключатель, левым щелчком.
Если нажать в воздухе, внутренняя память будет удалена.

[ta3_programmer|image].

### TechAge Мастерок

Мастерок используется для оштукатуривания силовых кабелей. См. также "TA Электрический кабель".

[ta3_trowel|image]

### TA3 Ключ для буровых труб

Этот инструмент можно использовать для удаления блоков бурильных труб, если, например, в них будет проходить туннель.

[ta3_drill_pipe_wrench|image]

### TechAge Отвертка

Отвертка Techage служит заменой обычной отвертке. Она обладает следующими функциями:

- Левый клик: повернуть блок влево
- Щелчок правой кнопкой мыши: повернуть видимую сторону блока вверх
- Shift + левый клик: сохранить выравнивание щелкнутого блока.
- Shift + правый клик: применить сохраненное выравнивание к щелкнутому блоку.

[ta3_screwdriver|image].

### TechAge Инструмент для сборки

TechAge Инструмент для сборки используется для удаления и перестановки блоков Techage без потери номера блока или присвоения ему нового номера при установке. Это полезно, например, для карьеров, так как их часто приходится перемещать.

- Левая кнопка: Удалить блок
- Правая кнопка: Установить блок

Блок, который ранее был удален с помощью инструмента для сборки и должен быть помещен снова, должен находиться в крайней левой части инвентаря игрока.

[techage:assembly_tool|image]
