# TA2: Паровой век

TA2 - это строительство и эксплуатация первых машин для переработки руды. Некоторые машины должны приводиться в движение с помощью ведущих осей. Для этого нужно построить паровой двигатель и топить его углем или древесным топливом.

В TA2 также есть гравийный промыватель, который можно использовать для промывки редких руд, таких как самородки усмия. Эти самородки понадобятся вам позже для дальнейших рецептов.

[techage_ta2|image]

## Паровой двигатель

Паровой двигатель состоит из нескольких блоков и должна быть собрана, как показано на плане справа. Необходимы блоки TA2 «Топка», TA2 «Верх котла», TA2 «Низ котла», TA2 «Цилиндр», TA2 «Маховик» и паровые трубы.

Кроме того, необходимы ведущие оси и блоки шестерен для изменения направления движения. Маховик должен быть соединен со всеми машинами, которые должны приводиться в движение через ведущие мосты.

При установке всегда обращайте внимание на выравнивание всех блоков:

- Цилиндр слева, маховик справа.
- Подсоединяйте паровые трубы там, где есть соответствующее отверстие
- Ведущая ось на маховике только справа
- Во всех машинах ведущие оси могут быть подключены со всех сторон, которые не заняты другими функциями, например, отверстиями IN и OUT в измельчителе и ссеялке.

Котел должен быть заполнен водой. Залейте в котел до 10 ведер воды.
Топка должна быть заполнена углем или древесным углем.
Когда вода нагреется (индикатор температуры вверху), можно запустить паровой двигатель.

Мощность парового двигателя составляет 25 ku, поэтому он может приводить в движение несколько машин одновременно.

[steamengine|plan]


### TA2 Топка

Часть парового двигателя.

Топка должна быть заполнена углем или древесным углем. Время горения зависит от мощности, которую требует паровая машина. Уголь горит 32 сек, а древесный уголь - 96 сек при полной нагрузке.

[ta2_firebox|image]


### TA2 Водонагреватель

Часть парового двигателя. Должен быть заполнен водой. Это можно сделать ведром воды. Когда воды больше нет или температура падает слишком низко, паровая машина выключается. При работе парового двигателя часть воды теряется в виде пара при каждом ходе поршня, поэтому воду необходимо регулярно доливать.

[ta2_boiler|image]


### TA2 Цилиндр

Часть парового двигателя.

[ta2_cylinder|image]


### TA2 Маховик

Приводная часть парового двигателя. Маховик должен быть соединен с машинами через ведущие оси.

[ta2_flywheel|image]


### TA2 Паровые трубы

Часть парового двигателя. Котел должен быть соединен с цилиндром через паровые трубы. Паровая труба не имеет ответвлений, максимальная длина - 12 м (блоков).

[ta2_steampipe|image]


### TA2 Приводной вал / TA2 Редуктор

Приводные валы используются для передачи энергии от парового двигателя к другим машинам. Максимальная длина приводного вала составляет 10 блоков. С помощью редукторов TA2 можно преодолевать большие расстояния, делать ответвления и менять направление движения.

[ta2_driveaxle|image]


### TA2 Электрогенератор

Электрогенератор TA2 необходим для работы ламп или других потребителей электрической энергии от парового двигателя. Электрогенератор TA2 должен быть подключен к ведущим осям с одной стороны, а затем подавать электричество на другую сторону.

Если на электрогенератор не подается достаточное количество энергии, он переходит в состояние ошибки и должен быть снова активирован щелчком правой кнопки мыши.

Электрогенератор принимает до 25 ku энергии от оси и выдает на другую сторону до 24 ku в виде электроэнергии. Таким образом, он потребляет один ku для преобразования.

[ta2_generator|image]

## TA2 Накопитель энергии

Для больших систем с несколькими паровыми двигателями или большим количеством приводимых в движение машин рекомендуется использовать систему накопления энергии. Накопитель энергии в TA2 работает на потенциальной энергии. Для этого балласт (камни, гравий, песок) поднимается с помощью тросовой лебедки. При избытке механической энергии в сети груз подтягивается вверх. Если в краткосрочной перспективе требуется больше энергии, чем может дать паровая машина, накопитель энергии высвобождает запасенную энергию, и груз опускается вниз.
Накопитель энергии состоит из нескольких блоков и должен быть собран, как показано на плане справа. 
Чтобы достичь максимальной вместимости, сундук должен быть полностью заполнен грузами, а высота мачты с двумя коробками передач должна составлять 12 блоков. Возможны и более компактные конструкции.

[ta2_storage|plan]



### TA2 Лебедка

Тросовая лебедка должна быть соединена с коробкой передач и может поглощать избыточную энергию и таким образом тянуть груз вверх. 
При сборке лебедки убедитесь, что стрелка на верхней части блока направлена на коробку передач.
Максимальная длина троса составляет 10 блоков. 

[ta2_winch|image]


### TA2 Грузовой сундук

Этот ящик должен быть установлен под лебедкой на расстоянии до 10 блоков и заполнен булыжником, гравием или песком. Если минимальный вес стопки (99+ предметов) достигнут и есть избыток энергии, ящик автоматически подключается к лебедке с помощью веревки и подтягивается вверх. 

[ta2_weight_chest|image]


### TA2 Сцепление

С помощью муфты сцепления оси и машины могут быть отделены от накопителя энергии. Это означает, что оси после сцепления останавливаются, а системы машин могут быть остановлены. При сборке муфты убедитесь, что стрелка на верхней части блока направлена на систему накопления энергии.

[techage:ta2_clutch_off|image]


## Толкатель и сортировка предметов

Для транспортировки предметов от одной станции обработки к другой используются толкатели и трубы. См. план.

[itemtransport|plan]


### TechAge труба

Две машины могут быть соединены с помощью толкателя и трубы. Трубы не имеют ответвлений. Максимальная длина - 200 м (блоков).
Кроме того, трубы можно размещать с помощью клавиши Shift. Это позволяет, например, прокладывать трубы параллельно, не допуская их случайного соединения.
Пропускная способность трубы неограниченна и ограничивается только толкателем.

[tube|image]

### Концентратор труб

Несколько труб можно объединить в одну с помощью концентратора. Направление, в котором передаются все предметы, отмечено стрелкой.

[concentrator|image]

### TA2 Толкатель

Толкатель может вытаскивать предметы из ящиков или машин и заталкивать их в другие ящики или машины. Другими словами, между двумя блоками с инвентарем должен быть один и только один толкатель. Несколько толкателей в ряд не работают.

В противоположном направлении, однако, толкатель проницаем для предметов, так что ящик может быть заполнен через трубку, а также настроен.

Толкатель переходит в состояние «ожидания», если у него нет предметов для толкания. Если выход заблокирован или инвентарь получателя переполнен, толкатель переходит в состояние «заблокировано». Если ситуация изменилась, толкатель автоматически выходит из обоих состояний через несколько секунд.

Мощность обработки толкателя TA2 составляет 2 предмета каждые 2 с.

[ta2_pusher|image]


### TA2 Распределитель

Распределитель может перемещать предметы из своего инвентаря, отсортированные в четырёх направлениях. Для этого распределитель должен быть настроен соответствующим образом.

Распределитель имеет меню с 4 фильтрами разного цвета, соответствующими 4 выходам. Если какой-либо выход будет использоваться, соответствующий фильтр должен быть активирован с помощью флажка «включено». Все элементы, сконфигурированные для этого фильтра, будут выводиться через назначенный выход. Если фильтр активирован без настроенных элементов, речь идет о «ненастроенном», открытом выходе.

**Внимание: Распределитель также является толкателем на своих выходных сторонах. Поэтому никогда не вытаскивайте предметы из распределителя с помощью толкателя!

Для неконфигурированного выхода существует два режима работы:

1) Выводятся все предметы, которые не могут быть выведены ни на какой другой выход, даже если они заблокированы.

2) Выводить только те предметы, которые не были настроены ни на какой другой фильтр.

В первом случае все элементы всегда пересылаются, и распределитель не переполняется. Во втором случае элементы задерживаются, и распределитель может быть переполнен, а затем заблокирован.

Режим работы можно установить с помощью флажка «Режим блокировки».

Мощность обработки распределителя TA2 составляет 4 элемента каждые 2 с, при этом распределитель пытается распределить 4 элемента по открытым выходам.

Если один и тот же элемент конфигурируется несколько раз в одном фильтре, коэффициент распределения будет соответствовать в долгосрочной перспективе.

Обратите внимание, что распределение является вероятностным процессом. Это означает, что соотношение распределений не будет совпадать точно, но только в долгосрочной перспективе.

Максимальный размер стака в фильтрах - 12; всего можно настроить не более 36 элементов


[ta2_distributor|image]


## Промывка гравия

Промывка гравия - это более сложная машина, цель которой - намыть самородки усмия из просеянного гравия. Для установки требуется TA2 Промыватель  с механическим приводом, воронка, емкость и проточная вода.

Структура слева направо (см. также план):

* блок земли, на нем источник воды, окруженный с трех сторон, например, стеклянными блоками
* рядом с ним промыватель для гравия, при необходимости с трубами для подачи и удаления гравия
* затем бункер с сундуком.

Все это окружено стеклянными блоками, чтобы вода стекала по промывателю к воронке, а промытые самородки могли быть собраны бункером.

[gravelrinser|plan]


### TA2 Промыватель

Гравийный промыватель способен промывать усмиевые и медные руды из гравия, который уже был просеян, при условии, что он покрыт водой.

Правильность работы гравиопромывателя можно проверить с помощью палочек, если поместить их в инвентарь промывателя. Их нужно класть по отдельности и вылавливать из воронки.

Производительность составляет один предмет гравия каждые 2 с. Гравиемойке требуется 3 кю энергии.

[ta2_rinser|image]


## Добыча камня, измельчение и просеивание

Дробление, измельчение и просеивание булыжника используется для добычи руд. Просеянный гравий можно использовать и для других целей. Карьер, измельчитель и сито должны быть приводными, поэтому их устанавливают рядом с паровым двигателем.

[ta2_grinder|image].


### TA2 Карьер

Карьер используется для извлечения камня и других материалов из-под земли. Карьер выкапывает яму размером 5x5 блоков. Глубину можно регулировать.
Производительность составляет один блок каждые 4 с. Карьеру требуется 10 ku энергии. Максимальная глубина - 20 метров. Для большей глубины смотрите TA3 / TA4.

[ta2_quarry|image]


### TA2 Измельчитель

Измельчитель способен перемалывать различные камни, а также дерево и другие предметы.
Производительность составляет один предмет каждые 4 с. Измельчителю требуется 4 ku энергии.

[ta2_grinder|image]


### TA2 Просеиватель

Просеиватель способен просеивать гравий для извлечения руды. В результате получается гравий и просеянный гравий, который нельзя просеять снова.
Производительность составляет один предмет каждые 4 с. Сеялка гравия требует 3 ku энергии.

[ta2_gravelsieve|image]


## Производство предметов

Машины TA2 могут не только добывать руду, но и производить предметы.


### TA2 Автокрафтер

Автокрафтер используется для автоматического производства предметов. Все, что игрок может произвести через «окно крафта», может сделать и автокрафтер. Для этого нужно ввести рецепт в меню автокрафтера и добавить необходимые ингредиенты.

Ингредиенты и изготовленные предметы можно перемещать в блок и из него с помощью труб и толкателей.

Производительность составляет один предмет каждые 4 с. Автокрафтер требует 4 ku энергии.

[ta2_autocrafter|image]


### TA2 Фабрика электроники

фабрика электроники - это специальная машина, которая может быть использована только для производства радиоламп. Радиолампы требуются для машин и блоков TA3.

Мощность обработки составляет одну радиолампу каждые 6 с. фабрика электроники требует 8 ku энергии.

[ta2_electronicfab|image]


## Другие блоки

### TA2 Наполнитель жидкости

Для некоторых рецептов требуется вода. Чтобы эти рецепты можно было обрабатывать автоматически с помощью автокрафтера, вода должна подаваться в ведрах. Для этого используется наполнитель жидкости. Ему нужны пустые ведра, которые он наполнит водой.

Производительность обработки - одно ведро воды каждые 8 с. Наполнитель жидкости требует 3 ku энергии.

[ta2_liquidsampler|image]


### TA2 Защищенный сундук

Защищенный сундук может быть использован только игроками, которые могут строить в этом месте, т.е. имеют право доступа на защищеной территории. При этом не имеет значения, кто устанавливает сундук.

[ta2_chest|image]


### Блок загрузки карты

Minetest делит карту на так называемые блоки карты. Это кубы с длиной грани 16x16x16 блоков. Такой блок карты всегда загружается сервером полностью, но загружаются только блоки вокруг игрока (примерно 2-3 блока во всех направлениях). В направлении взгляда игрока больше блоков карты. Только эта часть мира активна, и только здесь растут растения и деревья или работают машины.

С помощью блока загрузки карты (forceload) вы можете заставить блок карты, в котором находится блок загрузки, оставаться загруженным до тех пор, пока вы находитесь на сервере. Когда все ваши фермы и машины покрыты блоками блоками загрузки, все всегда работает.

Блоки карты с их координатами предопределены, например (0,0,0) - (15,15,15), или (16,16,16) - (31,31,31).
Вы можете перемещать блок загрузки карты внутри блока карты как угодно, положение блока карты остается неизменным.

[ta2_forceload|image]
